/*
 * Decompiled with CFR 0.152.
 */
package org.apache.excalibur.altrmi.client.impl;

import java.lang.reflect.Array;
import org.apache.excalibur.altrmi.client.AltrmiClientInvocationHandler;
import org.apache.excalibur.altrmi.client.AltrmiProxy;
import org.apache.excalibur.altrmi.client.ProxyHelper;
import org.apache.excalibur.altrmi.client.impl.AbstractAltrmiFactory;
import org.apache.excalibur.altrmi.common.AltrmiInvocationException;
import org.apache.excalibur.altrmi.common.AltrmiReply;
import org.apache.excalibur.altrmi.common.AltrmiRequest;
import org.apache.excalibur.altrmi.common.ExceptionReply;
import org.apache.excalibur.altrmi.common.GarbageCollectionReply;
import org.apache.excalibur.altrmi.common.GarbageCollectionRequest;
import org.apache.excalibur.altrmi.common.MethodFacadeArrayReply;
import org.apache.excalibur.altrmi.common.MethodFacadeReply;
import org.apache.excalibur.altrmi.common.MethodFacadeRequest;
import org.apache.excalibur.altrmi.common.MethodReply;
import org.apache.excalibur.altrmi.common.MethodRequest;

public final class DefaultProxyHelper
implements ProxyHelper {
    private final transient AbstractAltrmiFactory mAltrmiFactory;
    private final transient AltrmiClientInvocationHandler mClientInvocationHandler;
    private final transient String mPublishedServiceName;
    private final transient String mObjectName;
    private final transient Long mReferenceID;
    private final transient Long mSession;

    public DefaultProxyHelper(AbstractAltrmiFactory altrmiFactory, AltrmiClientInvocationHandler clientInvocationHandler, String pubishedServiceName, String objectName, Long referenceID, Long session) {
        this.mAltrmiFactory = altrmiFactory;
        this.mClientInvocationHandler = clientInvocationHandler;
        this.mPublishedServiceName = pubishedServiceName;
        this.mObjectName = objectName;
        this.mReferenceID = referenceID;
        this.mSession = session;
    }

    public void registerImplObject(Object implBean) {
        this.mAltrmiFactory.registerReferenceObject(implBean, this.mReferenceID);
    }

    public Object processObjectRequestGettingFacade(Class returnClassType, String methodSignature, Object[] args, String objectName) throws Throwable {
        boolean arrayRetVal = objectName.endsWith("[]");
        String objNameWithoutArray = objectName.substring(0, objectName.length() - 2);
        MethodFacadeRequest request = arrayRetVal ? new MethodFacadeRequest(this.mPublishedServiceName, this.mObjectName, methodSignature, args, this.mReferenceID, objNameWithoutArray, this.mSession) : new MethodFacadeRequest(this.mPublishedServiceName, this.mObjectName, methodSignature, args, this.mReferenceID, objectName, this.mSession);
        AltrmiReply reply = this.mClientInvocationHandler.handleInvocation((AltrmiRequest)request);
        if (reply.getReplyCode() == 5) {
            MethodFacadeReply mfr = (MethodFacadeReply)reply;
            Long ref = mfr.getReferenceID();
            if (ref == null) {
                return null;
            }
            Object implBean = this.mAltrmiFactory.getImplObj(ref);
            if (implBean == null) {
                DefaultProxyHelper pHelper = new DefaultProxyHelper(this.mAltrmiFactory, this.mClientInvocationHandler, this.mPublishedServiceName, mfr.getObjectName(), ref, this.mSession);
                Object retFacade = this.mAltrmiFactory.getInstance(this.mPublishedServiceName, mfr.getObjectName(), pHelper, this.mAltrmiFactory.isBeanOnly());
                pHelper.registerImplObject(retFacade);
                return retFacade;
            }
            return implBean;
        }
        if (reply.getReplyCode() == 9) {
            MethodFacadeArrayReply mfar = (MethodFacadeArrayReply)reply;
            Long[] refs = mfar.getReferenceIDs();
            String[] objectNames = mfar.getObjectNames();
            Object[] implBeans = (Object[])Array.newInstance(returnClassType, refs.length);
            int i = 0;
            while (i < refs.length) {
                Long ref = refs[i];
                if (ref == null) {
                    implBeans[i] = null;
                } else {
                    Object o;
                    implBeans[i] = o = this.mAltrmiFactory.getImplObj(ref);
                    if (implBeans[i] == null) {
                        DefaultProxyHelper bo2 = new DefaultProxyHelper(this.mAltrmiFactory, this.mClientInvocationHandler, this.mPublishedServiceName, objectNames[i], refs[i], this.mSession);
                        Object retFacade = null;
                        try {
                            retFacade = this.mAltrmiFactory.getInstance(this.mPublishedServiceName, objectNames[i], bo2, this.mAltrmiFactory.isBeanOnly());
                        }
                        catch (Exception e) {
                            System.out.println("objNameWithoutArray=" + returnClassType.getName());
                            System.out.flush();
                            e.printStackTrace();
                        }
                        bo2.registerImplObject(retFacade);
                        implBeans[i] = retFacade;
                    }
                }
                ++i;
            }
            return implBeans;
        }
        if (reply.getReplyCode() == 3) {
            ExceptionReply er = (ExceptionReply)reply;
            throw er.getReplyException();
        }
        throw new AltrmiInvocationException("Internal Error : Unknown reply type :" + reply.getClass().getName());
    }

    public Object processObjectRequest(String methodSignature, Object[] args, Class[] argClasses) throws Throwable {
        this.mAltrmiFactory.marshallCorrection(methodSignature, args, argClasses);
        MethodRequest request = new MethodRequest(this.mPublishedServiceName, this.mObjectName, methodSignature, args, this.mReferenceID, this.mSession);
        AltrmiReply reply = this.mClientInvocationHandler.handleInvocation((AltrmiRequest)request);
        if (reply.getReplyCode() == 2) {
            MethodReply or = (MethodReply)reply;
            return or.getReplyObject();
        }
        if (reply.getReplyCode() == 3) {
            ExceptionReply er = (ExceptionReply)reply;
            throw er.getReplyException();
        }
        throw new AltrmiInvocationException("Internal Error : Unknown reply type :" + reply.getClass().getName());
    }

    public void processVoidRequest(String methodSignature, Object[] args) throws Throwable {
        MethodRequest request = new MethodRequest(this.mPublishedServiceName, this.mObjectName, methodSignature, args, this.mReferenceID, this.mSession);
        AltrmiReply reply = this.mClientInvocationHandler.handleInvocation((AltrmiRequest)request);
        if (reply.getReplyCode() == 2) {
            MethodReply or = (MethodReply)reply;
            return;
        }
        if (reply.getReplyCode() == 3) {
            ExceptionReply er = (ExceptionReply)reply;
            throw er.getReplyException();
        }
        throw new AltrmiInvocationException("Internal Error : Unknown reply type :" + reply.getClass().getName());
    }

    public void processVoidRequestWithRedirect(String methodSignature, Object[] args) throws Throwable {
        Object[] newArgs = new Object[args.length];
        int i = 0;
        while (i < args.length) {
            if (!(args[i] instanceof AltrmiProxy)) {
                newArgs[i] = args[i];
            }
            ++i;
        }
        this.processVoidRequest(methodSignature, newArgs);
    }

    private void debug(Object[] args) {
        int i = 0;
        while (i < args.length) {
            Object arg = args[i];
            System.out.println("i = " + i + " class= " + args[i].getClass().getName() + " " + args[i].toString());
            ++i;
        }
    }

    public Long getReferenceID(Object factory) {
        if (factory == this.mAltrmiFactory) {
            return this.mReferenceID;
        }
        return null;
    }

    protected void finalize() throws Throwable {
        AbstractAltrmiFactory abstractAltrmiFactory = this.mAltrmiFactory;
        synchronized (abstractAltrmiFactory) {
            AltrmiReply reply = this.mClientInvocationHandler.handleInvocation((AltrmiRequest)new GarbageCollectionRequest(this.mPublishedServiceName, this.mObjectName, this.mSession, this.mReferenceID));
            if (!(reply instanceof GarbageCollectionReply)) {
                System.err.println("----> Some problem during DGC! Make sure factory is closed.");
            }
        }
        super.finalize();
    }
}

