/*
 * Decompiled with CFR 0.152.
 */
package org.apache.excalibur.altrmi.client.impl;

import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.util.HashMap;
import org.apache.excalibur.altrmi.client.impl.AbstractAltrmiFactory;
import org.apache.excalibur.altrmi.client.impl.DefaultProxyHelper;
import org.apache.excalibur.altrmi.client.impl.TransportedClassLoader;
import org.apache.excalibur.altrmi.common.AltrmiConnectionException;
import org.apache.excalibur.altrmi.common.AltrmiReply;
import org.apache.excalibur.altrmi.common.AltrmiRequest;
import org.apache.excalibur.altrmi.common.ClassReply;
import org.apache.excalibur.altrmi.common.ClassRequest;
import org.apache.excalibur.altrmi.common.ClassRetrievalFailedReply;
import org.apache.excalibur.altrmi.common.NotPublishedException;
import org.apache.excalibur.altrmi.common.RequestFailedReply;

public class ServerClassAltrmiFactory
extends AbstractAltrmiFactory {
    private HashMap mPublishedServiceClassLoaders = new HashMap();

    public ServerClassAltrmiFactory(boolean beanOnly) {
        super(beanOnly);
    }

    protected Class getFacadeClass(String publishedServiceName, String objectName, boolean beanOnly) throws AltrmiConnectionException, ClassNotFoundException {
        String code = "2";
        if (beanOnly) {
            code = "";
        }
        TransportedClassLoader tcl = null;
        String beanClassName = "AltrmiGenerated" + publishedServiceName + "_" + objectName;
        String iiClassName = "AltrmiGenerated2" + publishedServiceName + "_" + objectName;
        String className = "AltrmiGenerated" + code + publishedServiceName + "_" + objectName;
        if (this.mPublishedServiceClassLoaders.containsKey(beanClassName)) {
            tcl = (TransportedClassLoader)this.mPublishedServiceClassLoaders.get(beanClassName);
        } else {
            ClassReply cr = null;
            try {
                AltrmiReply ar = this.m_hostContext.getClientInvocationHandler().handleInvocation((AltrmiRequest)new ClassRequest(publishedServiceName, objectName));
                if (ar.getReplyCode() >= 100) {
                    if (ar instanceof RequestFailedReply) {
                        throw new AltrmiConnectionException(((RequestFailedReply)ar).getFailureReason());
                    }
                    if (ar instanceof ClassRetrievalFailedReply) {
                        ClassRetrievalFailedReply crfr = (ClassRetrievalFailedReply)ar;
                        throw new AltrmiConnectionException("Class Retrieval Failed - " + crfr.getReason());
                    }
                }
                cr = (ClassReply)ar;
            }
            catch (NotPublishedException npe) {
                throw new AltrmiConnectionException("Service " + publishedServiceName + " not published on Server");
            }
            tcl = new TransportedClassLoader(this.m_hostContext.getClientInvocationHandler().getInterfacesClassLoader());
            tcl.add(beanClassName, cr.getBeanClassBytes());
            try {
                byte[] bytes = cr.getInterfaceImplClassBytes();
                tcl.add(iiClassName, bytes);
            }
            catch (NoClassDefFoundError ncdfe) {
                // empty catch block
            }
            this.mPublishedServiceClassLoaders.put(beanClassName, tcl);
        }
        return tcl.loadClass(className);
    }

    protected Object getInstance(String publishedServiceName, String objectName, DefaultProxyHelper proxyHelper, boolean beanOnly) throws AltrmiConnectionException {
        String code = "2";
        if (beanOnly) {
            code = "";
        }
        try {
            Class clazz = this.getFacadeClass(publishedServiceName, objectName, beanOnly);
            Constructor<?>[] constructors = clazz.getConstructors();
            Object retVal = constructors[0].newInstance(proxyHelper);
            return retVal;
        }
        catch (InvocationTargetException ite) {
            throw new AltrmiConnectionException("Generated class not instantiated : " + ite.getTargetException().getMessage());
        }
        catch (ClassNotFoundException cnfe) {
            System.out.println("---**");
            cnfe.printStackTrace();
            System.out.println("---**");
            cnfe.getException().printStackTrace();
            System.out.println("---**");
            throw new AltrmiConnectionException("Generated class not found during lookup : " + cnfe.getMessage());
        }
        catch (InstantiationException ie) {
            throw new AltrmiConnectionException("Generated class not instantiable during lookup : " + ie.getMessage());
        }
        catch (IllegalAccessException iae) {
            throw new AltrmiConnectionException("Illegal access to generated class during lookup : " + iae.getMessage());
        }
    }

    public void close() {
        this.m_hostContext.getClientInvocationHandler().close();
    }
}

