/*
 * Decompiled with CFR 0.152.
 */
package org.apache.excalibur.altrmi.client.impl.callback.stream;

import java.io.BufferedOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.HashMap;
import org.apache.excalibur.altrmi.client.impl.stream.ClientStreamReadWriter;
import org.apache.excalibur.altrmi.common.AltrmiCallbackException;
import org.apache.excalibur.altrmi.common.AltrmiReply;
import org.apache.excalibur.altrmi.common.AltrmiRequest;
import org.apache.excalibur.altrmi.common.SerializationHelper;
import org.apache.excalibur.altrmi.server.AltrmiServer;
import org.apache.excalibur.altrmi.server.ClassRetriever;
import org.apache.excalibur.altrmi.server.PublicationException;
import org.apache.excalibur.altrmi.server.impl.classretrievers.PlainClassRetriever;
import org.apache.excalibur.altrmi.server.impl.direct.DirectServer;

public class CallbackEnabledClientCustomStreamReadWriter
extends ClientStreamReadWriter
implements Runnable {
    private Object m_replyLock = new Object();
    private AltrmiReply m_reply = null;
    private Thread m_messageLoopThread = null;
    private boolean m_isStopped = false;
    private DataInputStream m_dataInputStream;
    private DataOutputStream m_dataOutputStream;
    private ClassLoader m_interfacesClassLoader;
    private HashMap m_exposedObjPublishNameHash_ = new HashMap();
    private AltrmiServer m_clientServerHostingExposedObjects = new DirectServer();
    private static int m_random = 0;

    public CallbackEnabledClientCustomStreamReadWriter(InputStream inputStream, OutputStream outputStream, ClassLoader interfacesClassLoader) throws IOException {
        this.m_dataOutputStream = new DataOutputStream(new BufferedOutputStream(outputStream));
        this.m_dataInputStream = new DataInputStream(inputStream);
        this.m_interfacesClassLoader = interfacesClassLoader;
        this.m_messageLoopThread = new Thread((Runnable)this, "CallbackEnabledClientStream Thread");
        this.m_messageLoopThread.start();
        try {
            this.m_clientServerHostingExposedObjects.start();
            this.m_clientServerHostingExposedObjects.setClassRetriever((ClassRetriever)new PlainClassRetriever());
        }
        catch (Exception e) {
            throw new IOException("Error Starting Internal AltrmiServer");
        }
    }

    public void run() {
        boolean readingInt = false;
        while (!this.m_isStopped) {
            try {
                readingInt = true;
                int byteArraySize = this.m_dataInputStream.readInt();
                readingInt = false;
                byte[] byteArray = new byte[byteArraySize];
                this.m_dataInputStream.read(byteArray);
                Object obj = SerializationHelper.getInstanceFromBytes((byte[])byteArray, (ClassLoader)this.m_interfacesClassLoader);
                if (obj instanceof AltrmiReply) {
                    this.m_reply = (AltrmiReply)obj;
                    Object object = this.m_replyLock;
                    synchronized (object) {
                        this.m_replyLock.notify();
                        continue;
                    }
                }
                if (!(obj instanceof AltrmiRequest)) continue;
                AltrmiReply altrmiReply = this.m_clientServerHostingExposedObjects.handleInvocation((AltrmiRequest)obj);
                this.postReply(altrmiReply);
            }
            catch (IOException e) {
                if (!(e instanceof EOFException) || !readingInt) {
                    if (e.getClass().getName().equals("java.net.SocketTimeoutException")) continue;
                    e.printStackTrace();
                }
                this.m_isStopped = true;
                return;
            }
            catch (ClassNotFoundException e) {
                e.printStackTrace();
            }
        }
    }

    public AltrmiReply getReplyFromMessageLoop() {
        if (this.m_reply == null) {
            Object object = this.m_replyLock;
            synchronized (object) {
                try {
                    this.m_replyLock.wait();
                }
                catch (InterruptedException e) {
                    e.printStackTrace();
                }
            }
        }
        return this.m_reply;
    }

    protected AltrmiReply postRequest(AltrmiRequest altrmiRequest) throws IOException, ClassNotFoundException {
        if (this.m_isStopped) {
            throw new IOException("Server Stoppped");
        }
        this.writeRequest(altrmiRequest);
        AltrmiReply r = this.readReply();
        this.m_reply = null;
        return r;
    }

    private void writeRequest(AltrmiRequest altrmiRequest) throws IOException {
        byte[] aBytes = SerializationHelper.getBytesFromInstance((Object)altrmiRequest);
        this.m_dataOutputStream.writeInt(aBytes.length);
        this.m_dataOutputStream.write(aBytes);
        this.m_dataOutputStream.flush();
    }

    private AltrmiReply readReply() throws IOException, ClassNotFoundException {
        return this.getReplyFromMessageLoop();
    }

    public void postReply(AltrmiReply altrmiReply) throws IOException, ClassNotFoundException {
        byte[] aBytes = SerializationHelper.getBytesFromInstance((Object)altrmiReply);
        this.m_dataOutputStream.writeInt(aBytes.length);
        this.m_dataOutputStream.write(aBytes);
        this.m_dataOutputStream.flush();
    }

    public boolean exposeObject(Object tobeExposedObject, Class tobeExposedInterface) throws AltrmiCallbackException {
        if (this.m_exposedObjPublishNameHash_.get(tobeExposedObject) != null) {
            return false;
        }
        String _uniquePublishedName = this.getUniqueNameForExposedObject(tobeExposedObject);
        this.m_exposedObjPublishNameHash_.put(tobeExposedObject, _uniquePublishedName);
        try {
            this.m_clientServerHostingExposedObjects.publish(tobeExposedObject, _uniquePublishedName, tobeExposedInterface);
        }
        catch (PublicationException pce) {
            throw new AltrmiCallbackException(pce.getMessage());
        }
        return true;
    }

    private String getUniqueNameForExposedObject(Object tobeExposedObject) {
        return tobeExposedObject.getClass().getName().substring(tobeExposedObject.getClass().getName().lastIndexOf(".") + 1) + "_" + ++m_random;
    }

    public String getPublishedName(Object tobeExposedObject) {
        return (String)this.m_exposedObjPublishNameHash_.get(tobeExposedObject);
    }
}

