/*
 * Decompiled with CFR 0.152.
 */
package org.apache.excalibur.altrmi.client.impl.direct;

import java.io.IOException;
import org.apache.excalibur.altrmi.client.AltrmiConnectionListener;
import org.apache.excalibur.altrmi.client.impl.AbstractClientInvocationHandler;
import org.apache.excalibur.altrmi.common.AltrmiInvocationException;
import org.apache.excalibur.altrmi.common.AltrmiReply;
import org.apache.excalibur.altrmi.common.AltrmiRequest;
import org.apache.excalibur.altrmi.common.MethodRequest;
import org.apache.excalibur.altrmi.common.NoSuchReferenceException;
import org.apache.excalibur.altrmi.common.NoSuchReferenceReply;
import org.apache.excalibur.altrmi.common.NotPublishedException;
import org.apache.excalibur.altrmi.common.NotPublishedReply;
import org.apache.excalibur.altrmi.common.PublishedNameRequest;
import org.apache.excalibur.altrmi.common.TryLaterReply;

public abstract class AbstractDirectInvocationHandler
extends AbstractClientInvocationHandler {
    protected boolean mMethodLogging = false;
    protected long mLastRealRequest = System.currentTimeMillis();

    public void setAltrmiConnectionListener(AltrmiConnectionListener altrmiConnectionListener) {
        super.setAltrmiConnectionListener(altrmiConnectionListener);
        this.mMethodLogging = altrmiConnectionListener.methodLogging();
    }

    public AltrmiReply handleInvocation(AltrmiRequest request) {
        if (request.getRequestCode() != 306) {
            this.mLastRealRequest = System.currentTimeMillis();
        }
        boolean again = true;
        AltrmiReply reply = null;
        int tries = 0;
        long start = 0L;
        if (this.mMethodLogging) {
            start = System.currentTimeMillis();
        }
        while (again) {
            ++tries;
            again = false;
            try {
                reply = this.performInvocation(request);
            }
            catch (IOException ioe) {
                ioe.printStackTrace();
            }
            if (reply.getReplyCode() < 100) continue;
            if (reply instanceof TryLaterReply) {
                int millis = ((TryLaterReply)reply).getSuggestedDelayMillis();
                this.mAltrmiConnectionListener.serviceSuspended(request, tries, millis);
                again = true;
                continue;
            }
            if (reply instanceof NoSuchReferenceReply) {
                throw new NoSuchReferenceException(((NoSuchReferenceReply)reply).getReferenceID());
            }
            if (!(reply instanceof NotPublishedReply)) continue;
            PublishedNameRequest pnr = (PublishedNameRequest)request;
            throw new NotPublishedException(pnr.getPublishedServiceName(), pnr.getObjectName());
        }
        if (this.mMethodLogging && request instanceof MethodRequest) {
            this.mAltrmiConnectionListener.methodCalled(((MethodRequest)request).getMethodSignature(), System.currentTimeMillis() - start);
        }
        return reply;
    }

    protected boolean tryReconnect() {
        throw new AltrmiInvocationException("Direct connection broken, unable to reconnect.");
    }

    public long getLastRealRequest() {
        return this.mLastRealRequest;
    }

    protected abstract AltrmiReply performInvocation(AltrmiRequest var1) throws IOException;
}

