/*
 * Decompiled with CFR 0.152.
 */
package org.apache.excalibur.altrmi.client.impl.direct;

import java.io.IOException;
import org.apache.excalibur.altrmi.client.impl.direct.AbstractDirectInvocationHandler;
import org.apache.excalibur.altrmi.common.AltrmiConnectionException;
import org.apache.excalibur.altrmi.common.AltrmiMarshalledInvocationHandler;
import org.apache.excalibur.altrmi.common.AltrmiReply;
import org.apache.excalibur.altrmi.common.AltrmiRequest;
import org.apache.excalibur.altrmi.common.RequestFailedReply;
import org.apache.excalibur.altrmi.common.SerializationHelper;

public final class DirectMarshalledInvocationHandler
extends AbstractDirectInvocationHandler {
    private AltrmiMarshalledInvocationHandler mAltrmiInvocationHandler;
    private ClassLoader mInterfacesClassLoader;

    public DirectMarshalledInvocationHandler(AltrmiMarshalledInvocationHandler altrmiInvocationHandler) throws AltrmiConnectionException {
        this.mAltrmiInvocationHandler = altrmiInvocationHandler;
        this.mInterfacesClassLoader = this.getClass().getClassLoader();
    }

    public DirectMarshalledInvocationHandler(AltrmiMarshalledInvocationHandler altrmiInvocationHandler, ClassLoader classLoader) throws AltrmiConnectionException {
        this.mAltrmiInvocationHandler = altrmiInvocationHandler;
        this.mInterfacesClassLoader = classLoader;
    }

    protected AltrmiReply performInvocation(AltrmiRequest request) throws IOException {
        try {
            byte[] serRequest = SerializationHelper.getBytesFromInstance((Object)request);
            byte[] serReply = this.mAltrmiInvocationHandler.handleInvocation(serRequest);
            return (AltrmiReply)SerializationHelper.getInstanceFromBytes((byte[])serReply, (ClassLoader)this.mInterfacesClassLoader);
        }
        catch (IOException e) {
            e.printStackTrace();
            return new RequestFailedReply("Some IO Exception on server side : " + e.getMessage());
        }
        catch (ClassNotFoundException e) {
            e.printStackTrace();
            return new RequestFailedReply("Some Class not found Exception on server side : " + e.getMessage());
        }
    }

    public ClassLoader getInterfacesClassLoader() {
        return this.mInterfacesClassLoader;
    }
}

