/*
 * Decompiled with CFR 0.152.
 */
package org.apache.excalibur.altrmi.client.impl.multiple;

import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import org.apache.excalibur.altrmi.client.AltrmiClientInvocationHandler;
import org.apache.excalibur.altrmi.client.impl.multiple.AbstractMultipleInvocationHandler;
import org.apache.excalibur.altrmi.common.AltrmiInvocationException;
import org.apache.excalibur.altrmi.common.AltrmiReply;
import org.apache.excalibur.altrmi.common.AltrmiRequest;
import org.apache.excalibur.altrmi.common.OpenConnectionReply;
import org.apache.excalibur.altrmi.common.OpenConnectionRequest;
import org.apache.excalibur.altrmi.common.PingReply;
import org.apache.excalibur.altrmi.common.PingRequest;
import org.apache.excalibur.altrmi.common.Sessionable;

public class RotatingMultipleInvocationHandler
extends AbstractMultipleInvocationHandler {
    private HashMap mSessionHandlerMap = new HashMap();
    private int mNext;

    public AltrmiReply handleInvocation(AltrmiRequest request) {
        if (request instanceof Sessionable) {
            Long session = ((Sessionable)request).getSession();
            if (this.mSessionHandlerMap.containsKey(session)) {
                AltrmiClientInvocationHandler cih = (AltrmiClientInvocationHandler)this.mSessionHandlerMap.get(session);
                return cih.handleInvocation(request);
            }
            throw new AltrmiInvocationException("No handler registered for ths session");
        }
        if (request instanceof OpenConnectionRequest) {
            AltrmiClientInvocationHandler cih;
            AltrmiReply ar;
            List hostContexts = this.mMultipleHostContext.getHostContexts();
            if (this.mNext >= hostContexts.size()) {
                this.mNext = 0;
            }
            if ((ar = (cih = (AltrmiClientInvocationHandler)hostContexts.get(this.mNext++)).handleInvocation(request)) instanceof OpenConnectionReply) {
                Long session = ((OpenConnectionReply)ar).getSession();
                this.mSessionHandlerMap.put(session, cih);
            }
            return ar;
        }
        if (request instanceof PingRequest) {
            AltrmiReply pingReply = null;
            List hostContexts = this.mMultipleHostContext.getHostContexts();
            Iterator iterator = hostContexts.iterator();
            while (iterator.hasNext()) {
                AltrmiClientInvocationHandler cih = (AltrmiClientInvocationHandler)iterator.next();
                try {
                    AltrmiReply ar = cih.handleInvocation(request);
                    if (pingReply != null || !(ar instanceof PingReply)) continue;
                    pingReply = ar;
                }
                catch (Exception e) {
                    // empty catch block
                }
            }
            return pingReply;
        }
        List hostContexts = this.mMultipleHostContext.getHostContexts();
        return ((AltrmiClientInvocationHandler)hostContexts.get(0)).handleInvocation(request);
    }
}

