/*
 * Decompiled with CFR 0.152.
 */
package org.apache.excalibur.altrmi.client.impl.naming;

import java.util.Hashtable;
import javax.naming.Context;
import javax.naming.Name;
import javax.naming.NameParser;
import javax.naming.NamingEnumeration;
import javax.naming.NamingException;
import org.apache.excalibur.altrmi.client.AltrmiInterfaceLookup;
import org.apache.excalibur.altrmi.client.AltrmiInterfaceLookupFactory;
import org.apache.excalibur.altrmi.client.impl.DefaultInterfaceLookupFactory;
import org.apache.excalibur.altrmi.common.AltrmiConnectionException;

public class DefaultAltrmiContext
implements Context {
    AltrmiInterfaceLookupFactory altrmiInterfaceLookupFactory = new DefaultInterfaceLookupFactory();
    AltrmiInterfaceLookup altrmiInterfaceLookup = null;

    DefaultAltrmiContext(String host, String port, String transportStream, Hashtable env) throws NamingException {
        boolean optimize;
        String proxyDetails = null;
        String beanDetails = null;
        ClassLoader interfacesClassLoader = null;
        proxyDetails = (String)env.get("proxy.type");
        if (proxyDetails == null) {
            proxyDetails = "S";
        } else if (proxyDetails.equals("ClientSideClasses")) {
            proxyDetails = "C";
        } else if (proxyDetails.equals("ServerSideClasses")) {
            proxyDetails = "S";
        } else {
            throw new NamingException("proxy.type should be 'ClientSideClasses' or 'ServerSideClasses', you specified " + proxyDetails);
        }
        beanDetails = (String)env.get("bean.type");
        if (beanDetails == null) {
            beanDetails = "NBO";
        } else if (beanDetails.equals("NotBeanOnly")) {
            beanDetails = "NBO";
        } else if (beanDetails.equals("BeanOnly")) {
            beanDetails = "BO";
        } else {
            throw new NamingException("proxy.type should be 'BeanOnly' or 'NotBeanOnly', you specified " + beanDetails);
        }
        String optimizeStr = (String)env.get("optimize");
        if (optimizeStr == null) {
            optimize = true;
        } else if (optimizeStr.equals("true")) {
            optimize = true;
        } else if (optimizeStr.equals("false")) {
            optimize = false;
        } else {
            throw new NamingException("optimize should be 'true' or 'false', you specified " + optimizeStr);
        }
        interfacesClassLoader = (ClassLoader)env.get("interfaces.classloader");
        if (interfacesClassLoader == null) {
            interfacesClassLoader = this.getClass().getClassLoader();
        }
        try {
            this.altrmiInterfaceLookup = this.altrmiInterfaceLookupFactory.getAltrmiInterfaceLookup(transportStream + ":" + host + ":" + port + ":" + proxyDetails + ":" + beanDetails, interfacesClassLoader, optimize);
        }
        catch (AltrmiConnectionException ace) {
            ace.printStackTrace();
            throw new NamingException(ace.getMessage());
        }
    }

    public Object lookup(Name name) throws NamingException {
        return null;
    }

    public Object lookup(String name) throws NamingException {
        try {
            return this.altrmiInterfaceLookup.lookup(name);
        }
        catch (AltrmiConnectionException ace) {
            ace.printStackTrace();
            throw new NamingException(ace.getMessage());
        }
    }

    public void bind(Name name, Object obj) throws NamingException {
    }

    public void bind(String name, Object obj) throws NamingException {
    }

    public void rebind(Name name, Object obj) throws NamingException {
    }

    public void rebind(String name, Object obj) throws NamingException {
    }

    public void unbind(Name name) throws NamingException {
    }

    public void unbind(String name) throws NamingException {
    }

    public void rename(Name oldName, Name newName) throws NamingException {
    }

    public void rename(String oldName, String newName) throws NamingException {
    }

    public NamingEnumeration list(Name name) throws NamingException {
        return null;
    }

    public NamingEnumeration list(String name) throws NamingException {
        final String[] names = this.altrmiInterfaceLookup.list();
        return new NamingEnumeration(){
            int size;
            int index;
            {
                this.size = names.length;
                this.index = 0;
            }

            public void close() {
            }

            public boolean hasMore() {
                return this.index < names.length;
            }

            public Object next() {
                return names[this.index++];
            }

            public boolean hasMoreElements() {
                return this.hasMore();
            }

            public Object nextElement() {
                return this.next();
            }
        };
    }

    public NamingEnumeration listBindings(Name name) throws NamingException {
        return null;
    }

    public NamingEnumeration listBindings(String name) throws NamingException {
        return null;
    }

    public void destroySubcontext(Name name) throws NamingException {
    }

    public void destroySubcontext(String name) throws NamingException {
    }

    public Context createSubcontext(Name name) throws NamingException {
        return null;
    }

    public Context createSubcontext(String name) throws NamingException {
        return null;
    }

    public Object lookupLink(Name name) throws NamingException {
        return null;
    }

    public Object lookupLink(String name) throws NamingException {
        return null;
    }

    public NameParser getNameParser(Name name) throws NamingException {
        return null;
    }

    public NameParser getNameParser(String name) throws NamingException {
        return null;
    }

    public Name composeName(Name name, Name prefix) throws NamingException {
        return null;
    }

    public String composeName(String name, String prefix) throws NamingException {
        return null;
    }

    public Object addToEnvironment(String propName, Object propVal) throws NamingException {
        return null;
    }

    public Object removeFromEnvironment(String propName) throws NamingException {
        return null;
    }

    public Hashtable getEnvironment() throws NamingException {
        return null;
    }

    public void close() throws NamingException {
        this.altrmiInterfaceLookup.close();
    }

    public String getNameInNamespace() throws NamingException {
        return null;
    }
}

