/*
 * Decompiled with CFR 0.152.
 */
package org.apache.excalibur.altrmi.client.impl.rmi;

import java.net.MalformedURLException;
import java.rmi.ConnectException;
import java.rmi.ConnectIOException;
import java.rmi.Naming;
import java.rmi.NotBoundException;
import java.rmi.RemoteException;
import org.apache.excalibur.altrmi.client.AltrmiConnectionListener;
import org.apache.excalibur.altrmi.client.impl.AbstractClientInvocationHandler;
import org.apache.excalibur.altrmi.common.AltrmiConnectionException;
import org.apache.excalibur.altrmi.common.AltrmiInvocationException;
import org.apache.excalibur.altrmi.common.AltrmiReply;
import org.apache.excalibur.altrmi.common.AltrmiRequest;
import org.apache.excalibur.altrmi.common.MethodRequest;
import org.apache.excalibur.altrmi.common.NoSuchReferenceException;
import org.apache.excalibur.altrmi.common.NoSuchReferenceReply;
import org.apache.excalibur.altrmi.common.NotPublishedException;
import org.apache.excalibur.altrmi.common.NotPublishedReply;
import org.apache.excalibur.altrmi.common.PublishedNameRequest;
import org.apache.excalibur.altrmi.common.RmiAltrmiInvocationHandler;
import org.apache.excalibur.altrmi.common.TryLaterReply;

public final class RmiInvocationHandler
extends AbstractClientInvocationHandler {
    private RmiAltrmiInvocationHandler mRmiAltrmiInvocationHandler;
    private String mURL;
    private boolean mMethodLogging = false;
    private long mLastRealRequest = System.currentTimeMillis();
    static /* synthetic */ Class class$org$apache$excalibur$altrmi$common$RmiAltrmiInvocationHandler;

    public RmiInvocationHandler(String host, int port) throws AltrmiConnectionException {
        this.mURL = "rmi://" + host + ":" + port + "/" + (class$org$apache$excalibur$altrmi$common$RmiAltrmiInvocationHandler == null ? (class$org$apache$excalibur$altrmi$common$RmiAltrmiInvocationHandler = RmiInvocationHandler.class$("org.apache.excalibur.altrmi.common.RmiAltrmiInvocationHandler")) : class$org$apache$excalibur$altrmi$common$RmiAltrmiInvocationHandler).getName();
        try {
            this.mRmiAltrmiInvocationHandler = (RmiAltrmiInvocationHandler)Naming.lookup(this.mURL);
        }
        catch (NotBoundException nbe) {
            throw new AltrmiConnectionException("Cannot bind to the remote RMI service.  Either an IP or RMI issue.");
        }
        catch (MalformedURLException mfue) {
            throw new AltrmiConnectionException("Malformed URL, host/port (" + host + "/" + port + ") must be wrong: " + mfue.getMessage());
        }
        catch (RemoteException re) {
            throw new AltrmiConnectionException("Unknown Remote Exception : " + re.getMessage());
        }
    }

    public void setAltrmiConnectionListener(AltrmiConnectionListener altrmiConnectionListener) {
        super.setAltrmiConnectionListener(altrmiConnectionListener);
        this.mMethodLogging = altrmiConnectionListener.methodLogging();
    }

    protected boolean tryReconnect() {
        try {
            this.mRmiAltrmiInvocationHandler = (RmiAltrmiInvocationHandler)Naming.lookup(this.mURL);
            return true;
        }
        catch (Exception e) {
            return false;
        }
    }

    /*
     * Unable to fully structure code
     */
    public synchronized AltrmiReply handleInvocation(AltrmiRequest request) {
        if (request.getRequestCode() != 306) {
            this.mLastRealRequest = System.currentTimeMillis();
        }
        again = true;
        reply = null;
        tries = 0;
        start = 0L;
        if (this.mMethodLogging) {
            start = System.currentTimeMillis();
        }
        block2: while (again) {
            block9: {
                ++tries;
                again = false;
                try {
                    reply = this.mRmiAltrmiInvocationHandler.handleInvocation(request);
                    if (reply.getReplyCode() < 100) continue;
                    if (reply instanceof TryLaterReply) {
                        millis = ((TryLaterReply)reply).getSuggestedDelayMillis();
                        this.mAltrmiConnectionListener.serviceSuspended(request, tries, millis);
                        again = true;
                        continue;
                    }
                    if (reply instanceof NoSuchReferenceReply) {
                        throw new NoSuchReferenceException(((NoSuchReferenceReply)reply).getReferenceID());
                    }
                    if (!(reply instanceof NotPublishedReply)) continue;
                    pnr = (PublishedNameRequest)request;
                    throw new NotPublishedException(pnr.getPublishedServiceName(), pnr.getObjectName());
                }
                catch (RemoteException re) {
                    if (!(re instanceof ConnectException | re instanceof ConnectIOException)) break block9;
                    retryConnectTries = 0;
                    this.mRmiAltrmiInvocationHandler = null;
                    ** while (!this.tryReconnect())
                }
lbl-1000:
                // 1 sources

                {
                    this.mAltrmiConnectionListener.serviceAbend(retryConnectTries);
                    ++retryConnectTries;
                    continue;
lbl33:
                    // 1 sources

                    continue block2;
                }
            }
            throw new AltrmiInvocationException("Unknown RMI problem : " + re.getMessage());
        }
        if (this.mMethodLogging && request instanceof MethodRequest) {
            this.mAltrmiConnectionListener.methodCalled(((MethodRequest)request).getMethodSignature(), System.currentTimeMillis() - start);
        }
        return reply;
    }

    public long getLastRealRequest() {
        return this.mLastRealRequest;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

