/*
 * Decompiled with CFR 0.152.
 */
package org.apache.excalibur.altrmi.client.impl.socket;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.Socket;
import org.apache.excalibur.altrmi.client.impl.stream.ClientStreamReadWriter;
import org.apache.excalibur.altrmi.client.impl.stream.StreamInvocationHandler;
import org.apache.excalibur.altrmi.common.AltrmiConnectionException;

public abstract class AbstractSocketStreamInvocationHandler
extends StreamInvocationHandler {
    private final String mHost;
    private final int mPort;

    public AbstractSocketStreamInvocationHandler(String host, int port, ClassLoader classLoader) throws AltrmiConnectionException {
        super(classLoader);
        this.mHost = host;
        this.mPort = port;
        try {
            Socket socket = this.makeSocket();
            this.setObjectReadWriter(this.createClientStreamReadWriter(socket.getInputStream(), socket.getOutputStream()));
        }
        catch (IOException ioe) {
            throw new AltrmiConnectionException("Cannot open Stream(s) for socket: " + ioe.getMessage());
        }
    }

    protected boolean tryReconnect() {
        try {
            Socket socket = this.makeSocket();
            this.setObjectReadWriter(this.createClientStreamReadWriter(socket.getInputStream(), socket.getOutputStream()));
            return true;
        }
        catch (IOException ioe) {
            return false;
        }
    }

    private Socket makeSocket() throws IOException {
        Socket socket = new Socket(this.mHost, this.mPort);
        socket.setSoTimeout(60000);
        return socket;
    }

    protected abstract ClientStreamReadWriter createClientStreamReadWriter(InputStream var1, OutputStream var2) throws IOException;
}

