/*
 * Decompiled with CFR 0.152.
 */
package org.apache.excalibur.altrmi.client.impl.stream;

import java.io.BufferedOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.apache.excalibur.altrmi.client.impl.stream.ClientStreamReadWriter;
import org.apache.excalibur.altrmi.common.AltrmiReply;
import org.apache.excalibur.altrmi.common.AltrmiRequest;
import org.apache.excalibur.altrmi.common.SerializationHelper;

public class ClientCustomStreamReadWriter
extends ClientStreamReadWriter {
    private DataInputStream mDataInputStream;
    private DataOutputStream mDataOutputStream;
    private ClassLoader mInterfacesClassLoader;

    public ClientCustomStreamReadWriter(InputStream inputStream, OutputStream outputStream, ClassLoader interfacesClassLoader) throws IOException {
        this.mDataOutputStream = new DataOutputStream(new BufferedOutputStream(outputStream));
        this.mDataInputStream = new DataInputStream(inputStream);
        this.mInterfacesClassLoader = interfacesClassLoader;
    }

    protected synchronized AltrmiReply postRequest(AltrmiRequest altrmiRequest) throws IOException, ClassNotFoundException {
        this.writeRequest(altrmiRequest);
        AltrmiReply r = this.readReply();
        return r;
    }

    private void writeRequest(AltrmiRequest altrmiRequest) throws IOException {
        byte[] aBytes = SerializationHelper.getBytesFromInstance((Object)altrmiRequest);
        this.mDataOutputStream.writeInt(aBytes.length);
        this.mDataOutputStream.write(aBytes);
        this.mDataOutputStream.flush();
    }

    private AltrmiReply readReply() throws IOException, ClassNotFoundException {
        int byteArraySize = this.mDataInputStream.readInt();
        byte[] byteArray = new byte[byteArraySize];
        int pos = 0;
        int cnt = 0;
        while (pos < byteArraySize) {
            int read = this.mDataInputStream.read(byteArray, pos, byteArraySize - pos);
            pos += read;
            ++cnt;
        }
        return (AltrmiReply)SerializationHelper.getInstanceFromBytes((byte[])byteArray, (ClassLoader)this.mInterfacesClassLoader);
    }
}

