/*
 * Decompiled with CFR 0.152.
 */
package org.apache.excalibur.altrmi.client.impl.stream;

import java.io.EOFException;
import java.io.IOException;
import java.io.InterruptedIOException;
import java.net.SocketException;
import org.apache.excalibur.altrmi.client.AltrmiConnectionListener;
import org.apache.excalibur.altrmi.client.impl.AbstractClientInvocationHandler;
import org.apache.excalibur.altrmi.client.impl.stream.ClientStreamReadWriter;
import org.apache.excalibur.altrmi.common.AltrmiInvocationException;
import org.apache.excalibur.altrmi.common.AltrmiReply;
import org.apache.excalibur.altrmi.common.AltrmiRequest;
import org.apache.excalibur.altrmi.common.MethodRequest;
import org.apache.excalibur.altrmi.common.NoSuchReferenceException;
import org.apache.excalibur.altrmi.common.NoSuchReferenceReply;
import org.apache.excalibur.altrmi.common.NotPublishedException;
import org.apache.excalibur.altrmi.common.NotPublishedReply;
import org.apache.excalibur.altrmi.common.PublishedNameRequest;
import org.apache.excalibur.altrmi.common.TryLaterReply;

public abstract class StreamInvocationHandler
extends AbstractClientInvocationHandler {
    private ClientStreamReadWriter mObjectReadWriter;
    private boolean mMethodLogging = false;
    private long mLastRealRequest = System.currentTimeMillis();
    protected final ClassLoader mInterfacesClassLoader;

    public StreamInvocationHandler(ClassLoader interfacesClassLoader) {
        this.mInterfacesClassLoader = interfacesClassLoader;
    }

    public ClassLoader getInterfacesClassLoader() {
        return this.mInterfacesClassLoader;
    }

    public void setAltrmiConnectionListener(AltrmiConnectionListener altrmiConnectionListener) {
        super.setAltrmiConnectionListener(altrmiConnectionListener);
        this.mMethodLogging = altrmiConnectionListener.methodLogging();
    }

    protected void setObjectReadWriter(ClientStreamReadWriter objectReadWriter) {
        this.mObjectReadWriter = objectReadWriter;
    }

    protected void requestWritten() {
    }

    /*
     * Unable to fully structure code
     */
    public synchronized AltrmiReply handleInvocation(AltrmiRequest request) {
        if (request.getRequestCode() != 306) {
            this.mLastRealRequest = System.currentTimeMillis();
        }
        try {
            again = true;
            reply = null;
            tries = 0;
            start = 0L;
            if (this.mMethodLogging) {
                start = System.currentTimeMillis();
            }
            block4: while (again) {
                block11: {
                    ++tries;
                    again = false;
                    try {
                        t1 = System.currentTimeMillis();
                        reply = this.mObjectReadWriter.postRequest(request);
                        t2 = System.currentTimeMillis();
                        if (reply.getReplyCode() < 100) continue;
                        if (reply instanceof TryLaterReply) {
                            millis = ((TryLaterReply)reply).getSuggestedDelayMillis();
                            this.mAltrmiConnectionListener.serviceSuspended(request, tries, millis);
                            again = true;
                            continue;
                        }
                        if (reply instanceof NoSuchReferenceReply) {
                            throw new NoSuchReferenceException(((NoSuchReferenceReply)reply).getReferenceID());
                        }
                        if (!(reply instanceof NotPublishedReply)) continue;
                        pnr = (PublishedNameRequest)request;
                        throw new NotPublishedException(pnr.getPublishedServiceName(), pnr.getObjectName());
                    }
                    catch (IOException ioe) {
                        if (!this.isSafeEnd(ioe)) break block11;
                        retryConnectTries = 0;
                        again = true;
                        ** while (!this.tryReconnect())
                    }
lbl-1000:
                    // 1 sources

                    {
                        this.mAltrmiConnectionListener.serviceAbend(retryConnectTries);
                        ++retryConnectTries;
                        continue;
lbl36:
                        // 1 sources

                        continue block4;
                    }
                }
                ioe.printStackTrace();
                throw new AltrmiInvocationException("IO Exception during invocation to server :" + ioe.getMessage());
            }
            if (this.mMethodLogging && request instanceof MethodRequest) {
                this.mAltrmiConnectionListener.methodCalled(((MethodRequest)request).getMethodSignature(), System.currentTimeMillis() - start);
            }
            return reply;
        }
        catch (ClassNotFoundException e) {
            System.out.println("--");
            e.printStackTrace();
            System.out.println("--");
            throw new AltrmiInvocationException("Class definition missing on Deserialization: " + e.getMessage());
        }
    }

    private boolean isSafeEnd(IOException ioe) {
        String msg;
        if (ioe instanceof SocketException | ioe instanceof EOFException | ioe instanceof InterruptedIOException) {
            return true;
        }
        return ioe.getMessage() != null && (msg = ioe.getMessage()).equals("Read end dead") | msg.equals("Pipe closed");
    }

    public long getLastRealRequest() {
        return this.mLastRealRequest;
    }
}

