/*
 * Decompiled with CFR 0.152.
 */
package org.apache.excalibur.altrmi.client.impl.subscriber;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.apache.avalon.framework.component.ComponentException;
import org.apache.avalon.framework.component.ComponentManager;
import org.apache.avalon.framework.component.Composable;
import org.apache.avalon.framework.configuration.Configurable;
import org.apache.avalon.framework.configuration.Configuration;
import org.apache.avalon.framework.configuration.ConfigurationException;
import org.apache.avalon.framework.logger.AbstractLogEnabled;
import org.apache.excalibur.altrmi.client.AbstractSubscriber;
import org.apache.excalibur.altrmi.client.AltrmiInterfaceLookup;
import org.apache.excalibur.altrmi.client.AltrmiLookupSource;
import org.apache.excalibur.altrmi.common.AltrmiAuthentication;
import org.apache.excalibur.altrmi.common.AltrmiConnectionException;
import org.apache.excalibur.altrmi.common.AltrmiInvocationException;

public abstract class AbstractSubscriberImpl
extends AbstractLogEnabled
implements Composable,
Configurable,
AbstractSubscriber {
    private int m_retryCount;
    private String m_publication;
    private AltrmiLookupSource m_lookupSource;
    private Map m_subscriptions = Collections.synchronizedMap(new HashMap());

    public void compose(ComponentManager componentManager) throws ComponentException {
        this.m_lookupSource = (AltrmiLookupSource)componentManager.lookup(AltrmiLookupSource.ROLE);
    }

    public void configure(Configuration configuration) throws ConfigurationException {
        this.m_publication = configuration.getChild("publication").getValue();
        this.m_retryCount = configuration.getChild("retry-count").getValueAsInteger(10);
    }

    protected Object lookup(AltrmiAuthentication authentication) throws AltrmiConnectionException {
        int i = 0;
        while (i < this.m_retryCount) {
            AltrmiInterfaceLookup lookup = this.m_lookupSource.get();
            try {
                AltrmiInterfaceLookup dup;
                Object iface = lookup.lookup(this.m_publication, authentication);
                if (this.getLogger().isDebugEnabled()) {
                    this.getLogger().debug("lookup [iface: " + iface + ", hash: " + iface.hashCode() + "]");
                }
                if ((dup = this.m_subscriptions.put(iface, lookup)) != null) {
                    this.getLogger().warn("Duplicate subscription detected [iface: " + iface + ", dup: " + dup + ", hash: " + iface.hashCode() + ", class: " + iface.getClass().getName() + "]");
                }
                return iface;
            }
            catch (AltrmiInvocationException e) {
                this.getLogger().error("Exception looking up publication [pub: " + this.m_publication + "]", (Throwable)e);
                lookup.close();
                ++i;
            }
        }
        return null;
    }

    public void release(Object o) {
        if (o != null) {
            AltrmiInterfaceLookup lookup = (AltrmiInterfaceLookup)this.m_subscriptions.remove(o);
            if (lookup == null) {
                throw new RuntimeException("Object was never subscribed [object: " + o + "]");
            }
            lookup.close();
        }
    }
}

