/*
 * Decompiled with CFR 0.152.
 */
package expert.os.integration.microstream;

import expert.os.integration.microstream.CompareCondition;
import expert.os.integration.microstream.EntityMetadata;
import expert.os.integration.microstream.FieldMetadata;
import expert.os.integration.microstream.MicrostreamTemplate;
import jakarta.data.exceptions.MappingException;
import java.util.ArrayList;
import java.util.Objects;
import java.util.function.Predicate;

abstract class AbstractMapperQuery {
    protected boolean negate;
    protected Predicate<?> condition;
    protected boolean and;
    protected String name;
    protected final transient EntityMetadata mapping;
    protected final transient MicrostreamTemplate template;
    protected long start;
    protected long limit;

    AbstractMapperQuery(EntityMetadata mapping, MicrostreamTemplate template) {
        this.mapping = mapping;
        this.template = template;
    }

    protected void appendCondition(Predicate<?> newCondition) {
        Predicate<?> predicate = this.getCondition(newCondition);
        this.condition = Objects.nonNull(this.condition) ? (this.and ? this.condition.and(predicate) : this.condition.or(predicate)) : predicate;
        this.negate = false;
        this.name = null;
    }

    protected <T> void inImpl(Iterable<T> values) {
        Objects.requireNonNull(values, "values is required");
        ArrayList items = new ArrayList();
        values.forEach(items::add);
        FieldMetadata field = this.field();
        this.appendCondition(t -> items.contains(field.get(t)));
    }

    protected <T> void eqImpl(T value) {
        Objects.requireNonNull(value, "value is required");
        FieldMetadata field = this.field();
        this.appendCondition(e -> value.equals(field.get(e)));
    }

    protected <T> void gteImpl(T value) {
        Objects.requireNonNull(value, "value is required");
        FieldMetadata field = this.field();
        this.appendCondition(CompareCondition.of(value.getClass()).gte(value, field));
    }

    protected <T> void gtImpl(T value) {
        Objects.requireNonNull(value, "value is required");
        FieldMetadata field = this.field();
        this.appendCondition(CompareCondition.of(value.getClass()).gt(value, field));
    }

    protected <T> void ltImpl(T value) {
        Objects.requireNonNull(value, "value is required");
        FieldMetadata field = this.field();
        this.appendCondition(CompareCondition.of(value.getClass()).lt(value, field));
    }

    protected <T> void lteImpl(T value) {
        Objects.requireNonNull(value, "value is required");
        FieldMetadata field = this.field();
        this.appendCondition(CompareCondition.of(value.getClass()).lte(value, field));
    }

    protected FieldMetadata field() {
        FieldMetadata field = this.mapping.field(this.name).orElseThrow(() -> new MappingException("The field " + this.name + " does not exist at the entity " + this.mapping.type()));
        return field;
    }

    private Predicate<?> getCondition(Predicate<?> newCondition) {
        if (this.negate) {
            return newCondition.negate();
        }
        return newCondition;
    }
}

