/*
 * Decompiled with CFR 0.152.
 */
package expert.os.integration.microstream;

import expert.os.integration.microstream.DataStorage;
import jakarta.enterprise.context.ApplicationScoped;
import jakarta.enterprise.inject.Produces;
import jakarta.inject.Inject;
import java.util.Map;
import java.util.function.Supplier;
import one.microstream.collections.lazy.LazyHashMap;
import one.microstream.storage.types.StorageManager;

@ApplicationScoped
class DataStructureSupplier
implements Supplier<DataStorage> {
    @Inject
    private StorageManager manager;

    DataStructureSupplier() {
    }

    @Override
    @Produces
    @ApplicationScoped
    public DataStorage get() {
        LazyHashMap data;
        Object root = this.manager.root();
        if (root == null) {
            data = new LazyHashMap();
            this.manager.setRoot((Object)data);
            this.manager.storeRoot();
        } else if (root instanceof LazyHashMap) {
            LazyHashMap dataStorage;
            data = dataStorage = (LazyHashMap)root;
        } else {
            throw new IllegalArgumentException("The current root structure is incompatible with DataStructure. The current structure class: " + root.getClass());
        }
        return DataStorage.of((Map<Object, Object>)data, this.manager);
    }
}

