/*
 * Decompiled with CFR 0.152.
 */
package expert.os.integration.microstream;

import expert.os.integration.microstream.EntityMetadata;
import expert.os.integration.microstream.FieldMetadata;
import expert.os.integration.microstream.MicrostreamPage;
import expert.os.integration.microstream.MicrostreamTemplate;
import jakarta.data.exceptions.MappingException;
import jakarta.data.repository.Page;
import jakarta.data.repository.Pageable;
import jakarta.data.repository.PageableRepository;
import jakarta.data.repository.Sort;
import java.util.Comparator;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;

class MicrostreamRepository<T, K>
implements PageableRepository<T, K> {
    private final MicrostreamTemplate template;
    private final Class<T> type;

    MicrostreamRepository(MicrostreamTemplate template, Class<T> type) {
        this.template = template;
        this.type = type;
    }

    public Page<T> findAll(Pageable pageable) {
        long skip;
        Objects.requireNonNull(pageable, "pageable is required");
        EntityMetadata metadata = this.template.metadata(this.type);
        Comparator<T> comparator = this.comparator(pageable, metadata);
        Stream entities = this.template.entities();
        if (Objects.nonNull(comparator)) {
            entities = entities.sorted(comparator);
        }
        if ((skip = MicrostreamPage.skip(pageable)) > 1L) {
            entities = entities.skip(skip);
        }
        if (pageable.size() >= 1) {
            entities = entities.limit(pageable.size());
        }
        List collect = entities.collect(Collectors.toUnmodifiableList());
        return MicrostreamPage.of(collect, pageable);
    }

    public <S extends T> S save(S entity) {
        Objects.requireNonNull(entity, "entity is required");
        return this.template.insert(entity);
    }

    public <S extends T> Iterable<S> saveAll(Iterable<S> entities) {
        Objects.requireNonNull(entities, "entities is required");
        return this.template.insert(entities);
    }

    public Optional<T> findById(K id) {
        Objects.requireNonNull(id, "id is required");
        Class<?> type = this.type();
        return this.template.find(type, id);
    }

    public boolean existsById(K id) {
        Objects.requireNonNull(id, "id is required");
        Class<?> type = this.type();
        return this.template.find(type, id).isPresent();
    }

    public Stream<T> findAll() {
        return this.template.entities();
    }

    public Stream<T> findAllById(Iterable<K> ids) {
        Objects.requireNonNull(ids, "ids is required");
        Class<?> type = this.type();
        return StreamSupport.stream(ids.spliterator(), false).map(k -> this.template.find(type, k)).filter(Optional::isPresent).map(Optional::get);
    }

    public long count() {
        return this.template.size();
    }

    public void deleteById(K id) {
        Objects.requireNonNull(id, "id is required");
        Class<?> type = this.type();
        this.template.delete(type, id);
    }

    public void delete(T entity) {
        Objects.requireNonNull(entity, "entity is required");
        EntityMetadata metadata = this.template.metadata(this.type);
        FieldMetadata id = metadata.id();
        Object key = id.get(entity);
        Objects.requireNonNull(key, "The key is required at the entity " + entity + " of the type " + entity.getClass());
        this.template.delete(metadata.type(), key);
    }

    public void deleteAllById(Iterable<K> ids) {
        Objects.requireNonNull(ids, "ids is required");
        this.template.delete(ids);
    }

    public void deleteAll(Iterable<? extends T> entities) {
        Objects.requireNonNull(entities, "entities is required");
        EntityMetadata metadata = this.template.metadata(this.type);
        FieldMetadata id = metadata.id();
        Set keys = StreamSupport.stream(entities.spliterator(), false).map(id::get).collect(Collectors.toUnmodifiableSet());
        this.template.delete(keys);
    }

    public void deleteAll() {
        this.template.deleteAll();
    }

    private Class<?> type() {
        return this.type;
    }

    private Comparator<T> comparator(Pageable pageable, EntityMetadata metadata) {
        Comparator comparator = null;
        for (Sort sort : pageable.sorts()) {
            Optional<FieldMetadata> field = metadata.field(sort.property());
            Comparator newComparator = field.map(f -> sort.isAscending() ? f.comparator() : f.reversed()).orElseThrow(() -> new MappingException("There is not field with the name " + sort.property() + " to order"));
            if (comparator == null) {
                comparator = newComparator;
                continue;
            }
            comparator = comparator.thenComparing(newComparator);
        }
        return comparator;
    }
}

