/*
 * Decompiled with CFR 0.152.
 */
package expert.os.integration.microstream;

import expert.os.integration.microstream.EntityMetadata;
import expert.os.integration.microstream.FieldMetadata;
import expert.os.integration.microstream.MicrostreamPage;
import expert.os.integration.microstream.MicrostreamTemplate;
import expert.os.integration.microstream.Predicates;
import expert.os.integration.microstream.RepositoryType;
import expert.os.integration.microstream.ReturnType;
import jakarta.data.exceptions.MappingException;
import jakarta.data.repository.Pageable;
import jakarta.data.repository.PageableRepository;
import jakarta.data.repository.Sort;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.Predicate;
import java.util.stream.Stream;
import org.eclipse.jnosql.communication.query.DeleteQuery;
import org.eclipse.jnosql.communication.query.QueryCondition;
import org.eclipse.jnosql.communication.query.SelectQuery;
import org.eclipse.jnosql.communication.query.Where;
import org.eclipse.jnosql.communication.query.method.DeleteMethodProvider;
import org.eclipse.jnosql.communication.query.method.SelectMethodProvider;

class RepositoryProxy<T, K>
implements InvocationHandler {
    private final PageableRepository<T, K> repository;
    private final MicrostreamTemplate template;
    private final Class<T> type;

    RepositoryProxy(PageableRepository<T, K> repository, MicrostreamTemplate template, Class<T> type) {
        this.repository = repository;
        this.template = template;
        this.type = type;
    }

    @Override
    public Object invoke(Object proxy, Method method, Object[] params) throws Throwable {
        RepositoryType type = RepositoryType.of(method);
        switch (type) {
            case DEFAULT: {
                return method.invoke(this.repository, params);
            }
            case FIND_BY: {
                return ReturnType.of(method.getReturnType()).convert(this.query(method, params), ReturnType.pageable(params));
            }
            case COUNT_BY: {
                return this.query(method, params).count();
            }
            case EXISTS_BY: {
                return this.query(method, params).findFirst().isPresent();
            }
            case DELETE_BY: {
                this.delete(method, params);
                return Void.class;
            }
            case OBJECT_METHOD: {
                return method.invoke((Object)this, params);
            }
        }
        throw new MappingException("There is not support for Microstream for feature of the type: " + type);
    }

    private Predicate<T> predicate(Where where, Method method, Object[] params, EntityMetadata metadata) {
        QueryCondition condition = where.condition();
        AtomicInteger paramIndex = new AtomicInteger(0);
        Predicate predicate = Predicates.condition(condition, metadata, method, params, paramIndex);
        return metadata.isInstance().and(predicate);
    }

    private void delete(Method method, Object[] params) {
        EntityMetadata metadata = this.template.metadata(this.type);
        DeleteMethodProvider provider = DeleteMethodProvider.INSTANCE;
        DeleteQuery query = provider.apply(method, "");
        Predicate<Object> predicate = query.where().map(w -> {
            Predicate<T> p = this.predicate((Where)w, method, params, metadata);
            return p;
        }).orElse(metadata.isInstance());
        this.template.remove(predicate);
    }

    private Stream<T> query(Method method, Object[] params) {
        EntityMetadata metadata = this.template.metadata(this.type);
        SelectMethodProvider provider = SelectMethodProvider.INSTANCE;
        SelectQuery query = provider.apply(method, "");
        Predicate predicate = query.where().map(w -> {
            Predicate<T> p = this.predicate((Where)w, method, params, metadata);
            return p;
        }).orElse(metadata.isInstance());
        Pageable pageable = ReturnType.pageable(params);
        long skip = pageable == null ? query.skip() : MicrostreamPage.skip(pageable);
        long limit = pageable == null ? query.limit() : (long)pageable.size();
        List<Comparator<?>> comparators = this.comparator(ReturnType.sort(query.orderBy(), params), metadata);
        return this.template.entities(predicate, comparators, skip, limit);
    }

    private List<Comparator<?>> comparator(List<Sort> sorts, EntityMetadata metadata) {
        Comparator comparator = null;
        for (Sort sort : sorts) {
            Optional<FieldMetadata> field = metadata.field(sort.property());
            Comparator comparator1 = field.map(f -> sort.isAscending() ? f.comparator() : f.reversed()).orElseThrow(() -> new MappingException("There is not field with the name " + sort.property() + " to order"));
            if (comparator == null) {
                comparator = comparator1;
                continue;
            }
            comparator = comparator.thenComparing(comparator1);
        }
        return comparator == null ? Collections.emptyList() : Collections.singletonList(comparator);
    }
}

