/*
 * Decompiled with CFR 0.152.
 */
package org.exteca.categorisation;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.util.ArrayList;
import java.util.List;
import org.exteca.categorisation.CategorisationException;
import org.exteca.categorisation.DefaultRulesElement;
import org.xml.sax.Attributes;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;
import org.xml.sax.XMLReader;
import org.xml.sax.helpers.DefaultHandler;

public class DefaultRules {
    public static final String ELEMENT_ELEMENT = "element";
    public static final String RULE_ELEMENT = "rule";
    public static final String TYPE_ATTRIBUTE = "type";
    public static final String ASSOCIATION_ATTRIBUTE = "association";
    public static final String GENERATE_RULES_ATTRIBUTE = "generate-rules";
    public static final String WEIGHT_ATTRIBUTE = "weight";
    public static final String ELEMENT_TYPE_RULE = "rule";
    public static final String ELEMENT_TYPE_LINK = "link";
    private List defaultRulesElementList = new ArrayList();
    private boolean generateRulesIfExist = true;

    public void addDefaultRulesElement(DefaultRulesElement defaultRulesElement) {
        if (defaultRulesElement != null) {
            this.defaultRulesElementList.add(defaultRulesElement);
        }
    }

    public List getDefaultRulesElementList() {
        return this.defaultRulesElementList;
    }

    public void setDefaultRulesElementList(List list) {
        this.defaultRulesElementList = list;
    }

    public boolean getGenerateRulesIfExist() {
        return this.generateRulesIfExist;
    }

    public void setGenerateRulesIfExist(boolean bl) {
        this.generateRulesIfExist = bl;
    }

    public void read(File file) throws CategorisationException {
        try {
            this.read(new FileReader(file));
        }
        catch (Exception exception) {
            throw new CategorisationException(exception);
        }
    }

    public void read(InputStream inputStream) throws CategorisationException {
        this.read(new BufferedReader(new InputStreamReader(inputStream)));
    }

    public void read(String string) throws CategorisationException {
        try {
            this.read(new FileReader(string));
        }
        catch (Exception exception) {
            throw new CategorisationException(exception);
        }
    }

    void read(Reader reader) throws CategorisationException {
        try {
            XmlDefaultRulesParser xmlDefaultRulesParser = new XmlDefaultRulesParser(this);
            XMLReader xMLReader = (XMLReader)Class.forName("org.apache.xerces.parsers.SAXParser").newInstance();
            xMLReader.setContentHandler(xmlDefaultRulesParser);
            xMLReader.setErrorHandler(xmlDefaultRulesParser);
            xMLReader.parse(new InputSource(reader));
        }
        catch (SAXParseException sAXParseException) {
            throw new CategorisationException(sAXParseException);
        }
        catch (SAXException sAXException) {
            throw new CategorisationException(sAXException);
        }
        catch (Exception exception) {
            throw new CategorisationException(exception);
        }
    }

    class XmlDefaultRulesParser
    extends DefaultHandler {
        private DefaultRulesElement defaultRulesElement;
        private DefaultRules defaultRules;
        private boolean ruleElement = false;

        XmlDefaultRulesParser(DefaultRules defaultRules2) {
            this.defaultRules = defaultRules2;
        }

        public void startDocument() {
        }

        public void endDocument() {
        }

        public void startElement(String string, String string2, String string3, Attributes attributes) throws SAXException {
            try {
                if (string2.equals(DefaultRules.ELEMENT_ELEMENT)) {
                    this.createDefaultRulesElement(attributes);
                    this.ruleElement = false;
                } else if (string2.equals("rule")) {
                    this.extractAttribute(attributes, DefaultRules.WEIGHT_ATTRIBUTE);
                    this.processRuleAttributes(attributes);
                    this.ruleElement = true;
                }
            }
            catch (CategorisationException categorisationException) {
                throw new SAXException(categorisationException);
            }
        }

        public void endElement(String string, String string2, String string3) throws SAXException {
            if (string2.equals(DefaultRules.ELEMENT_ELEMENT)) {
                if (!this.ruleElement && this.defaultRulesElement != null && !this.defaultRulesElement.getType().equals("rule")) {
                    throw new SAXException("No rule found under element");
                }
                this.defaultRules.addDefaultRulesElement(this.defaultRulesElement);
            }
        }

        public void characters(char[] cArray, int n, int n2) {
        }

        public void ignorableWhitespace(char[] cArray, int n, int n2) {
        }

        public void warning(SAXParseException sAXParseException) {
            System.err.println("[Warning] " + this.getLocationString(sAXParseException) + ": " + sAXParseException.getMessage());
        }

        public void error(SAXParseException sAXParseException) {
            System.err.println("[Error] " + this.getLocationString(sAXParseException) + ": " + sAXParseException.getMessage());
        }

        public void fatalError(SAXParseException sAXParseException) throws SAXException {
            System.err.println("[Fatal Error] " + this.getLocationString(sAXParseException) + ": " + sAXParseException.getMessage());
        }

        private String getLocationString(SAXParseException sAXParseException) {
            StringBuffer stringBuffer = new StringBuffer();
            String string = sAXParseException.getSystemId();
            if (string != null) {
                int n = string.lastIndexOf(47);
                if (n != -1) {
                    string = string.substring(n + 1);
                }
                stringBuffer.append(string);
            }
            stringBuffer.append(':');
            stringBuffer.append(sAXParseException.getLineNumber());
            stringBuffer.append(':');
            stringBuffer.append(sAXParseException.getColumnNumber());
            return stringBuffer.toString();
        }

        private void createDefaultRulesElement(Attributes attributes) throws CategorisationException {
            String string;
            String string2 = this.extractAttribute(attributes, DefaultRules.TYPE_ATTRIBUTE);
            boolean bl = false;
            if (string2.equals("rule")) {
                string = this.extractAttribute(attributes, DefaultRules.GENERATE_RULES_ATTRIBUTE);
                if (string.equals("false")) {
                    this.defaultRules.setGenerateRulesIfExist(false);
                }
                bl = true;
            }
            if (!bl) {
                this.defaultRulesElement = new DefaultRulesElement(string2);
                if (string2.equals(DefaultRules.ELEMENT_TYPE_LINK)) {
                    string = this.extractAttribute(attributes, DefaultRules.ASSOCIATION_ATTRIBUTE);
                    this.defaultRulesElement.addAttribute(DefaultRules.ASSOCIATION_ATTRIBUTE, string);
                }
            }
        }

        private void processRuleAttributes(Attributes attributes) throws CategorisationException {
            int n = 0;
            while (n < attributes.getLength()) {
                this.defaultRulesElement.addRuleAttribute(attributes.getQName(n), attributes.getValue(n));
                ++n;
            }
        }

        private String extractAttribute(Attributes attributes, String string) throws CategorisationException {
            if (attributes == null || attributes.getValue(string) == null) {
                throw new CategorisationException("attribute " + string + " not found in element");
            }
            return attributes.getValue(string).trim();
        }
    }
}

