/*
 * Decompiled with CFR 0.152.
 */
package org.exteca.language;

import java.util.ArrayList;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.exteca.language.AfixStemmerRules;
import org.exteca.language.Morpher;
import org.exteca.language.StemRule;

public class AfixStemmer
implements Morpher {
    Log log = LogFactory.getLog((Class)(class$org$exteca$language$AfixStemmer == null ? (class$org$exteca$language$AfixStemmer = AfixStemmer.class$("org.exteca.language.AfixStemmer")) : class$org$exteca$language$AfixStemmer));
    private AfixStemmerRules rules;
    private String name;
    static /* synthetic */ Class class$org$exteca$language$AfixStemmer;

    public AfixStemmer(AfixStemmerRules afixStemmerRules, String string) {
        this.rules = afixStemmerRules;
        this.name = string;
    }

    public String getName() {
        return this.name;
    }

    public String morph(String string) {
        string = string.toLowerCase();
        int n = 0;
        while (n != -1) {
            if (n >= this.rules.getNumRules()) break;
            StemRule stemRule = this.rules.getRule(n);
            if (stemRule.action == StemRule.STOP) break;
            if (stemRule.action == StemRule.GOTO) {
                n = stemRule.jump;
                continue;
            }
            if (stemRule.action == StemRule.SSTRIP) {
                if (string.endsWith(stemRule.target)) {
                    if (string.length() - stemRule.target.length() >= stemRule.minLength) {
                        string = string.substring(0, string.length() - stemRule.target.length());
                        string = string + stemRule.replacement;
                        n = stemRule.jump;
                        continue;
                    }
                    ++n;
                    continue;
                }
                ++n;
                continue;
            }
            if (stemRule.action != StemRule.PSTRIP) continue;
            if (string.startsWith(stemRule.target)) {
                if (string.length() - stemRule.target.length() >= stemRule.minLength) {
                    string = string.substring(stemRule.target.length());
                    string = stemRule.replacement + string;
                    n = stemRule.jump;
                    continue;
                }
                ++n;
                continue;
            }
            ++n;
        }
        return string;
    }

    public ArrayList explain(String string) {
        if (this.log.isDebugEnabled()) {
            this.log.debug((Object)(this.name + " " + string));
        }
        ArrayList<String> arrayList = new ArrayList<String>();
        int n = 0;
        while (n != -1) {
            String string2 = "";
            if (n >= this.rules.getNumRules()) break;
            StemRule stemRule = this.rules.getRule(n);
            if (stemRule.action == StemRule.STOP) break;
            if (stemRule.action == StemRule.GOTO) {
                n = stemRule.jump;
            } else if (stemRule.action == StemRule.SSTRIP) {
                if (string.endsWith(stemRule.target)) {
                    if (string.length() - stemRule.target.length() >= stemRule.minLength) {
                        string2 = "" + n + ":" + string + "->";
                        string = string.substring(0, string.length() - stemRule.target.length());
                        string = string + stemRule.replacement;
                        string2 = string2 + string;
                        n = stemRule.jump;
                    } else {
                        string2 = "" + ++n + ":too short";
                    }
                } else {
                    ++n;
                }
            } else if (stemRule.action == StemRule.PSTRIP) {
                if (string.startsWith(stemRule.target)) {
                    if (string.length() - stemRule.target.length() >= stemRule.minLength) {
                        string2 = "" + n + ":" + string + "->";
                        string = string.substring(stemRule.target.length());
                        string = stemRule.replacement + string;
                        string2 = string2 + string;
                        n = stemRule.jump;
                    } else {
                        string2 = "" + ++n + ":too short";
                    }
                } else {
                    ++n;
                }
            }
            if (string2.equals("")) continue;
            arrayList.add(string2);
        }
        return arrayList;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

