/*
 * Decompiled with CFR 0.152.
 */
package org.exteca.language;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.StringTokenizer;
import org.exteca.language.LanguageException;
import org.exteca.language.StemRule;

public class AfixStemmerRules {
    private List rules = new ArrayList();
    private Map labels = new HashMap();

    public void read(Reader reader) throws LanguageException {
        this.parse(new BufferedReader(reader));
    }

    public void read(File file) throws LanguageException {
        try {
            this.read(new FileReader(file));
        }
        catch (Exception exception) {
            throw new LanguageException(exception);
        }
    }

    public void read(InputStream inputStream) throws LanguageException {
        this.read(new BufferedReader(new InputStreamReader(inputStream)));
    }

    public void read(String string) throws LanguageException {
        try {
            this.read(new FileReader(string));
        }
        catch (Exception exception) {
            throw new LanguageException(exception);
        }
    }

    StemRule getRule(int n) {
        return (StemRule)this.rules.get(n);
    }

    int getNumRules() {
        return this.rules.size();
    }

    private void parse(BufferedReader bufferedReader) throws LanguageException {
        try {
            String string;
            int n = 0;
            while ((string = bufferedReader.readLine()) != null) {
                if (!this.parseLine(string, n)) continue;
                ++n;
            }
            Iterator iterator = this.rules.iterator();
            while (iterator.hasNext()) {
                StemRule stemRule = (StemRule)iterator.next();
                if (stemRule.jumpLabel == null) continue;
                Integer n2 = (Integer)this.labels.get(stemRule.jumpLabel);
                if (n2 == null) {
                    throw new LanguageException("Unresolved label in stemmer rules: " + stemRule.jumpLabel);
                }
                stemRule.jump = n2;
            }
        }
        catch (IOException iOException) {
            throw new LanguageException("Error reading stemmer rules from stream", iOException);
        }
    }

    private boolean parseLine(String string, int n) throws LanguageException {
        if (string.startsWith("//")) {
            return false;
        }
        StringTokenizer stringTokenizer = new StringTokenizer(string, " ,", true);
        StemRule stemRule = new StemRule();
        int n2 = 0;
        while (stringTokenizer.hasMoreTokens()) {
            String string2 = stringTokenizer.nextToken();
            if (string2.equals(" ")) continue;
            if (string2.equals(",")) {
                ++n2;
                continue;
            }
            if (n2 == 0) {
                stemRule.label = string2;
                this.labels.put(string2, new Integer(n));
                continue;
            }
            if (n2 == 1) {
                stemRule.action = this.getAction(string2);
                continue;
            }
            if (n2 == 2) {
                stemRule.target = string2;
                continue;
            }
            if (n2 == 3) {
                stemRule.replacement = string2;
                continue;
            }
            if (n2 == 4) {
                stemRule.minLength = Integer.parseInt(string2);
                continue;
            }
            if (n2 != 5) continue;
            stemRule.jumpLabel = string2;
        }
        this.rules.add(stemRule);
        return true;
    }

    private int getAction(String string) throws LanguageException {
        if (string.equals("sstrip")) {
            return StemRule.SSTRIP;
        }
        if (string.equals("pstrip")) {
            return StemRule.PSTRIP;
        }
        if (string.equals("stop")) {
            return StemRule.STOP;
        }
        if (string.equals("goto")) {
            return StemRule.GOTO;
        }
        throw new LanguageException("Unknown action in stemmer rules: " + string);
    }
}

