/*
 * Decompiled with CFR 0.152.
 */
package org.exteca.language;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.util.AbstractList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.exteca.language.FsmTokeniserRules;
import org.exteca.language.LanguageException;
import org.exteca.language.Token;
import org.exteca.language.Tokeniser;
import org.exteca.language.Tokens;
import org.exteca.utils.FiniteStateMachine;
import org.exteca.utils.FsmDriver;

public class FsmTokeniser
implements FsmDriver,
Tokeniser {
    private StringBuffer text;
    private int tokenStartChar;
    private int nextChar;
    private int offset;
    private int left;
    private int numTokens;
    private Tokens tokens;
    private int[][] transitions = null;
    private int[][] events = null;
    private Map languageTokensMap = null;
    private int languageTokensDefaultIndex = 0;
    private int languageTokensEndIndex = 0;

    public FsmTokeniser(FsmTokeniserRules fsmTokeniserRules) {
        this.transitions = fsmTokeniserRules.getTransitions();
        this.events = fsmTokeniserRules.getEvents();
        this.languageTokensMap = new HashMap(fsmTokeniserRules.getTokens());
        this.languageTokensDefaultIndex = fsmTokeniserRules.getDefaultTokensIndex();
        this.languageTokensEndIndex = fsmTokeniserRules.getEndTokensIndex();
    }

    public int tokenise(Reader reader, int n, Tokens tokens) throws LanguageException {
        BufferedReader bufferedReader = new BufferedReader(reader);
        try {
            String string = null;
            int n2 = 0;
            while ((string = bufferedReader.readLine()) != null) {
                n2 += this.tokenise(string, n, tokens);
            }
            return n2;
        }
        catch (IOException iOException) {
            throw new LanguageException(iOException);
        }
        catch (LanguageException languageException) {
            throw languageException;
        }
    }

    public int tokenise(File file, int n, Tokens tokens) throws LanguageException {
        try {
            FileReader fileReader = new FileReader(file);
            return this.tokenise(fileReader, n, tokens);
        }
        catch (Exception exception) {
            throw new LanguageException(exception);
        }
    }

    public int tokenise(InputStream inputStream, int n, Tokens tokens) throws LanguageException {
        InputStreamReader inputStreamReader = new InputStreamReader(inputStream);
        return this.tokenise(inputStreamReader, n, tokens);
    }

    public int tokenise(char[] cArray, int n, int n2, int n3, Tokens tokens) throws LanguageException {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(cArray, n, n2);
        return this.tokenise(stringBuffer, n3, tokens);
    }

    public int tokenise(String string, int n, Tokens tokens) throws LanguageException {
        StringBuffer stringBuffer = new StringBuffer(string);
        return this.tokenise(stringBuffer, n, tokens);
    }

    public int tokenise(StringBuffer stringBuffer, int n, Tokens tokens) throws LanguageException {
        this.text = stringBuffer;
        this.nextChar = 0;
        this.offset = n;
        this.tokenStartChar = this.nextChar;
        this.tokens = tokens;
        this.left = stringBuffer.length();
        this.numTokens = 0;
        FiniteStateMachine.process((int[][])this.transitions, (int[][])this.events, (FsmDriver)this);
        return this.numTokens;
    }

    public boolean hasNext() {
        return this.left >= 0;
    }

    public int next() {
        if (this.left == 0) {
            ++this.nextChar;
            --this.left;
            return this.languageTokensEndIndex;
        }
        char c = this.text.charAt(this.nextChar);
        ++this.nextChar;
        --this.left;
        char c2 = c;
        Integer n = (Integer)this.languageTokensMap.get(new Integer(c2));
        if (n != null) {
            return n;
        }
        return this.languageTokensDefaultIndex;
    }

    public void event(int n) {
        if (n != 200) {
            Token token = new Token();
            int n2 = this.nextChar - 2;
            token.text = this.text.substring(this.tokenStartChar, n2 + 1);
            token.type = n;
            token.startChar = this.offset + this.tokenStartChar;
            token.endChar = this.offset + n2;
            this.tokens.add(token);
            ++this.numTokens;
        }
        this.tokenStartChar = this.nextChar - 1;
    }

    private static void extractTokens(File file) {
        try {
            Tokens tokens = new Tokens();
            Tokeniser tokeniser = FsmTokeniser.getTokeniser();
            if (tokeniser != null) {
                System.out.println("Tokenising file");
                long l = System.currentTimeMillis();
                int n = tokeniser.tokenise(file, 0, tokens);
                long l2 = System.currentTimeMillis();
                System.out.println("Time to tokenise text: " + (l2 - l));
                System.out.println("Found " + n + " tokens");
                FsmTokeniser.readTokens(tokens);
            }
        }
        catch (Exception exception) {
            System.out.println(exception.toString());
        }
    }

    private static void extractTokens(InputStream inputStream) {
        try {
            Tokens tokens = new Tokens();
            Tokeniser tokeniser = FsmTokeniser.getTokeniser();
            if (tokeniser != null) {
                System.out.println("Tokenising inputstream");
                long l = System.currentTimeMillis();
                int n = tokeniser.tokenise(inputStream, 0, tokens);
                long l2 = System.currentTimeMillis();
                System.out.println("Time to tokenise text: " + (l2 - l));
                System.out.println("Found " + n + " tokens");
                FsmTokeniser.readTokens(tokens);
            }
        }
        catch (Exception exception) {
            System.out.println(exception.toString());
        }
    }

    private static void extractTokens(String string) {
        try {
            Tokens tokens = new Tokens();
            Tokeniser tokeniser = FsmTokeniser.getTokeniser();
            if (tokeniser != null) {
                System.out.println("Tokenising '" + string + "'");
                long l = System.currentTimeMillis();
                int n = tokeniser.tokenise(string, 0, tokens);
                long l2 = System.currentTimeMillis();
                System.out.println("Time to tokenise text: " + (l2 - l));
                System.out.println("Found " + n + " tokens");
                FsmTokeniser.readTokens(tokens);
            }
        }
        catch (Exception exception) {
            System.out.println(exception.toString());
        }
    }

    private static Tokeniser getTokeniser() {
        try {
            String string = System.getProperty("tokens");
            long l = System.currentTimeMillis();
            FsmTokeniserRules fsmTokeniserRules = new FsmTokeniserRules();
            fsmTokeniserRules.read(string);
            FsmTokeniser fsmTokeniser = new FsmTokeniser(fsmTokeniserRules);
            long l2 = System.currentTimeMillis();
            System.out.println("Time to token parse: " + (l2 - l));
            return fsmTokeniser;
        }
        catch (Exception exception) {
            System.out.println(exception.toString());
            return null;
        }
    }

    private static void readTokens(Tokens tokens) {
        Iterator iterator = ((AbstractList)tokens).iterator();
        while (iterator.hasNext()) {
            Token token = (Token)iterator.next();
            System.out.println("--Token: " + token.type + " '" + token.text + "' (" + token.startChar + "," + token.endChar + ")");
        }
    }
}

