/*
 * Decompiled with CFR 0.152.
 */
package org.exteca.language;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.StringTokenizer;
import java.util.TreeMap;
import org.exteca.language.LanguageException;

public class FsmTokeniserRules {
    private static final int STATE_EMPTY = -1;
    private static final int STATE_COMMENT = -2;
    private static final int STATE_PROCESS = -3;
    private static final int STATE_DEFINITIONS = 0;
    private static final int STATE_TRANSITIONS = 1;
    private static final int STATE_EVENTS = 2;
    private static final int STATE_TOKENS = 3;
    private static final int STATE_ARRAY_START = 4;
    private static final int STATE_ARRAY_END = 5;
    private static final String DEFINITIONS_LABEL = ":definitions";
    private static final String TRANSITIONS_LABEL = ":transitions";
    private static final String EVENTS_LABEL = ":events";
    private static final String TOKENS_LABEL = ":tokens";
    private static final String DEFAULT_LABEL = "DEFAULT";
    private static final String END_LABEL = "END";
    private static final String ARRAY_START_LABEL = "{";
    private static final String ARRAY_END_LABEL = "}";
    private static final String ARRAY_NUMBER_OF_ROWS = "ARRAY_NUMBER_OF_ROWS";
    private static final String ARRAY_NUMBER_OF_COLUMNS = "ARRAY_NUMBER_OF_COLUMNS";
    private static final String DEFINITIONS_SEPARATOR = "=";
    private static final String TOKENS_SEPARATOR = "=";
    private static final String ARRAY_SEPARATOR = ",";
    private static final String TOKEN_PARSER_ERROR = "FsmTokeniserRules error:";
    private static final char NEWLINE = 'n';
    private static final char RETURN = 'r';
    private static final char TAB = 't';
    private static final char SPACE = 's';
    private static final char BACKSLASH = '\\';
    private static final char UNICODE = 'u';
    private static final char HEXADECIMAL = 'x';
    private static final int HEXADECIMAL_16_LENGTH = 4;
    private static final int HEXADECIMAL_8_LENGTH = 2;
    private Map definitionsMap = new HashMap();
    private Map tokenDefinitionsMap = new TreeMap();
    private Map tokensMap = new HashMap();
    private int arrayRows = 0;
    private int arrayColumns = 0;
    private int[][] transitions = null;
    private int[][] events = null;
    private int defaultTokensIndex = 0;
    private int endTokensIndex = 0;

    public void read(Reader reader) throws LanguageException {
        this.parse(new BufferedReader(reader));
    }

    public void read(File file) throws LanguageException {
        try {
            this.read(new FileReader(file));
        }
        catch (Exception exception) {
            throw new LanguageException(TOKEN_PARSER_ERROR, exception);
        }
    }

    public void read(InputStream inputStream) throws LanguageException {
        this.read(new BufferedReader(new InputStreamReader(inputStream)));
    }

    public void read(String string) throws LanguageException {
        try {
            this.read(new FileReader(string));
        }
        catch (Exception exception) {
            throw new LanguageException(TOKEN_PARSER_ERROR, exception);
        }
    }

    public int[][] getTransitions() {
        return this.transitions;
    }

    public int[][] getEvents() {
        return this.events;
    }

    public Map getTokens() {
        return this.tokensMap;
    }

    public int getDefaultTokensIndex() {
        return this.defaultTokensIndex;
    }

    public int getEndTokensIndex() {
        return this.endTokensIndex;
    }

    private void parse(BufferedReader bufferedReader) throws LanguageException {
        try {
            String string = null;
            int n = -1;
            while ((string = bufferedReader.readLine()) != null) {
                n = this.parseLine(string);
                switch (n) {
                    case 0: {
                        this.parseDefinitions(bufferedReader);
                        break;
                    }
                    case 1: {
                        this.parseTransitions(bufferedReader);
                        break;
                    }
                    case 2: {
                        this.parseEvents(bufferedReader);
                        break;
                    }
                    case 3: {
                        this.parseTokens(bufferedReader);
                        break;
                    }
                }
            }
        }
        catch (IOException iOException) {
            throw new LanguageException(TOKEN_PARSER_ERROR, iOException);
        }
        catch (LanguageException languageException) {
            throw languageException;
        }
    }

    private int parseLine(String string) throws LanguageException {
        if ((string = string.trim()).length() == 0) {
            return -1;
        }
        if (string.startsWith("//")) {
            return -2;
        }
        if (string.startsWith(DEFINITIONS_LABEL)) {
            return 0;
        }
        if (string.startsWith(TRANSITIONS_LABEL)) {
            return 1;
        }
        if (string.startsWith(EVENTS_LABEL)) {
            return 2;
        }
        if (string.startsWith(TOKENS_LABEL)) {
            return 3;
        }
        if (string.startsWith(ARRAY_START_LABEL)) {
            return 4;
        }
        if (string.startsWith(ARRAY_END_LABEL)) {
            return 5;
        }
        return -3;
    }

    private void parseArray(BufferedReader bufferedReader, int n) throws LanguageException {
        try {
            String string = null;
            int n2 = -1;
            boolean bl = false;
            int n3 = 0;
            while ((string = bufferedReader.readLine()) != null && n2 != 5) {
                n2 = this.parseLine(string);
                if (n2 == 4) {
                    bl = true;
                    continue;
                }
                if (n2 == 5) {
                    if (n == 0) {
                        this.createFsmArrays();
                    } else if (n == 3) {
                        this.createTokenMap();
                    }
                    break;
                }
                if (n2 == -3) {
                    if (!bl) {
                        throw new LanguageException("FsmTokeniserRules error: no start array found");
                    }
                    if (n == 0) {
                        this.storeDefinition(string);
                    } else if (n == 1) {
                        this.storeArray(string, n3, this.transitions);
                    } else if (n == 2) {
                        this.storeArray(string, n3, this.events);
                    } else if (n == 3) {
                        this.storeTokenDefinitions(string);
                    }
                }
                ++n3;
            }
        }
        catch (IOException iOException) {
            throw new LanguageException(TOKEN_PARSER_ERROR, iOException);
        }
    }

    private void parseDefinitions(BufferedReader bufferedReader) throws LanguageException {
        this.parseArray(bufferedReader, 0);
    }

    private void parseTransitions(BufferedReader bufferedReader) throws LanguageException {
        this.parseArray(bufferedReader, 1);
    }

    private void parseEvents(BufferedReader bufferedReader) throws LanguageException {
        this.parseArray(bufferedReader, 2);
    }

    private void parseTokens(BufferedReader bufferedReader) throws LanguageException {
        this.parseArray(bufferedReader, 3);
    }

    private void storeDefinition(String string) throws LanguageException {
        block7: {
            StringTokenizer stringTokenizer = new StringTokenizer(string, "=", false);
            int n = stringTokenizer.countTokens();
            if (n != 2) {
                throw new LanguageException("FsmTokeniserRules error: definitions:must specify a key=value pair");
            }
            int n2 = 0;
            String string2 = "";
            String string3 = "";
            String string4 = "";
            while (stringTokenizer.hasMoreTokens()) {
                string4 = stringTokenizer.nextToken();
                string4 = string4.trim();
                if (n2 == 0) {
                    string2 = string4;
                }
                if (n2 == 1) {
                    string3 = string4;
                }
                ++n2;
            }
            try {
                if (!this.definitionsMap.containsKey(string2)) {
                    this.definitionsMap.put(string2, new Integer(string3));
                    break block7;
                }
                throw new LanguageException("FsmTokeniserRules error: definitions:two keys of the same name found:" + string2);
            }
            catch (NumberFormatException numberFormatException) {
                throw new LanguageException("FsmTokeniserRules error: definitions:the value must be a number:" + string3);
            }
        }
    }

    private void createFsmArrays() throws LanguageException {
        if (!this.definitionsMap.containsKey(ARRAY_NUMBER_OF_ROWS)) {
            throw new LanguageException("FsmTokeniserRules error: ARRAY_NUMBER_OF_ROWS not defined");
        }
        this.arrayRows = (Integer)this.definitionsMap.get(ARRAY_NUMBER_OF_ROWS);
        if (!this.definitionsMap.containsKey(ARRAY_NUMBER_OF_COLUMNS)) {
            throw new LanguageException("FsmTokeniserRules error: ARRAY_NUMBER_OF_COLUMNS not defined");
        }
        this.arrayColumns = (Integer)this.definitionsMap.get(ARRAY_NUMBER_OF_COLUMNS);
        if (this.arrayRows == 0 || this.arrayColumns == 0) {
            throw new LanguageException("FsmTokeniserRules error: array rows or columns cannot be zero");
        }
        this.transitions = new int[this.arrayRows][this.arrayColumns];
        this.events = new int[this.arrayRows][this.arrayColumns];
    }

    private void storeArray(String string, int n, int[][] nArray) throws LanguageException {
        StringTokenizer stringTokenizer = new StringTokenizer(string, ARRAY_SEPARATOR, false);
        String string2 = "";
        Integer n2 = null;
        int n3 = 0;
        while (stringTokenizer.hasMoreTokens()) {
            string2 = stringTokenizer.nextToken();
            if (this.definitionsMap.containsKey(string2 = string2.trim())) {
                n2 = (Integer)this.definitionsMap.get(string2);
                nArray[n][n3] = n2;
            } else {
                try {
                    Integer n4 = new Integer(string2);
                    nArray[n][n3] = n4;
                }
                catch (NumberFormatException numberFormatException) {
                    throw new LanguageException(TOKEN_PARSER_ERROR + string2 + " not found in definitions");
                }
            }
            ++n3;
        }
    }

    private void storeTokenDefinitions(String string) throws LanguageException {
        block11: {
            StringTokenizer stringTokenizer = new StringTokenizer(string, "=", false);
            int n = stringTokenizer.countTokens();
            if (n != 2) {
                throw new LanguageException("FsmTokeniserRules error: tokens:must specify a key=value pair");
            }
            int n2 = 0;
            String string2 = "";
            String string3 = "";
            String string4 = "";
            while (stringTokenizer.hasMoreTokens()) {
                string4 = stringTokenizer.nextToken();
                string4 = string4.trim();
                if (n2 == 0) {
                    string2 = string4;
                }
                if (n2 == 1) {
                    string3 = string4;
                }
                ++n2;
            }
            try {
                if (this.definitionsMap.containsKey(string2)) {
                    Integer n3 = (Integer)this.definitionsMap.get(string2);
                    if (string3.equals(DEFAULT_LABEL)) {
                        string3 = "";
                        this.defaultTokensIndex = n3;
                    } else if (string3.equals(END_LABEL)) {
                        string3 = "";
                        this.endTokensIndex = n3;
                    }
                    if (!this.tokenDefinitionsMap.containsKey(n3)) {
                        this.tokenDefinitionsMap.put(n3, string3);
                        break block11;
                    }
                    throw new LanguageException("FsmTokeniserRules error: tokens:two keys of the same name found:" + string2);
                }
                throw new LanguageException("FsmTokeniserRules error: tokens:key not found in definitions:" + string2);
            }
            catch (Exception exception) {
                throw new LanguageException(exception);
            }
        }
    }

    private void createTokenMap() throws LanguageException {
        Iterator iterator = this.tokenDefinitionsMap.entrySet().iterator();
        Integer n = null;
        String string = null;
        int n2 = this.tokenDefinitionsMap.size();
        if (n2 == 0) {
            throw new LanguageException("FsmTokeniserRules error: tokens array size cannot be zero");
        }
        int n3 = 0;
        int[] nArray = new int[1];
        while (iterator.hasNext()) {
            Map.Entry entry = iterator.next();
            n = (Integer)entry.getKey();
            string = (String)entry.getValue();
            int n4 = 0;
            while (n4 < string.length()) {
                if (string.charAt(n4) == '\\') {
                    n3 = this.getEscapeCharacterHash(n4, string, nArray);
                    n4 = nArray[0];
                } else {
                    n3 = new Character(string.charAt(n4)).hashCode();
                }
                this.tokensMap.put(new Integer(n3), n);
                ++n4;
            }
        }
    }

    private int getEscapeCharacterHash(int n, String string, int[] nArray) throws LanguageException {
        switch (string.charAt(n + 1)) {
            case 'n': {
                nArray[0] = n + 1;
                return new Character('\n').hashCode();
            }
            case 'r': {
                nArray[0] = n + 1;
                return new Character('\r').hashCode();
            }
            case 's': {
                nArray[0] = n + 1;
                return new Character(' ').hashCode();
            }
            case 't': {
                nArray[0] = n + 1;
                return new Character('\t').hashCode();
            }
            case '\\': {
                nArray[0] = n + 1;
                return new Character('\\').hashCode();
            }
            case 'x': {
                return this.getUnicodeCharacterHash(n, string, nArray, 2);
            }
            case 'u': {
                return this.getUnicodeCharacterHash(n, string, nArray, 4);
            }
        }
        throw new LanguageException("Unrecognised escape character:" + string.charAt(n + 1));
    }

    private int getUnicodeCharacterHash(int n, String string, int[] nArray, int n2) throws LanguageException {
        int n3 = 0;
        String string2 = "";
        char[] cArray = new char[n2];
        n3 = n + 1;
        int n4 = 0;
        while (n4 < n2) {
            if (!Character.isLetterOrDigit(string.charAt(++n3))) {
                throw new LanguageException("Unicode or hexadecimal numbers must be a digit or letter:" + string.charAt(n3));
            }
            cArray[n4] = string.charAt(n3);
            ++n4;
        }
        nArray[0] = n3;
        string2 = String.copyValueOf(cArray);
        return Integer.valueOf(string2, 16);
    }
}

