/*
 * Decompiled with CFR 0.152.
 */
package org.exteca.language;

import java.util.AbstractList;
import java.util.Iterator;
import org.exteca.language.Marker;
import org.exteca.language.Token;
import org.exteca.language.Tokens;
import org.exteca.utils.FiniteStateMachine;
import org.exteca.utils.FsmDriver;
import org.exteca.utils.Span;
import org.exteca.utils.Spans;

public class SentenceMarker
implements FsmDriver,
Marker {
    static int S_STAR = 0;
    static int S_SENT = 1;
    static int I_WORD = Token.WORD;
    static int I_SENT = Token.SENT;
    static int I_PUNC = Token.PUNC;
    static int I_END = I_PUNC + 1;
    static int E_SENT = 0;
    static int[][] transitions = new int[][]{{S_STAR, S_SENT, S_STAR, S_STAR}, {S_STAR, S_SENT, S_STAR, S_STAR}};
    static int[][] events = new int[][]{{100, E_SENT, 100, E_SENT}, {100, 100, 100, 100}};
    private Spans spans;
    private Iterator tokenIterator;
    private int startToken;
    private int currentToken;
    private int numSentences;
    private boolean end;

    public String getMarkupName() {
        return "sentence";
    }

    public int mark(Tokens tokens, Spans spans) {
        this.spans = spans;
        this.tokenIterator = ((AbstractList)tokens).iterator();
        this.startToken = 0;
        this.currentToken = 0;
        this.numSentences = 0;
        this.end = false;
        FiniteStateMachine.process((int[][])transitions, (int[][])events, (FsmDriver)this);
        return this.numSentences;
    }

    public boolean hasNext() {
        boolean bl = this.tokenIterator.hasNext();
        if (!bl && !this.end) {
            this.end = true;
            bl = true;
        }
        return bl;
    }

    public int next() {
        ++this.currentToken;
        if (this.end) {
            return I_END;
        }
        return ((Token)this.tokenIterator.next()).type;
    }

    public void event(int n) {
        Span span = new Span(this.startToken, this.currentToken - 2);
        this.spans.add(span);
        ++this.numSentences;
        this.startToken = this.currentToken;
    }
}

