/*
 * Decompiled with CFR 0.152.
 */
package org.exteca.ontology;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Vector;
import org.exteca.ontology.ConceptPath;
import org.exteca.ontology.Constraint;
import org.exteca.ontology.Content;
import org.exteca.ontology.Element;
import org.exteca.ontology.Link;
import org.exteca.ontology.OntologyException;
import org.exteca.ontology.Property;
import org.exteca.ontology.Resource;
import org.exteca.ontology.Rule;

public class Concept
extends Element {
    private Content content = new Content(this);
    private List ancestors;
    private List descendants;

    public Concept(String string) {
        this.setType("conceptType");
        this.setId(string);
    }

    public Content getContent() {
        return this.content;
    }

    public Concept addConstraint(Constraint constraint) throws OntologyException {
        this.content.addElement(constraint);
        return this;
    }

    public Concept removeConstraint(Constraint constraint) throws OntologyException {
        this.content.removeElement(constraint);
        return this;
    }

    public Concept addLink(Link link) throws OntologyException {
        this.content.addElement(link);
        return this;
    }

    public Concept removeLink(Link link) throws OntologyException {
        this.content.removeElement(link);
        return this;
    }

    public Concept addProperty(Property property) throws OntologyException {
        this.content.addElement(property);
        return this;
    }

    public Concept removeProperty(Property property) throws OntologyException {
        this.content.removeElement(property);
        return this;
    }

    public Concept addResource(Resource resource) throws OntologyException {
        this.content.addElement(resource);
        return this;
    }

    public Concept removeResource(Resource resource) throws OntologyException {
        this.content.removeElement(resource);
        return this;
    }

    public Concept addRule(Rule rule) throws OntologyException {
        this.content.addElement(rule);
        return this;
    }

    public Concept removeRule(Rule rule) throws OntologyException {
        this.content.removeElement(rule);
        return this;
    }

    public Constraint[] getConstraints() throws OntologyException {
        Collection collection = this.getContent().getElements("constraintType");
        if (collection == null) {
            return new Constraint[0];
        }
        return collection.toArray(new Constraint[collection.size()]);
    }

    public Link[] getLinks() throws OntologyException {
        Collection collection = this.getContent().getElements("linkType");
        if (collection == null) {
            return new Link[0];
        }
        Concept concept = this;
        Vector<Link> vector = new Vector<Link>();
        Iterator iterator = collection.iterator();
        while (iterator.hasNext()) {
            Link link = (Link)iterator.next();
            vector.add(link);
        }
        return vector.toArray(new Link[vector.size()]);
    }

    public Link[] getLinks(String string) throws OntologyException {
        return this.getLinks(string, true);
    }

    public Link[] getLinks(String string, boolean bl) throws OntologyException {
        if (string == null) {
            throw new OntologyException("Cannot return Links for a null associationId");
        }
        Link[] linkArray = this.getLinks();
        Vector<Link> vector = new Vector<Link>();
        int n = 0;
        while (n < linkArray.length) {
            Link link = linkArray[n];
            if ((string.equals(link.getAssociation().getId()) || string.equals(link.getAssociation().getInverseId())) && bl) {
                vector.add(link);
            } else if (!(string.equals(link.getAssociation().getId()) || string.equals(link.getAssociation().getInverseId()) || bl)) {
                vector.add(link);
            }
            ++n;
        }
        return vector.toArray(new Link[vector.size()]);
    }

    public Concept[] getConcepts() throws OntologyException {
        Link[] linkArray = this.getLinks();
        if (linkArray.length == 0) {
            return new Concept[0];
        }
        Concept concept = this;
        Vector<Concept> vector = new Vector<Concept>();
        int n = 0;
        while (n < linkArray.length) {
            Link link = linkArray[n];
            Concept concept2 = link.getSink();
            if (concept2 != null && !concept2.equals(concept)) {
                vector.add(concept2);
            }
            ++n;
        }
        return vector.toArray(new Concept[vector.size()]);
    }

    public Concept[] getConcepts(String string) throws OntologyException {
        if (string == null) {
            throw new OntologyException("Cannot return linked Concepts for a null associationId");
        }
        Link[] linkArray = this.getLinks(string);
        if (linkArray.length == 0) {
            return new Concept[0];
        }
        Concept concept = this;
        Vector<Concept> vector = new Vector<Concept>();
        int n = 0;
        while (n < linkArray.length) {
            Link link = linkArray[n];
            Concept concept2 = null;
            if ("id".equals(link.getTag("associationId")) && string.equals(link.getAssociation().getId())) {
                concept2 = link.getSink();
            } else if ("inverseId".equals(link.getTag("associationId")) && string.equals(link.getAssociation().getInverseId())) {
                concept2 = link.getSink();
            }
            if (concept2 != null && !concept2.equals(concept)) {
                vector.add(concept2);
            }
            ++n;
        }
        return vector.toArray(new Concept[vector.size()]);
    }

    public Concept getConcept(String string) throws OntologyException {
        if (string == null) {
            throw new OntologyException("Cannot return Concept for a null conceptId");
        }
        Concept[] conceptArray = this.getConcepts();
        int n = 0;
        while (n < conceptArray.length) {
            if (string.equals(conceptArray[n].getId())) {
                return conceptArray[n];
            }
            ++n;
        }
        return null;
    }

    public Concept[] getInstances() throws OntologyException {
        return this.getConcepts("has-instance");
    }

    public Concept[] getInstancesOf() throws OntologyException {
        return this.getConcepts("instance-of");
    }

    public Concept[] getSubclasses() throws OntologyException {
        return this.getConcepts("has-subclass");
    }

    public Concept[] getSubclassesOf() throws OntologyException {
        return this.getConcepts("subclass-of");
    }

    public Concept[] getSignposts() throws OntologyException {
        return this.getConcepts("has-signpost");
    }

    public Concept[] getSignpostsOf() throws OntologyException {
        return this.getConcepts("signpost-of");
    }

    public Property[] getProperties() throws OntologyException {
        Collection collection = this.getContent().getElements("propertyType");
        if (collection == null) {
            return new Property[0];
        }
        return collection.toArray(new Property[collection.size()]);
    }

    public boolean hasProperty(Property property) throws OntologyException {
        Property[] propertyArray = this.getProperties();
        int n = 0;
        while (n < propertyArray.length) {
            if (property.getId().equals(propertyArray[n].getId())) {
                return true;
            }
            ++n;
        }
        return false;
    }

    public Resource[] getResources() throws OntologyException {
        Collection collection = this.getContent().getElements("resourceType");
        if (collection == null) {
            return new Resource[0];
        }
        return collection.toArray(new Resource[collection.size()]);
    }

    public Resource[] getResources(String string) throws OntologyException {
        Resource[] resourceArray = this.getResources();
        Vector<Resource> vector = new Vector<Resource>();
        int n = 0;
        while (n < resourceArray.length) {
            Resource resource = resourceArray[n];
            if (string.equals(resource.getTag("content"))) {
                vector.add(resource);
            }
            ++n;
        }
        return vector.toArray(new Resource[vector.size()]);
    }

    public boolean hasResource(Resource resource) throws OntologyException {
        Resource[] resourceArray = this.getResources();
        int n = 0;
        while (n < resourceArray.length) {
            if (resource.getId().equals(resourceArray[n].getId())) {
                return true;
            }
            ++n;
        }
        return false;
    }

    public Rule[] getRules() throws OntologyException {
        Collection collection = this.getContent().getElements("ruleType");
        if (collection == null) {
            return new Rule[0];
        }
        return collection.toArray(new Rule[collection.size()]);
    }

    public Rule[] getRules(String string) throws OntologyException {
        Rule[] ruleArray = this.getRules();
        Vector<Rule> vector = new Vector<Rule>();
        int n = 0;
        while (n < ruleArray.length) {
            Rule rule = ruleArray[n];
            if (string.equals(rule.getTag("content"))) {
                vector.add(rule);
            }
            ++n;
        }
        return vector.toArray(new Rule[vector.size()]);
    }

    public boolean hasRule(Rule rule) throws OntologyException {
        Rule[] ruleArray = this.getRules();
        int n = 0;
        while (n < ruleArray.length) {
            if (rule.getId().equals(ruleArray[n].getId())) {
                return true;
            }
            ++n;
        }
        return false;
    }

    public Concept[] getParents() throws OntologyException {
        return this.getConcepts("child-of");
    }

    public Concept[] getChildren() throws OntologyException {
        ArrayList<Concept> arrayList = new ArrayList<Concept>();
        arrayList.addAll(Arrays.asList(this.getConcepts("has-child")));
        arrayList.addAll(Arrays.asList(this.getConcepts("has-instance")));
        arrayList.addAll(Arrays.asList(this.getConcepts("has-subclass")));
        return arrayList.toArray(new Concept[arrayList.size()]);
    }

    public ConceptPath[] getParentPaths() throws OntologyException {
        this.findAncestors();
        if (this.ancestors.size() == 0) {
            return new ConceptPath[0];
        }
        Vector<ConceptPath> vector = new Vector<ConceptPath>();
        Iterator iterator = this.ancestors.iterator();
        while (iterator.hasNext()) {
            List list = (List)iterator.next();
            vector.add(new ConceptPath(list.toArray(new Concept[list.size()])));
        }
        return vector.toArray(new ConceptPath[vector.size()]);
    }

    protected void findAncestors() {
        if (this.ancestors == null) {
            this.ancestors = new Vector();
        } else {
            this.ancestors.clear();
        }
        Concept concept = this;
        Vector<Concept> vector = new Vector<Concept>();
        vector.add(concept);
        this.ancestors.add(vector);
        this.recurseParentTree(vector, concept);
    }

    protected void recurseParentTree(List list, Concept concept) {
        Concept[] conceptArray = null;
        try {
            conceptArray = concept.getParents();
        }
        catch (OntologyException ontologyException) {
            return;
        }
        if (conceptArray.length == 0) {
            return;
        }
        if (conceptArray.length > 1) {
            int n = 1;
            while (n < conceptArray.length) {
                Vector<Concept> vector = new Vector<Concept>(list);
                this.ancestors.add(vector);
                vector.add(conceptArray[n]);
                this.recurseParentTree(vector, conceptArray[n]);
                ++n;
            }
        }
        list.add(conceptArray[0]);
        this.recurseParentTree(list, conceptArray[0]);
    }

    public ConceptPath[] getChildPaths() throws OntologyException {
        this.findDescendants();
        if (this.descendants.size() == 0) {
            return new ConceptPath[0];
        }
        Vector<ConceptPath> vector = new Vector<ConceptPath>();
        Iterator iterator = this.descendants.iterator();
        while (iterator.hasNext()) {
            List list = (List)iterator.next();
            vector.add(new ConceptPath(list.toArray(new Concept[list.size()])));
        }
        return vector.toArray(new ConceptPath[vector.size()]);
    }

    protected void findDescendants() {
        if (this.descendants == null) {
            this.descendants = new Vector();
        } else {
            this.descendants.clear();
        }
        Concept concept = this;
        Vector<Concept> vector = new Vector<Concept>();
        vector.add(concept);
        this.descendants.add(vector);
        this.recurseChildTree(vector, concept);
    }

    protected void recurseChildTree(List list, Concept concept) {
        Concept[] conceptArray = null;
        try {
            conceptArray = concept.getChildren();
        }
        catch (OntologyException ontologyException) {
            return;
        }
        if (conceptArray.length == 0) {
            return;
        }
        if (conceptArray.length > 1) {
            int n = 1;
            while (n < conceptArray.length) {
                Vector<Concept> vector = new Vector<Concept>(list);
                this.descendants.add(vector);
                vector.add(conceptArray[n]);
                this.recurseChildTree(vector, conceptArray[n]);
                ++n;
            }
        }
        list.add(conceptArray[0]);
        this.recurseChildTree(list, conceptArray[0]);
    }

    public boolean hasConstraints() {
        return this.getContent().hasElements("constraintType");
    }

    public boolean hasLinks() {
        return this.getContent().hasElements("linkType");
    }

    public boolean hasProperties() {
        return this.getContent().hasElements("propertyType");
    }

    public boolean hasResources() {
        return this.getContent().hasElements("resourceType");
    }

    public boolean hasRules() {
        return this.getContent().hasElements("ruleType");
    }

    public String toString() {
        return "[Concept id=" + this.getId() + ", hasLinks=" + this.hasLinks() + ", hasProperties=" + this.hasProperties() + ", hasResources=" + this.hasResources() + ", hasRules=" + this.hasRules() + "]";
    }
}

