/*
 * Decompiled with CFR 0.152.
 */
package org.exteca.ontology;

import org.exteca.ontology.Concept;
import org.exteca.ontology.Element;

public class ConceptPath
extends Element {
    private ConceptPath parentPath;
    private transient Concept lastPathComponent;

    protected ConceptPath() {
        this.setType("conceptPathType");
    }

    public ConceptPath(Concept[] conceptArray) {
        this();
        if (conceptArray == null || conceptArray.length == 0) {
            throw new IllegalArgumentException("path in ConceptPath must be non null and not empty.");
        }
        this.lastPathComponent = conceptArray[conceptArray.length - 1];
        if (conceptArray.length > 1) {
            this.parentPath = new ConceptPath(conceptArray, conceptArray.length - 1);
        }
    }

    public ConceptPath(Concept concept) {
        this();
        if (concept == null) {
            throw new IllegalArgumentException("element in ConceptPath must be non null.");
        }
        this.lastPathComponent = concept;
        this.parentPath = null;
    }

    protected ConceptPath(ConceptPath conceptPath, Concept concept) {
        this();
        if (concept == null) {
            throw new IllegalArgumentException("path in ConceptPath must be non null.");
        }
        this.parentPath = conceptPath;
        this.lastPathComponent = concept;
    }

    protected ConceptPath(Concept[] conceptArray, int n) {
        this();
        this.lastPathComponent = conceptArray[n - 1];
        if (n > 1) {
            this.parentPath = new ConceptPath(conceptArray, n - 1);
        }
    }

    public Concept[] getPath() {
        int n = this.getPathCount();
        Concept[] conceptArray = new Concept[n--];
        ConceptPath conceptPath = this;
        while (conceptPath != null) {
            conceptArray[n--] = conceptPath.lastPathComponent;
            conceptPath = conceptPath.parentPath;
        }
        return conceptArray;
    }

    public Concept getLastPathComponent() {
        return this.lastPathComponent;
    }

    public int getPathCount() {
        int n = 0;
        ConceptPath conceptPath = this;
        while (conceptPath != null) {
            ++n;
            conceptPath = conceptPath.parentPath;
        }
        return n;
    }

    public Concept getPathComponent(int n) {
        int n2 = this.getPathCount();
        if (n < 0 || n >= n2) {
            throw new IllegalArgumentException("Index " + n + " is out of the specified range");
        }
        ConceptPath conceptPath = this;
        int n3 = n2 - 1;
        while (n3 != n) {
            conceptPath = conceptPath.parentPath;
            --n3;
        }
        return conceptPath.lastPathComponent;
    }

    public boolean equals(ConceptPath conceptPath) {
        if (conceptPath == this) {
            return true;
        }
        if (this.getPathCount() != conceptPath.getPathCount()) {
            return false;
        }
        ConceptPath conceptPath2 = this;
        while (conceptPath2 != null) {
            if (!conceptPath2.lastPathComponent.equals(conceptPath.lastPathComponent)) {
                return false;
            }
            conceptPath = conceptPath.parentPath;
            conceptPath2 = conceptPath2.parentPath;
        }
        return false;
    }

    /*
     * Unable to fully structure code
     */
    public boolean isDescendant(ConceptPath var1_1) {
        block2: {
            if (var1_1 == this) {
                return true;
            }
            if (var1_1 == null) break block2;
            var2_2 = this.getPathCount();
            var3_3 = var1_1.getPathCount();
            if (var3_3 >= var2_2) ** GOTO lbl9
            return false;
lbl-1000:
            // 1 sources

            {
                var1_1 = var1_1.getParentPath();
lbl9:
                // 2 sources

                ** while (var3_3-- > var2_2)
            }
lbl10:
            // 1 sources

            return this.equals(var1_1);
        }
        return false;
    }

    public ConceptPath pathByAddingChild(Concept concept) {
        if (concept == null) {
            throw new NullPointerException("Null child not allowed");
        }
        return new ConceptPath(this, concept);
    }

    public ConceptPath getParentPath() {
        return this.parentPath;
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer("[ConceptPath ");
        int n = 0;
        int n2 = this.getPathCount();
        while (n < n2) {
            if (n > 0) {
                stringBuffer.append(", ");
            }
            stringBuffer.append(this.getPathComponent(n).getId());
            ++n;
        }
        stringBuffer.append("]");
        return stringBuffer.toString();
    }
}

