/*
 * Decompiled with CFR 0.152.
 */
package org.exteca.ontology;

import java.io.Serializable;
import java.text.Collator;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Properties;
import org.exteca.ontology.Content;

public abstract class Element
implements Cloneable,
Comparable,
Serializable {
    public static final String ASSOCIATION_TYPE = "associationType";
    public static final String ATTRIBUTE_TYPE = "attributeType";
    public static final String CONCEPT_TYPE = "conceptType";
    public static final String CONCEPT_PATH_TYPE = "conceptPathType";
    public static final String CONSTRAINT_TYPE = "constraintType";
    public static final String LINK_TYPE = "linkType";
    public static final String METADATA_TYPE = "metadataType";
    public static final String RESOURCE_TYPE = "resourceType";
    public static final String PROPERTY_TYPE = "propertyType";
    public static final String RULE_TYPE = "ruleType";
    public static final String VALUE_TYPE = "valueType";
    public static final String VALUES_TYPE = "valuesType";
    public static final String VALUE_RANGE_TYPE = "valueRangeType";
    public static final String CONTENT_TAG = "content";
    public static final String NAMESPACE_TAG = "namespace";
    public static final String PREFIX_TAG = "prefix";
    protected Content content;
    protected Properties tags;
    protected String elementId;
    protected String name;
    protected String comment;
    protected String description;
    protected String type;
    protected boolean disabled;
    protected boolean hidden;

    public String getType() {
        return this.type;
    }

    public void setType(String string) {
        this.type = string;
    }

    public Content getContent() {
        return this.content;
    }

    public Element setContent(Content content) {
        this.content = content;
        return this;
    }

    public String getId() {
        return this.elementId;
    }

    public void setId(String string) {
        this.elementId = string;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String string) {
        this.name = string;
    }

    public boolean isDisabled() {
        return this.disabled;
    }

    public void setDisabled(boolean bl) {
        this.disabled = bl;
    }

    public boolean isHidden() {
        return this.hidden;
    }

    public void setHidden(boolean bl) {
        this.hidden = bl;
    }

    public String getComment() {
        if (this.comment == null) {
            return this.getName();
        }
        return this.comment;
    }

    public void setComment(String string) {
        this.comment = string;
    }

    public String getDescription() {
        if (this.description == null) {
            return this.getName();
        }
        return this.description;
    }

    public void setDescription(String string) {
        this.description = string;
    }

    public void setTag(String string, String string2) {
        if (this.tags == null) {
            this.tags = new Properties();
        }
        this.tags.setProperty(string, string2);
    }

    public String getTag(String string) {
        if (this.tags == null) {
            return null;
        }
        return this.tags.getProperty(string);
    }

    public Enumeration tagNames() {
        if (this.tags == null) {
            this.tags = new Properties();
        }
        return ((Hashtable)this.tags).keys();
    }

    protected void addTags(Properties properties) {
        if (properties == null) {
            return;
        }
        Enumeration enumeration = ((Hashtable)properties).keys();
        while (enumeration.hasMoreElements()) {
            String string = (String)enumeration.nextElement();
            this.setTag(string, properties.getProperty(string));
        }
    }

    public int compareTo(Object object) {
        if (!(object instanceof Element)) {
            throw new ClassCastException("Elements can only be compared to other Elements");
        }
        Element element = (Element)object;
        String string = this.getTag("order");
        String string2 = element.getTag("order");
        if (string == null || string2 == null) {
            string = this.getId();
            string2 = element.getId();
            return Collator.getInstance().compare(string, string2);
        }
        Integer n = Integer.valueOf(string);
        Integer n2 = Integer.valueOf(string2);
        return n.compareTo(n2);
    }

    protected boolean isInEOL() {
        return "http://www.exteca.org/EOL".equals(this.getTag(NAMESPACE_TAG));
    }
}

