/*
 * Decompiled with CFR 0.152.
 */
package org.exteca.ontology;

import java.io.File;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Vector;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.exteca.ontology.Association;
import org.exteca.ontology.Attribute;
import org.exteca.ontology.Concept;
import org.exteca.ontology.OntologyContent;
import org.exteca.ontology.OntologyException;
import org.exteca.ontology.OntologyMetaData;
import org.exteca.ontology.OntologyPersistence;
import org.exteca.ontology.Property;
import org.exteca.utils.PropertyManager;

public class Ontology
implements Serializable {
    public static final String EOL_NAMESPACE = "http://www.exteca.org/EOL";
    public static final String TOP_CONCEPT_ID = ".TOP.";
    public static final String CHILD_OF_ID = "child-of";
    public static final String HAS_CHILD_ID = "has-child";
    public static final String INSTANCE_OF_ID = "instance-of";
    public static final String HAS_INSTANCE_ID = "has-instance";
    public static final String SUBCLASS_OF_ID = "subclass-of";
    public static final String HAS_SUBCLASS_ID = "has-subclass";
    public static final String SIGNPOST_OF_ID = "signpost-of";
    public static final String HAS_SIGNPOST_ID = "has-signpost";
    public static final int XML_PERSISTENCE = 0;
    public static final int SQL_PERSISTENCE = 1;
    protected int persistence = 0;
    protected OntologyContent content = new OntologyContent();
    private Log log = LogFactory.getLog((Class)(class$org$exteca$ontology$Ontology == null ? (class$org$exteca$ontology$Ontology = Ontology.class$("org.exteca.ontology.Ontology")) : class$org$exteca$ontology$Ontology));
    static /* synthetic */ Class class$org$exteca$ontology$Ontology;

    public Ontology() {
        String string = System.getProperty("exteca.module.properties");
        if (string != null) {
            try {
                PropertyManager.setProperties((String)string);
            }
            catch (Exception exception) {
                this.log.warn((Object)("PropertyManager: " + exception));
            }
        }
    }

    public Ontology(int n) {
        this.setPersistence(n);
    }

    public int getPersistence() {
        return this.persistence;
    }

    public void setPersistence(int n) {
        this.persistence = n;
    }

    public String getId() throws OntologyException {
        return this.content.getId();
    }

    public void setId(String string) throws OntologyException {
        this.content.setId(string);
    }

    public String getURI() throws OntologyException {
        return this.content.getURI();
    }

    public void setURI(String string) throws OntologyException {
        this.content.setURI(string);
    }

    public String getVersion() throws OntologyException {
        return this.content.getVersion();
    }

    public void setVersion(String string) throws OntologyException {
        this.content.setVersion(string);
    }

    public OntologyMetaData getMetaData() throws OntologyException {
        return (OntologyMetaData)this.content.getElement("metadataType", "ontologyMetaData");
    }

    public void setMetaData(OntologyMetaData ontologyMetaData) throws OntologyException {
        this.content.addElement(ontologyMetaData);
    }

    public static Association[] filterAssociations(Association[] associationArray, String string, String string2, boolean bl) throws OntologyException {
        if (string == null || string.equals("")) {
            throw new OntologyException("Cannot filter by a null or empty tag name");
        }
        if (string2 == null || string2.equals("")) {
            throw new OntologyException("Cannot filter by a null or empty tag value");
        }
        ArrayList<Association> arrayList = new ArrayList<Association>();
        int n = 0;
        while (n < associationArray.length) {
            if (bl && string2.equals(associationArray[n].getTag(string)) || !bl && !string2.equals(associationArray[n].getTag(string))) {
                arrayList.add(associationArray[n]);
            }
            ++n;
        }
        return arrayList.toArray(new Association[arrayList.size()]);
    }

    public Association[] getAssociations() throws OntologyException {
        Collection collection = this.content.getElements("associationType");
        if (collection == null) {
            return new Association[0];
        }
        return collection.toArray(new Association[collection.size()]);
    }

    public Association getAssociation(String string) throws OntologyException {
        if (string == null) {
            throw new OntologyException("Cannot return Association for a null id");
        }
        Association[] associationArray = this.getAssociations();
        int n = 0;
        while (n < associationArray.length) {
            if (string.equals(associationArray[n].getId()) || string.equals(associationArray[n].getInverseId())) {
                return associationArray[n];
            }
            ++n;
        }
        return null;
    }

    public Association[] getSubAssociations(String string) throws OntologyException {
        if (string == null) {
            throw new OntologyException("Cannot return sub-Associations for a null id");
        }
        Association[] associationArray = this.getAssociations();
        Association association = null;
        Vector<Association> vector = new Vector<Association>();
        int n = 0;
        while (n < associationArray.length) {
            association = associationArray[n].getSuperAssociation();
            if (association != null && (string.equals(association.getId()) || string.equals(association.getInverseId()))) {
                vector.add(associationArray[n]);
            }
            ++n;
        }
        return vector.toArray(new Association[vector.size()]);
    }

    public void addAssociation(Association association) throws OntologyException {
        this.content.addElement(association);
    }

    public void removeAssociation(Association association) throws OntologyException {
        this.content.removeElement(association);
    }

    public static Attribute[] filterAttributes(Attribute[] attributeArray, String string, String string2, boolean bl) throws OntologyException {
        if (string == null || string.equals("")) {
            throw new OntologyException("Cannot filter by a null or empty tag name");
        }
        if (string2 == null || string2.equals("")) {
            throw new OntologyException("Cannot filter by a null or empty tag value");
        }
        ArrayList<Attribute> arrayList = new ArrayList<Attribute>();
        int n = 0;
        while (n < attributeArray.length) {
            if (bl && string2.equals(attributeArray[n].getTag(string)) || !bl && !string2.equals(attributeArray[n].getTag(string))) {
                arrayList.add(attributeArray[n]);
            }
            ++n;
        }
        return arrayList.toArray(new Attribute[arrayList.size()]);
    }

    public Attribute[] getAttributes() throws OntologyException {
        Collection collection = this.content.getElements("attributeType");
        if (collection == null) {
            return new Attribute[0];
        }
        return collection.toArray(new Attribute[collection.size()]);
    }

    public Attribute getAttribute(String string) throws OntologyException {
        return (Attribute)this.content.getElement("attributeType", string);
    }

    public void addAttribute(Attribute attribute) throws OntologyException {
        this.content.addElement(attribute);
    }

    public void removeAttribute(Attribute attribute) throws OntologyException {
        this.content.removeElement(attribute);
    }

    public static Concept[] filterConcepts(Concept[] conceptArray, String string, String string2, boolean bl) throws OntologyException {
        if (string == null || string.equals("")) {
            throw new OntologyException("Cannot filter by a null or empty tag name");
        }
        if (string2 == null || string2.equals("")) {
            throw new OntologyException("Cannot filter by a null or empty tag value");
        }
        ArrayList<Concept> arrayList = new ArrayList<Concept>();
        int n = 0;
        while (n < conceptArray.length) {
            if (bl && string2.equals(conceptArray[n].getTag(string)) || !bl && !string2.equals(conceptArray[n].getTag(string))) {
                arrayList.add(conceptArray[n]);
            }
            ++n;
        }
        return arrayList.toArray(new Concept[arrayList.size()]);
    }

    public static Concept[] filterConcepts(Concept[] conceptArray, Property property, boolean bl) throws OntologyException {
        if (property == null) {
            throw new OntologyException("Cannot filter by a null property");
        }
        ArrayList<Concept> arrayList = new ArrayList<Concept>();
        int n = 0;
        while (n < conceptArray.length) {
            if (bl && conceptArray[n].hasProperty(property) || !bl && !conceptArray[n].hasProperty(property)) {
                arrayList.add(conceptArray[n]);
            }
            ++n;
        }
        return arrayList.toArray(new Concept[arrayList.size()]);
    }

    public Concept[] getConcepts() throws OntologyException {
        Collection collection = this.content.getElements("conceptType");
        if (collection == null) {
            return new Concept[0];
        }
        return Ontology.filterConcepts(collection.toArray(new Concept[collection.size()]), new Property(new Attribute("hidden-concept", "String"), "true"), false);
    }

    public Concept getConcept(String string) throws OntologyException {
        return (Concept)this.content.getElement("conceptType", string);
    }

    public Concept getTopConcept() throws OntologyException {
        return (Concept)this.content.getElement("conceptType", TOP_CONCEPT_ID);
    }

    public void addConcept(Concept concept) throws OntologyException {
        this.content.addElement(concept);
    }

    public void removeConcept(Concept concept) throws OntologyException {
        this.content.removeElement(concept);
    }

    public void read(String string) throws OntologyException {
        this.content = OntologyPersistence.read(this.persistence, string);
    }

    public void read(InputStream inputStream) throws OntologyException {
        this.content = OntologyPersistence.read(inputStream);
    }

    public void write(File file) throws OntologyException {
        OntologyPersistence.write(this, file);
    }

    public void write(OutputStream outputStream) throws OntologyException {
        OntologyPersistence.write(this, outputStream);
    }

    public static void main(String[] stringArray) {
        Ontology ontology = new Ontology();
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

