/*
 * Decompiled with CFR 0.152.
 */
package org.exteca.ontology;

import java.util.ArrayList;
import java.util.List;
import org.apache.regexp.RE;
import org.apache.regexp.RESyntaxException;
import org.exteca.ontology.Element;
import org.exteca.ontology.Value;
import org.exteca.ontology.ValueRange;

public class Values
extends Element {
    public static final String MATCH = "[\\w\\s-,]+";
    public static final String SPLIT = "[,]+";
    public static final int SINGLE = 0;
    public static final int RANGE = 1;
    public static final int LIST = 2;
    protected List valueList = new ArrayList();
    protected String dataType;
    protected int enumType;

    public Values(String string, String string2) {
        this.setId(string);
        this.setDataType(string2);
        if (this.patternMatches(MATCH, string)) {
            this.setEnumType(2);
            String[] stringArray = this.split(string);
            int n = 0;
            while (n < stringArray.length) {
                String string3 = stringArray[n];
                if (this.patternMatches("[\\w\\s]+-[\\w\\s]+", string3)) {
                    this.addValue(new ValueRange(string3, string2));
                } else if (this.patternMatches(Value.MATCH, string3)) {
                    this.addValue(new Value(string3, string2));
                }
                ++n;
            }
        } else if (this.patternMatches("[\\w\\s]+-[\\w\\s]+", string)) {
            this.setEnumType(1);
            this.addValue(new ValueRange(string, string2));
        } else if (this.patternMatches(Value.MATCH, string)) {
            this.setEnumType(0);
            this.addValue(new Value(string, string2));
        }
    }

    public String getDataType() {
        return this.dataType;
    }

    public void setDataType(String string) {
        this.dataType = string;
    }

    public int getEnumType() {
        return this.enumType;
    }

    public void setEnumType(int n) {
        this.enumType = this.enumType;
    }

    public void addValue(Value value) {
        this.valueList.add(value);
    }

    public void removeValue(Value value) {
        this.valueList.remove(value);
    }

    private boolean patternMatches(String string, String string2) {
        try {
            RE rE = new RE(string);
            return rE.match(string2);
        }
        catch (RESyntaxException rESyntaxException) {
            return false;
        }
    }

    private String[] split(String string) {
        try {
            RE rE = new RE(SPLIT);
            return rE.split(string);
        }
        catch (RESyntaxException rESyntaxException) {
            return new String[0];
        }
    }

    public String toString() {
        return "[Values id=" + this.getId() + " dataType=" + this.getDataType() + "]";
    }
}

