/*
 * Decompiled with CFR 0.152.
 */
package org.exteca.ontology.rule;

import java.util.StringTokenizer;
import java.util.Vector;
import org.exteca.ontology.rule.RuleException;
import org.exteca.ontology.rule.RuleListener;

public class RuleParser {
    protected Vector listeners;

    public synchronized void addRuleListener(RuleListener ruleListener) {
        if (this.listeners == null) {
            this.listeners = new Vector();
        }
        this.listeners.addElement(ruleListener);
    }

    public synchronized void removeRuleListener(RuleListener ruleListener) {
        if (this.listeners == null) {
            return;
        }
        this.listeners.removeElement(ruleListener);
    }

    public void parse(String string) throws RuleException {
        this.parse(string.toCharArray());
    }

    /*
     * Unable to fully structure code
     */
    public void parse(char[] var1_1) throws RuleException {
        var2_2 = 0;
        var3_3 = var1_1.length;
        var4_4 = 0;
        var5_5 = 100;
        ** GOTO lbl53
        {
            ++var2_2;
            do {
                if (var2_2 < var3_3 && var1_1[var2_2] == ' ') continue block0;
                if (var1_1[var2_2] == '\'') {
                    var6_6 = ++var2_2;
                    while (var2_2 < var3_3 && var1_1[var2_2] != '\'') {
                        ++var2_2;
                    }
                    if (var2_2 == var3_3 || var1_1[var2_2] != '\'') {
                        throw new RuleException(var1_1, var2_2, "word or phrase not terminated");
                    }
                    var7_7 = new String(var1_1, var6_6, var2_2 - var6_6);
                    this.parseText(var7_7, var5_5);
                    ++var2_2;
                    continue;
                }
                if (var1_1[var2_2] == ',') {
                    if (var4_4 > 0) {
                        ++var2_2;
                        continue;
                    }
                    throw new RuleException(var1_1, var2_2, "comma not expected here");
                }
                if (var1_1[var2_2] == ')') {
                    if (var4_4 > 0) {
                        --var4_4;
                        ++var2_2;
                        this.fireRuleEnded();
                        continue;
                    }
                    throw new RuleException(var1_1, var2_2, "bracket not expected here");
                }
                if (var1_1[var2_2] >= '0' && var1_1[var2_2] <= '9') {
                    var6_6 = var2_2;
                    while (var2_2 < var3_3 && var1_1[var2_2] >= '0' && var1_1[var2_2] <= '9' && var1_1[var2_2] != ':') {
                        ++var2_2;
                    }
                    if (var2_2 == var3_3 || var1_1[var2_2] != ':') {
                        throw new RuleException(var1_1, var2_2, "expected ':'");
                    }
                    var7_7 = new String(var1_1, var6_6, var2_2 - var6_6);
                    var5_5 = Integer.parseInt(var7_7);
                    ++var2_2;
                    continue;
                }
                var6_6 = var2_2;
                ++var4_4;
                while (var2_2 < var3_3 && var1_1[var2_2] != '(') {
                    ++var2_2;
                }
                if (var2_2 == var3_3 || var1_1[var2_2] != '(') {
                    throw new RuleException(var1_1, var2_2, "expected '('");
                }
                var7_7 = new String(var1_1, var6_6, var2_2 - var6_6);
                this.fireRuleStarted(var7_7, var5_5);
                ++var2_2;
lbl53:
                // 6 sources

            } while (var2_2 < var3_3);
        }
    }

    void parseText(String string, int n) throws RuleException {
        StringTokenizer stringTokenizer = new StringTokenizer(string, " ");
        if (stringTokenizer.countTokens() == 1) {
            if (string.charAt(0) == '#') {
                this.parseMorph(string, n);
            } else {
                this.fireTextFound(string, n);
            }
        } else {
            this.fireRuleStarted("sequence", n);
            while (stringTokenizer.hasMoreTokens()) {
                String string2 = stringTokenizer.nextToken();
                if (string2.charAt(0) == '#') {
                    this.parseMorph(string2, n);
                    continue;
                }
                this.fireTextFound(string2, 100);
            }
            this.fireRuleEnded();
        }
    }

    void parseMorph(String string, int n) throws RuleException {
        boolean bl = false;
        int n2 = string.indexOf(40);
        if (n2 == -1) {
            throw new RuleException(string.toCharArray(), n2, "expected '('");
        }
        if (string.charAt(1) == '-') {
            bl = true;
        }
        String string2 = string.substring(bl ? 2 : 1, n2);
        int n3 = string.indexOf(41);
        if (n3 == -1) {
            throw new RuleException(string.toCharArray(), n3, "expected ')'");
        }
        String string3 = string.substring(n2 + 1, n3);
        this.fireMorphemeFound(string3, n, string2, bl);
    }

    public void fireRuleStarted(String string, int n) {
        Vector vector = null;
        RuleParser ruleParser = this;
        synchronized (ruleParser) {
            if (this.listeners != null) {
                vector = (Vector)this.listeners.clone();
            }
        }
        if (vector != null) {
            int n2 = 0;
            while (n2 < vector.size()) {
                RuleListener ruleListener = (RuleListener)vector.elementAt(n2);
                ruleListener.ruleStarted(string, n);
                ++n2;
            }
        }
    }

    public void fireRuleEnded() {
        Vector vector = null;
        RuleParser ruleParser = this;
        synchronized (ruleParser) {
            if (this.listeners != null) {
                vector = (Vector)this.listeners.clone();
            }
        }
        if (vector != null) {
            int n = 0;
            while (n < vector.size()) {
                RuleListener ruleListener = (RuleListener)vector.elementAt(n);
                ruleListener.ruleEnded();
                ++n;
            }
        }
    }

    public void fireTextFound(String string, int n) {
        Vector vector = null;
        RuleParser ruleParser = this;
        synchronized (ruleParser) {
            if (this.listeners != null) {
                vector = (Vector)this.listeners.clone();
            }
        }
        if (vector != null) {
            int n2 = 0;
            while (n2 < vector.size()) {
                RuleListener ruleListener = (RuleListener)vector.elementAt(n2);
                ruleListener.textFound(string, n);
                ++n2;
            }
        }
    }

    public void fireMorphemeFound(String string, int n, String string2, boolean bl) {
        Vector vector = null;
        RuleParser ruleParser = this;
        synchronized (ruleParser) {
            if (this.listeners != null) {
                vector = (Vector)this.listeners.clone();
            }
        }
        if (vector != null) {
            int n2 = 0;
            while (n2 < vector.size()) {
                RuleListener ruleListener = (RuleListener)vector.elementAt(n2);
                ruleListener.morphemeFound(string, n, string2, bl);
                ++n2;
            }
        }
    }
}

