/*
 * Decompiled with CFR 0.152.
 */
package org.exteca.ontology.xml;

import java.io.Serializable;
import java.util.Collection;
import java.util.Iterator;
import org.exteca.ontology.Association;
import org.exteca.ontology.Attribute;
import org.exteca.ontology.Concept;
import org.exteca.ontology.Constraint;
import org.exteca.ontology.Element;
import org.exteca.ontology.Link;
import org.exteca.ontology.OntologyContent;
import org.exteca.ontology.OntologyException;
import org.exteca.ontology.OntologyMetaData;
import org.exteca.ontology.Property;
import org.exteca.ontology.Resource;
import org.exteca.ontology.Rule;
import org.exteca.ontology.Values;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.ext.DeclHandler;
import org.xml.sax.ext.LexicalHandler;
import org.xml.sax.helpers.DefaultHandler;

public class SAXContentHandler
extends DefaultHandler
implements LexicalHandler,
DeclHandler,
Serializable {
    public static final String ONTOLOGY_ELEMENT = "ontology";
    public static final String ONTOLOGY_METADATA_ELEMENT = "ontology-metadata";
    public static final String ASSOCIATION_ELEMENT = "association";
    public static final String ATTRIBUTE_ELEMENT = "attribute";
    public static final String CARDINALITY_ELEMENT = "cardinality";
    public static final String CONCEPT_ELEMENT = "concept";
    public static final String CONCEPT_CONTENT_ELEMENT = "concept-content";
    public static final String COMMENT_ELEMENT = "comment";
    public static final String CONTENTS_ELEMENT = "contents";
    public static final String DESCRIPTION_ELEMENT = "description";
    public static final String EXISTS_LINK_ELEMENT = "exists-link";
    public static final String FORALL_LINKS_ELEMENT = "forall-links";
    public static final String HAS_INSTANCE_ELEMENT = "has-instance";
    public static final String HAS_SIGNPOST_ELEMENT = "has-signpost";
    public static final String HAS_SUBCLASS_ELEMENT = "has-subclass";
    public static final String INSTANCE_OF_ELEMENT = "instance-of";
    public static final String LINK_ELEMENT = "link";
    public static final String MAPPING_ELEMENT = "mapping";
    public static final String METADATA_ELEMENT = "metadata";
    public static final String METADATA_PREFIX = "metadata-";
    public static final String PROPERTY_ELEMENT = "property";
    public static final String RESOURCE_ELEMENT = "resource";
    public static final String RESOURCES_ELEMENT = "resources";
    public static final String RULE_ELEMENT = "rule";
    public static final String RULES_ELEMENT = "rules";
    public static final String SIGNPOST_OF_ELEMENT = "signpost-of";
    public static final String SUBASSOCIATION_OF_ELEMENT = "subassociation-of";
    public static final String SUBCLASS_OF_ELEMENT = "subclass-of";
    public static final String ASSOCIATION_ATTRIBUTE = "association";
    public static final String ATTRIBUTE_ATTRIBUTE = "attribute";
    public static final String CARDINALITY_ATTRIBUTE = "cardinality";
    public static final String CONCEPT_ATTRIBUTE = "concept";
    public static final String CONTENT_ATTRIBUTE = "content";
    public static final String COUNT_ATTRIBUTE = "count";
    public static final String DATA_TYPE_ATTRIBUTE = "data-type";
    public static final String DOMAIN_ATTRIBUTE = "domain";
    public static final String ID_ATTRIBUTE = "id";
    public static final String INVERSE_ID_ATTRIBUTE = "inverse-id";
    public static final String INVERSE_COUNT_ATTRIBUTE = "inverse-count";
    public static final String LOGIC_ATTRIBUTE = "logic";
    public static final String NAME_ATTRIBUTE = "name";
    public static final String RANGE_ATTRIBUTE = "range";
    public static final String STRENGTH_ATTRIBUTE = "strength";
    public static final String URI_ATTRIBUTE = "uri";
    public static final String VALUE_ATTRIBUTE = "value";
    public static final String VERSION_ATTRIBUTE = "version";
    private OntologyContent content;
    private Concept concept;
    private Element element;
    private String contentId;
    private StringBuffer characters;
    private boolean atRoot = true;
    private boolean inDTD = false;
    private boolean inCDATA = false;
    private boolean expand = true;
    private boolean ignoreWhitespace = false;

    public SAXContentHandler(OntologyContent ontologyContent) {
        this.content = ontologyContent;
    }

    public OntologyContent getContent() {
        return this.content;
    }

    public void setExpandEntities(boolean bl) {
        this.expand = bl;
    }

    public void setIgnoreWhitespace(boolean bl) {
        this.ignoreWhitespace = bl;
    }

    public void externalEntityDecl(String string, String string2, String string3) throws SAXException {
    }

    public void attributeDecl(String string, String string2, String string3, String string4, String string5) {
    }

    public void elementDecl(String string, String string2) {
    }

    public void internalEntityDecl(String string, String string2) {
    }

    public void processingInstruction(String string, String string2) throws SAXException {
    }

    public void startElement(String string, String string2, String string3, Attributes attributes) throws SAXException {
        this.characters = new StringBuffer();
        try {
            if (string2.equals(ONTOLOGY_ELEMENT)) {
                this.content.setId(this.extractAttribute(attributes, ID_ATTRIBUTE));
                this.content.setURI(this.extractAttribute(attributes, URI_ATTRIBUTE));
                this.content.setVersion(this.extractAttribute(attributes, VERSION_ATTRIBUTE));
            } else if (string2.equals(METADATA_ELEMENT)) {
                this.element = new OntologyMetaData();
                int n = 0;
                while (n < attributes.getLength()) {
                    ((OntologyMetaData)this.element).setCoreElement(attributes.getLocalName(n), attributes.getValue(n));
                    ++n;
                }
            } else if (string2.equals("association")) {
                this.element = new Association(this.extractAttribute(attributes, ID_ATTRIBUTE), this.extractAttribute(attributes, INVERSE_ID_ATTRIBUTE));
                this.content.addElement(this.element);
            } else if (string2.equals(SUBASSOCIATION_OF_ELEMENT)) {
                Association association = (Association)this.content.getElement("associationType", this.extractAttribute(attributes, ID_ATTRIBUTE));
                ((Association)this.element).setSuperAssociation(association);
            } else if (string2.equals("attribute")) {
                this.element = new Attribute(this.extractAttribute(attributes, ID_ATTRIBUTE), this.extractAttribute(attributes, DATA_TYPE_ATTRIBUTE));
                this.content.addElement(this.element);
            } else if (string2.equals("cardinality")) {
                if (this.containsAttribute(attributes, COUNT_ATTRIBUTE)) {
                    ((Association)this.element).setCardinality(this.extractAttribute(attributes, COUNT_ATTRIBUTE));
                }
                if (this.containsAttribute(attributes, INVERSE_COUNT_ATTRIBUTE)) {
                    ((Association)this.element).setInverseCardinality(this.extractAttribute(attributes, INVERSE_COUNT_ATTRIBUTE));
                }
            } else if (string2.equals("concept")) {
                this.element = this.content.getElement("conceptType", this.extractAttribute(attributes, ID_ATTRIBUTE));
                if (this.element == null) {
                    this.element = new Concept(this.extractAttribute(attributes, ID_ATTRIBUTE));
                    this.content.addElement(this.element);
                }
                if (this.containsAttribute(attributes, NAME_ATTRIBUTE)) {
                    this.element.setName(this.extractAttribute(attributes, NAME_ATTRIBUTE));
                }
                this.concept = (Concept)this.element;
            } else if (string2.equals(CONCEPT_CONTENT_ELEMENT)) {
                this.element = this.content.getElement("conceptType", this.extractAttribute(attributes, "concept"));
                if (this.element == null) {
                    this.element = new Concept(this.extractAttribute(attributes, "concept"));
                    this.content.addElement(this.element);
                }
                this.concept = (Concept)this.element;
            } else if (!string2.equals(CONTENTS_ELEMENT)) {
                if (string2.equals(EXISTS_LINK_ELEMENT)) {
                    this.element = new Constraint(0);
                    Link link = this.createLink(this.extractAttribute(attributes, "association"), this.extractAttribute(attributes, "concept"), false);
                    ((Constraint)this.element).setLink(link);
                    if (this.containsAttribute(attributes, "cardinality")) {
                        ((Constraint)this.element).setLinkCardinality(this.extractAttribute(attributes, "cardinality"));
                    }
                    this.concept.addConstraint((Constraint)this.element);
                } else if (string2.equals(FORALL_LINKS_ELEMENT)) {
                    this.element = new Constraint(1);
                    Link link = this.createLink(this.extractAttribute(attributes, "association"), this.extractAttribute(attributes, "concept"), false);
                    ((Constraint)this.element).setLink(link);
                    this.concept.addConstraint((Constraint)this.element);
                } else if (string2.equals(LINK_ELEMENT)) {
                    Link link = this.createLink(this.extractAttribute(attributes, "association"), this.extractAttribute(attributes, "concept"), true);
                    if (this.containsAttribute(attributes, STRENGTH_ATTRIBUTE)) {
                        try {
                            link.setStrength(Integer.parseInt(this.extractAttribute(attributes, STRENGTH_ATTRIBUTE)));
                        }
                        catch (NumberFormatException numberFormatException) {
                            throw new SAXException("Link attribute strength has invalid format " + this.extractAttribute(attributes, STRENGTH_ATTRIBUTE));
                        }
                    }
                    this.concept.addLink(link);
                    this.element = link;
                } else if (string2.equals(MAPPING_ELEMENT)) {
                    Concept concept = null;
                    if (this.containsAttribute(attributes, DOMAIN_ATTRIBUTE) && (concept = (Concept)this.content.getElement("conceptType", this.extractAttribute(attributes, DOMAIN_ATTRIBUTE))) == null) {
                        concept = new Concept(this.extractAttribute(attributes, DOMAIN_ATTRIBUTE));
                    }
                    if (this.element instanceof Association) {
                        ((Association)this.element).setDomain(concept);
                    } else if (this.element instanceof Attribute) {
                        ((Attribute)this.element).setDomain(concept);
                    }
                    if (this.containsAttribute(attributes, RANGE_ATTRIBUTE)) {
                        if (this.element instanceof Association) {
                            Concept concept2 = (Concept)this.content.getElement("conceptType", this.extractAttribute(attributes, RANGE_ATTRIBUTE));
                            if (concept2 == null) {
                                concept2 = new Concept(this.extractAttribute(attributes, RANGE_ATTRIBUTE));
                            }
                            ((Association)this.element).setRange(concept2);
                        } else if (this.element instanceof Attribute) {
                            Values values = new Values(this.extractAttribute(attributes, RANGE_ATTRIBUTE), ((Attribute)this.element).getDataType());
                            ((Attribute)this.element).setRange(values);
                        }
                    }
                } else if (string2.equals(PROPERTY_ELEMENT)) {
                    this.element = this.createProperty(this.extractAttribute(attributes, "attribute"), this.extractAttribute(attributes, VALUE_ATTRIBUTE));
                    this.concept.addProperty((Property)this.element);
                } else if (string2.equals(RESOURCES_ELEMENT)) {
                    this.contentId = this.extractAttribute(attributes, CONTENT_ATTRIBUTE);
                } else if (string2.equals(RESOURCE_ELEMENT)) {
                    this.element = new Resource(this.extractAttribute(attributes, URI_ATTRIBUTE));
                    if (this.containsAttribute(attributes, NAME_ATTRIBUTE)) {
                        ((Resource)this.element).setName(this.extractAttribute(attributes, NAME_ATTRIBUTE));
                    }
                    this.tagElement(this.element, CONTENT_ATTRIBUTE, this.contentId);
                    this.concept.addResource((Resource)this.element);
                } else if (string2.equals(RULES_ELEMENT)) {
                    this.contentId = this.extractAttribute(attributes, CONTENT_ATTRIBUTE);
                } else if (string2.equals(RULE_ELEMENT)) {
                    this.element = new Rule(this.extractAttribute(attributes, LOGIC_ATTRIBUTE));
                    if (this.containsAttribute(attributes, NAME_ATTRIBUTE)) {
                        ((Rule)this.element).setName(this.extractAttribute(attributes, NAME_ATTRIBUTE));
                    }
                    this.tagElement(this.element, CONTENT_ATTRIBUTE, this.contentId);
                    this.concept.addRule((Rule)this.element);
                } else if (string2.equals(INSTANCE_OF_ELEMENT) || string2.equals(HAS_INSTANCE_ELEMENT) || string2.equals(SIGNPOST_OF_ELEMENT) || string2.equals(HAS_SIGNPOST_ELEMENT) || string2.equals(SUBCLASS_OF_ELEMENT) || string2.equals(HAS_SUBCLASS_ELEMENT)) {
                    Link link = this.createLink(string2, this.extractAttribute(attributes, "concept"), true);
                    this.concept.addLink(link);
                    this.element = link;
                }
            }
            if (string.length() != 0) {
                this.tagElement(this.element, "namespace", string);
                this.tagElement(this.element, "prefix", string3.substring(0, string3.indexOf(58)));
            }
        }
        catch (OntologyException ontologyException) {
            throw new SAXException(ontologyException);
        }
    }

    public void endElement(String string, String string2, String string3) throws SAXException {
        if (string2.equals(COMMENT_ELEMENT)) {
            this.element.setComment(this.characters.toString());
        } else if (string2.equals(DESCRIPTION_ELEMENT)) {
            this.element.setDescription(this.characters.toString());
        } else if (string2.startsWith(METADATA_PREFIX)) {
            ((OntologyMetaData)this.element).setCoreElement(string2.substring(METADATA_PREFIX.length(), string2.length()), this.characters.toString());
        } else if (string2.equals(METADATA_ELEMENT)) {
            this.content.addElement(this.element);
        }
    }

    private boolean containsAttribute(Attributes attributes, String string) throws OntologyException {
        if (attributes == null) {
            throw new OntologyException("Attributes list is invalid");
        }
        return attributes.getValue(string) != null;
    }

    private String extractAttribute(Attributes attributes, String string) throws OntologyException {
        if (attributes == null || attributes.getValue(string) == null) {
            throw new OntologyException("Attribute " + string + " not found in Element");
        }
        return attributes.getValue(string).trim();
    }

    private Association getAssociation(String string) {
        Collection collection = this.content.getElements("associationType");
        Iterator iterator = collection.iterator();
        while (iterator.hasNext()) {
            Association association = (Association)iterator.next();
            if (!string.equals(association.getId()) && !string.equals(association.getInverseId())) continue;
            return association;
        }
        return null;
    }

    private Link createLink(String string, String string2, boolean bl) throws OntologyException {
        Association association = this.getAssociation(string);
        if (association == null) {
            throw new OntologyException("Unknown association " + string);
        }
        Concept concept = (Concept)this.content.getElement("conceptType", string2);
        if (concept == null) {
            concept = new Concept(string2);
            this.content.addElement(concept);
        }
        Link link = new Link(association, this.concept, concept);
        if (string.equals(association.getId())) {
            link.setTag("associationId", ID_ATTRIBUTE);
        } else if (string.equals(association.getInverseId())) {
            link.setTag("associationId", "inverseId");
        }
        if (bl) {
            Link link2 = new Link(association, concept, this.concept);
            if (string.equals(association.getId())) {
                link2.setTag("associationId", "inverseId");
            } else if (string.equals(association.getInverseId())) {
                link2.setTag("associationId", ID_ATTRIBUTE);
            }
            concept.addLink(link2);
        }
        return link;
    }

    private Property createProperty(String string, String string2) throws OntologyException {
        Attribute attribute = (Attribute)this.content.getElement("attributeType", string);
        if (attribute == null) {
            throw new OntologyException("Unknown attribute " + string);
        }
        return new Property(attribute, string2);
    }

    private void tagElement(Element element, String string, String string2) {
        if (element == null) {
            return;
        }
        if (string == null || string.equals("")) {
            return;
        }
        if (string2 == null || string2.equals("")) {
            return;
        }
        element.setTag(string, string2);
    }

    public void characters(char[] cArray, int n, int n2) throws SAXException {
        this.characters.append(cArray, n, n2);
    }

    public void ignorableWhitespace(char[] cArray, int n, int n2) throws SAXException {
        if (this.ignoreWhitespace) {
            return;
        }
    }

    public void startDTD(String string, String string2, String string3) throws SAXException {
        this.inDTD = true;
    }

    public void endDTD() throws SAXException {
        this.inDTD = false;
    }

    public void startEntity(String string) throws SAXException {
    }

    public void endEntity(String string) throws SAXException {
    }

    public void startCDATA() throws SAXException {
    }

    public void endCDATA() throws SAXException {
    }

    public void comment(char[] cArray, int n, int n2) throws SAXException {
    }
}

