/*
 * Decompiled with CFR 0.152.
 */
package org.exteca.ontology.xml;

import java.io.File;
import java.io.InputStream;
import java.io.Reader;
import java.io.Serializable;
import java.net.MalformedURLException;
import java.net.URL;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.exteca.ontology.OntologyContent;
import org.exteca.ontology.OntologyException;
import org.exteca.ontology.xml.DefaultErrorHandler;
import org.exteca.ontology.xml.SAXContentHandler;
import org.xml.sax.DTDHandler;
import org.xml.sax.EntityResolver;
import org.xml.sax.ErrorHandler;
import org.xml.sax.InputSource;
import org.xml.sax.SAXNotRecognizedException;
import org.xml.sax.SAXNotSupportedException;
import org.xml.sax.SAXParseException;
import org.xml.sax.XMLFilter;
import org.xml.sax.XMLReader;
import org.xml.sax.helpers.XMLReaderFactory;

public class SAXOntologyParser
implements Serializable {
    private static final String DEFAULT_SAX_PARSER = "org.apache.xerces.parsers.SAXParser";
    private String saxParserClassName;
    private boolean useJAXP = true;
    private boolean validate = false;
    private boolean expand = true;
    private boolean ignoreWhitespace = false;
    private ErrorHandler saxErrorHandler = null;
    private EntityResolver saxEntityResolver = null;
    private DTDHandler saxDTDHandler = null;
    private XMLFilter saxXMLFilter = null;
    private OntologyContent content;
    Log log = LogFactory.getLog((Class)(class$org$exteca$ontology$xml$SAXOntologyParser == null ? (class$org$exteca$ontology$xml$SAXOntologyParser = SAXOntologyParser.class$("org.exteca.ontology.xml.SAXOntologyParser")) : class$org$exteca$ontology$xml$SAXOntologyParser));
    static /* synthetic */ Class class$org$exteca$ontology$xml$SAXOntologyParser;

    public SAXOntologyParser() {
    }

    public SAXOntologyParser(OntologyContent ontologyContent) {
        this.setOntologyContent(ontologyContent);
    }

    public void setParserClassName(String string) {
        this.saxParserClassName = string;
    }

    public void setUseJAXP(boolean bl) {
        this.useJAXP = bl;
    }

    public void setValidation(boolean bl) {
        this.validate = bl;
    }

    public void setIgnoreWhitespace(boolean bl) {
        this.ignoreWhitespace = bl;
    }

    public void setExpandEntities(boolean bl) {
        this.expand = bl;
    }

    public void setErrorHandler(ErrorHandler errorHandler) {
        this.saxErrorHandler = errorHandler;
    }

    public void setEntityResolver(EntityResolver entityResolver) {
        this.saxEntityResolver = entityResolver;
    }

    public void setDTDHandler(DTDHandler dTDHandler) {
        this.saxDTDHandler = dTDHandler;
    }

    public void setXMLFilter(XMLFilter xMLFilter) {
        this.saxXMLFilter = xMLFilter;
    }

    public void setOntologyContent(OntologyContent ontologyContent) {
        this.content = ontologyContent;
    }

    protected SAXContentHandler createContentHandler() {
        if (this.content == null) {
            this.content = new OntologyContent();
        }
        SAXContentHandler sAXContentHandler = new SAXContentHandler(this.content);
        return sAXContentHandler;
    }

    protected void configureContentHandler(SAXContentHandler sAXContentHandler) {
        sAXContentHandler.setExpandEntities(this.expand);
        sAXContentHandler.setIgnoreWhitespace(this.ignoreWhitespace);
    }

    protected XMLReader createXMLReader() throws Exception {
        XMLReader xMLReader = null;
        if (this.useJAXP) {
            SAXParser sAXParser = SAXParserFactory.newInstance().newSAXParser();
            xMLReader = sAXParser.getXMLReader();
            this.saxParserClassName = xMLReader.getClass().getName();
            this.log.info((Object)("Using JAXP parser " + xMLReader.getClass().getName()));
        } else if (this.saxParserClassName != null) {
            xMLReader = XMLReaderFactory.createXMLReader(this.saxParserClassName);
            this.log.info((Object)("Using specific parser " + this.saxParserClassName));
        }
        if (xMLReader == null) {
            xMLReader = XMLReaderFactory.createXMLReader(DEFAULT_SAX_PARSER);
            this.log.info((Object)"Using default parser org.apache.xerces.parsers.SAXParser");
            this.saxParserClassName = xMLReader.getClass().getName();
        }
        return xMLReader;
    }

    protected void configureXMLReader(XMLReader xMLReader, SAXContentHandler sAXContentHandler) throws Exception {
        block23: {
            if (this.saxXMLFilter != null) {
                XMLFilter xMLFilter = this.saxXMLFilter;
                while (xMLFilter.getParent() instanceof XMLFilter) {
                    xMLFilter = (XMLFilter)xMLFilter.getParent();
                }
                xMLFilter.setParent(xMLReader);
                xMLReader = this.saxXMLFilter;
            }
            xMLReader.setContentHandler(sAXContentHandler);
            if (this.saxEntityResolver != null) {
                xMLReader.setEntityResolver(this.saxEntityResolver);
            }
            if (this.saxDTDHandler != null) {
                xMLReader.setDTDHandler(this.saxDTDHandler);
            }
            if (this.saxErrorHandler != null) {
                xMLReader.setErrorHandler(this.saxErrorHandler);
            } else {
                xMLReader.setErrorHandler(new DefaultErrorHandler());
            }
            boolean bl = false;
            try {
                xMLReader.setProperty("http://xml.org/sax/handlers/LexicalHandler", sAXContentHandler);
                bl = true;
            }
            catch (SAXNotSupportedException sAXNotSupportedException) {
            }
            catch (SAXNotRecognizedException sAXNotRecognizedException) {
                // empty catch block
            }
            if (!bl) {
                try {
                    xMLReader.setProperty("http://xml.org/sax/properties/lexical-handler", sAXContentHandler);
                    bl = true;
                }
                catch (SAXNotSupportedException sAXNotSupportedException) {
                }
                catch (SAXNotRecognizedException sAXNotRecognizedException) {
                    // empty catch block
                }
            }
            if (!this.expand) {
                try {
                    xMLReader.setProperty("http://xml.org/sax/properties/declaration-handler", sAXContentHandler);
                }
                catch (SAXNotSupportedException sAXNotSupportedException) {
                }
                catch (SAXNotRecognizedException sAXNotRecognizedException) {
                    // empty catch block
                }
            }
            try {
                this.internalSetFeature(xMLReader, "http://xml.org/sax/features/validation", this.validate, "Validation");
            }
            catch (OntologyException ontologyException) {
                if (!this.validate) break block23;
                throw ontologyException;
            }
        }
        this.internalSetFeature(xMLReader, "http://xml.org/sax/features/namespaces", true, "Namespaces");
        this.internalSetFeature(xMLReader, "http://xml.org/sax/features/namespace-prefixes", false, "Namespace prefixes");
        try {
            if (xMLReader.getFeature("http://xml.org/sax/features/external-general-entities") != this.expand) {
                xMLReader.setFeature("http://xml.org/sax/features/external-general-entities", this.expand);
            }
        }
        catch (SAXNotRecognizedException sAXNotRecognizedException) {
        }
        catch (SAXNotSupportedException sAXNotSupportedException) {
            // empty catch block
        }
    }

    private void internalSetFeature(XMLReader xMLReader, String string, boolean bl, String string2) throws OntologyException {
        try {
            xMLReader.setFeature(string, bl);
        }
        catch (SAXNotSupportedException sAXNotSupportedException) {
            throw new OntologyException(string2 + " not supported for SAX driver " + this.saxParserClassName);
        }
        catch (SAXNotRecognizedException sAXNotRecognizedException) {
            throw new OntologyException(string2 + " feature not recognized for SAX driver" + this.saxParserClassName);
        }
    }

    public OntologyContent read(InputSource inputSource) throws OntologyException {
        SAXContentHandler sAXContentHandler = null;
        try {
            try {
                sAXContentHandler = this.createContentHandler();
                this.configureContentHandler(sAXContentHandler);
                XMLReader xMLReader = this.createXMLReader();
                this.configureXMLReader(xMLReader, sAXContentHandler);
                xMLReader.parse(inputSource);
                OntologyContent ontologyContent = sAXContentHandler.getContent();
                Object var7_7 = null;
                sAXContentHandler = null;
                return ontologyContent;
            }
            catch (Exception exception) {
                if (exception instanceof SAXParseException) {
                    SAXParseException sAXParseException = (SAXParseException)exception;
                    String string = sAXParseException.getSystemId();
                    if (string != null) {
                        throw new OntologyException("Error on line " + sAXParseException.getLineNumber() + " of document " + string, exception);
                    }
                    throw new OntologyException("Error on line " + sAXParseException.getLineNumber(), exception);
                }
                if (exception instanceof SecurityException) {
                    System.out.println("SecurityException");
                    throw (OntologyException)exception;
                }
                if (exception instanceof OntologyException) {
                    throw (OntologyException)exception;
                }
                exception.printStackTrace();
                throw new OntologyException("Error in parsing", exception);
            }
        }
        catch (Throwable throwable) {
            Object var7_8 = null;
            sAXContentHandler = null;
            throw throwable;
        }
    }

    public OntologyContent read(File file) throws OntologyException {
        try {
            URL uRL = file.toURL();
            return this.read(uRL);
        }
        catch (MalformedURLException malformedURLException) {
            throw new OntologyException("Error in reading", malformedURLException);
        }
    }

    public OntologyContent read(InputStream inputStream) throws OntologyException {
        return this.read(new InputSource(inputStream));
    }

    public OntologyContent read(Reader reader) throws OntologyException {
        return this.read(new InputSource(reader));
    }

    public OntologyContent read(String string) throws OntologyException {
        return this.read(new InputSource(string));
    }

    public OntologyContent read(URL uRL) throws OntologyException {
        String string = uRL.toExternalForm();
        return this.read(new InputSource(string));
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

