/*
 * Decompiled with CFR 0.152.
 */
package org.exteca.ontology.xml;

import java.io.BufferedOutputStream;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.StringWriter;
import java.io.Writer;
import org.exteca.ontology.Association;
import org.exteca.ontology.Attribute;
import org.exteca.ontology.Concept;
import org.exteca.ontology.Constraint;
import org.exteca.ontology.Link;
import org.exteca.ontology.Ontology;
import org.exteca.ontology.OntologyException;
import org.exteca.ontology.Property;
import org.exteca.ontology.Resource;
import org.exteca.ontology.Rule;

public class XMLOntologyWriter
implements Cloneable {
    private String encoding = "UTF-8";
    int indent = 0;
    private boolean omitDeclaration = false;
    private boolean omitEncoding = false;
    Format format = new Format();

    public XMLOntologyWriter() {
    }

    public XMLOntologyWriter(String string) {
        this.setIndent(string);
    }

    public XMLOntologyWriter(boolean bl) {
        this.setNewlines(bl);
    }

    public XMLOntologyWriter(String string, boolean bl) {
        this.setIndent(string);
        this.setNewlines(bl);
    }

    public XMLOntologyWriter(String string, boolean bl, String string2) {
        this.setEncoding(string2);
        this.setIndent(string);
        this.setNewlines(bl);
    }

    public XMLOntologyWriter(XMLOntologyWriter xMLOntologyWriter) {
        this.encoding = xMLOntologyWriter.encoding;
        this.omitDeclaration = xMLOntologyWriter.omitDeclaration;
        this.omitEncoding = xMLOntologyWriter.omitEncoding;
        this.format = (Format)xMLOntologyWriter.format.clone();
    }

    public void setLineSeparator(String string) {
        this.format.lineSeparator = string;
    }

    public void setNewlines(boolean bl) {
        this.format.newLines = bl;
    }

    public void setEncoding(String string) {
        this.encoding = string;
    }

    public void setOmitEncoding(boolean bl) {
        this.omitEncoding = bl;
    }

    public void setOmitDeclaration(boolean bl) {
        this.omitDeclaration = bl;
    }

    public void setExpandEmptyElements(boolean bl) {
        this.format.expandEmptyElements = bl;
    }

    public void setIndent(String string) {
        if ("".equals(string)) {
            string = null;
        }
        this.format.indent = string;
    }

    public void setIndent(boolean bl) {
        this.format.indent = bl ? "  " : null;
    }

    public void setIndentSize(int n) {
        StringBuffer stringBuffer = new StringBuffer();
        int n2 = 0;
        while (n2 < n) {
            stringBuffer.append(" ");
            ++n2;
        }
        this.format.indent = stringBuffer.toString();
    }

    public void write(Ontology ontology, Writer writer) throws OntologyException {
        try {
            this.writeDeclaration(ontology, writer, this.encoding);
            writer.write("<ontology");
            if (ontology.getId() != null) {
                writer.write(" id=\"");
                writer.write(ontology.getId());
                writer.write("\"");
            }
            if (ontology.getURI() != null) {
                writer.write(" uri=\"");
                writer.write(ontology.getURI());
                writer.write("\"");
            }
            if (ontology.getVersion() != null) {
                writer.write(" version=\"");
                writer.write(ontology.getVersion());
                writer.write("\"");
            }
            writer.write(">");
            this.writeAssociations(ontology, writer);
            this.writeAttributes(ontology, writer);
            this.writeConcepts(ontology, writer);
            --this.indent;
            this.newline(writer);
            writer.write("</ontology>");
            writer.write(this.format.lineSeparator);
            writer.flush();
        }
        catch (IOException iOException) {
            throw new OntologyException(iOException);
        }
    }

    public void write(Ontology ontology, OutputStream outputStream) throws OntologyException {
        try {
            Writer writer = this.getWriter(outputStream);
            this.write(ontology, writer);
        }
        catch (IOException iOException) {
            throw new OntologyException(iOException);
        }
    }

    public void write(Ontology ontology, File file) throws OntologyException {
        try {
            FileOutputStream fileOutputStream = new FileOutputStream(file);
            this.write(ontology, fileOutputStream);
        }
        catch (IOException iOException) {
            throw new OntologyException(iOException);
        }
    }

    public String writeString(Ontology ontology) throws OntologyException {
        StringWriter stringWriter = new StringWriter();
        this.write(ontology, stringWriter);
        return stringWriter.toString();
    }

    protected Writer getWriter(OutputStream outputStream) throws IOException {
        return this.getWriter(outputStream, this.encoding);
    }

    protected Writer getWriter(OutputStream outputStream, String string) throws IOException {
        return new BufferedWriter(new OutputStreamWriter((OutputStream)new BufferedOutputStream(outputStream), string));
    }

    protected void writeDeclaration(Ontology ontology, Writer writer, String string) throws IOException {
        if (!this.omitDeclaration) {
            writer.write("<?xml version=\"1.0\"");
            if (!this.omitEncoding) {
                writer.write(" encoding=\"" + string + "\"");
            }
            writer.write("?>");
            writer.write(this.format.lineSeparator);
        }
    }

    protected void writeAssociations(Ontology ontology, Writer writer) throws IOException, OntologyException {
        Association[] associationArray = Ontology.filterAssociations(ontology.getAssociations(), "namespace", "http://www.exteca.org/EOL", false);
        if (associationArray.length == 0) {
            return;
        }
        ++this.indent;
        this.newline(writer);
        writer.write("<associations>");
        ++this.indent;
        int n = 0;
        while (n < associationArray.length) {
            Association association = associationArray[n];
            this.newline(writer);
            writer.write("<association id=\"");
            writer.write(association.getId());
            writer.write("\" inverse-id=\"");
            writer.write(association.getInverseId());
            writer.write("\">");
            ++this.indent;
            if (association.getComment() != null) {
                this.newline(writer);
                writer.write("<comment>");
                writer.write(association.getComment());
                writer.write("</comment>");
            }
            if (association.getDescription() != null) {
                this.newline(writer);
                writer.write("<description>");
                writer.write(association.getDescription());
                writer.write("</description>");
            }
            if (association.getDomain() != null || association.getRange() != null) {
                this.newline(writer);
                writer.write("<mapping");
                if (association.getDomain() != null) {
                    writer.write(" domain=\"");
                    writer.write(association.getDomain().getId());
                    writer.write("\"");
                }
                if (association.getRange() != null) {
                    writer.write(" range=\"");
                    writer.write(association.getRange().getId());
                    writer.write("\"");
                }
                writer.write("/>");
            }
            if (association.getCardinality() != null || association.getInverseCardinality() != null) {
                this.newline(writer);
                writer.write("<cardinality");
                if (association.getCardinality() != null) {
                    writer.write(" count=\"");
                    writer.write(association.getCardinality());
                    writer.write("\"");
                }
                if (association.getInverseCardinality() != null) {
                    writer.write(" inverse-count=\"");
                    writer.write(association.getInverseCardinality());
                    writer.write("\"");
                }
                writer.write("/>");
            }
            --this.indent;
            this.newline(writer);
            writer.write("</association>");
            ++n;
        }
        --this.indent;
        this.newline(writer);
        writer.write("</associations>");
        --this.indent;
    }

    protected void writeAttributes(Ontology ontology, Writer writer) throws IOException, OntologyException {
        Attribute[] attributeArray = Ontology.filterAttributes(ontology.getAttributes(), "namespace", "http://www.exteca.org/EOL", false);
        if (attributeArray.length == 0) {
            return;
        }
        ++this.indent;
        this.newline(writer);
        writer.write("<attributes>");
        ++this.indent;
        int n = 0;
        while (n < attributeArray.length) {
            Attribute attribute = attributeArray[n];
            this.newline(writer);
            writer.write("<attribute id=\"");
            writer.write(attribute.getId());
            writer.write("\" data-type=\"");
            writer.write(attribute.getDataType());
            writer.write("\">");
            ++this.indent;
            if (attribute.getComment() != null) {
                this.newline(writer);
                writer.write("<comment>");
                writer.write(attribute.getComment());
                writer.write("</comment>");
            }
            if (attribute.getDescription() != null) {
                this.newline(writer);
                writer.write("<description>");
                writer.write(attribute.getDescription());
                writer.write("</description>");
            }
            if (attribute.getDomain() != null || attribute.getRange() != null) {
                this.newline(writer);
                writer.write("<mapping");
                if (attribute.getDomain() != null) {
                    writer.write(" domain=\"");
                    writer.write(attribute.getDomain().getId());
                    writer.write("\"");
                }
                if (attribute.getRange() != null) {
                    writer.write(" range=\"");
                    writer.write(attribute.getRange().getId());
                    writer.write("\"");
                }
                writer.write("/>");
            }
            --this.indent;
            this.newline(writer);
            writer.write("</attribute>");
            ++n;
        }
        --this.indent;
        this.newline(writer);
        writer.write("</attributes>");
        --this.indent;
    }

    protected void writeConcepts(Ontology ontology, Writer writer) throws IOException, OntologyException {
        Concept[] conceptArray = Ontology.filterConcepts(ontology.getConcepts(), "namespace", "http://www.exteca.org/EOL", false);
        if (conceptArray.length == 0) {
            return;
        }
        ++this.indent;
        this.newline(writer);
        writer.write("<concepts>");
        ++this.indent;
        int n = 0;
        while (n < conceptArray.length) {
            Concept concept = conceptArray[n];
            this.newline(writer);
            writer.write("<concept id=\"");
            writer.write(concept.getId());
            writer.write("\"");
            if (concept.getName() != null) {
                writer.write(" name=\"");
                writer.write(concept.getName());
                writer.write("\"");
            }
            if (concept.hasConstraints() || concept.hasLinks() || concept.hasProperties() || concept.hasResources() || concept.hasRules()) {
                writer.write(">");
                this.writeConstraints(concept, writer);
                this.writeLinks(concept, writer);
                this.writeProperties(concept, writer);
                this.writeResources(concept, writer);
                this.writeRules(concept, writer);
                this.newline(writer);
                writer.write("</concept>");
            } else {
                writer.write("/>");
            }
            ++n;
        }
        --this.indent;
        this.newline(writer);
        writer.write("</concepts>");
        --this.indent;
    }

    protected void writeConstraints(Concept concept, Writer writer) throws IOException, OntologyException {
        Constraint[] constraintArray = concept.getConstraints();
        if (constraintArray.length == 0) {
            return;
        }
        ++this.indent;
        int n = 0;
        while (n < constraintArray.length) {
            Constraint constraint = constraintArray[n];
            this.newline(writer);
            if (constraint.getConstraintType() == 0) {
                writer.write("<exists-link");
            } else if (constraint.getConstraintType() == 1) {
                writer.write("<forall-links");
            } else {
                throw new OntologyException("Invalid Constraint " + constraint);
            }
            Link link = constraint.getLink();
            if (link.getAssociation() != null) {
                writer.write(" association=\"");
                writer.write(link.getAssociation().getId());
                writer.write("\"");
            }
            Concept concept2 = null;
            if (concept.equals(link.getSource())) {
                concept2 = link.getSink();
            } else if (concept.equals(link.getSink())) {
                concept2 = link.getSource();
            }
            if (concept2 != null) {
                writer.write(" concept=\"");
                writer.write(concept2.getId());
                writer.write("\"");
            }
            writer.write("/>");
            ++n;
        }
        --this.indent;
    }

    protected void writeLinks(Concept concept, Writer writer) throws IOException, OntologyException {
        Link[] linkArray = concept.getLinks();
        if (linkArray.length == 0) {
            return;
        }
        ++this.indent;
        int n = 0;
        while (n < linkArray.length) {
            Link link = linkArray[n];
            if (link.getAssociation() == null) {
                throw new OntologyException("Invalid Link " + link);
            }
            this.newline(writer);
            if ("http://www.exteca.org/EOL".equals(link.getAssociation().getTag("namespace"))) {
                if ("id".equals(link.getTag("associationId"))) {
                    writer.write("<" + link.getAssociation().getId());
                } else if ("inverseId".equals(link.getTag("associationId"))) {
                    writer.write("<" + link.getAssociation().getInverseId());
                }
            } else {
                writer.write("<link association=\"");
                if ("id".equals(link.getTag("associationId"))) {
                    writer.write(link.getAssociation().getId());
                } else if ("inverseId".equals(link.getTag("associationId"))) {
                    writer.write(link.getAssociation().getInverseId());
                }
                writer.write("\"");
            }
            Concept concept2 = null;
            if (concept.equals(link.getSource())) {
                concept2 = link.getSink();
            } else if (concept.equals(link.getSink())) {
                concept2 = link.getSource();
            }
            if (concept2 != null) {
                writer.write(" concept=\"");
                writer.write(concept2.getId());
                writer.write("\"");
            }
            writer.write("/>");
            ++n;
        }
        --this.indent;
    }

    protected void writeProperties(Concept concept, Writer writer) throws IOException, OntologyException {
        Property[] propertyArray = concept.getProperties();
        if (propertyArray.length == 0) {
            return;
        }
        ++this.indent;
        int n = 0;
        while (n < propertyArray.length) {
            Property property = propertyArray[n];
            if (property.getAttribute() == null) {
                throw new OntologyException("Invalid property " + property);
            }
            this.newline(writer);
            writer.write("<property attribute=\"");
            writer.write(property.getAttribute().getId());
            writer.write("\"");
            writer.write(" value=\"");
            writer.write(property.getValue());
            writer.write("\"");
            writer.write("/>");
            ++n;
        }
        --this.indent;
    }

    protected void writeResources(Concept concept, Writer writer) throws IOException, OntologyException {
        Resource[] resourceArray = concept.getResources();
        if (resourceArray.length == 0) {
            return;
        }
        ++this.indent;
        this.newline(writer);
        writer.write("<resources content=\"");
        writer.write(concept.getId());
        writer.write("\">");
        ++this.indent;
        int n = 0;
        while (n < resourceArray.length) {
            Resource resource = resourceArray[n];
            this.newline(writer);
            writer.write("<resouce uri=\"");
            writer.write(resource.getURI());
            writer.write("\"");
            if (resource.getName() != null) {
                writer.write(" name=\"");
                writer.write(resource.getName());
                writer.write("\"");
            }
            writer.write("/>");
            ++n;
        }
        --this.indent;
        this.newline(writer);
        writer.write("</resources>");
        --this.indent;
    }

    protected void writeRules(Concept concept, Writer writer) throws IOException, OntologyException {
        Rule[] ruleArray = concept.getRules();
        if (ruleArray.length == 0) {
            return;
        }
        ++this.indent;
        this.newline(writer);
        writer.write("<rules content=\"");
        writer.write(concept.getId());
        writer.write("\">");
        ++this.indent;
        int n = 0;
        while (n < ruleArray.length) {
            Rule rule = ruleArray[n];
            this.newline(writer);
            writer.write("<rule logic=\"");
            writer.write(rule.getLogic());
            writer.write("\"");
            if (rule.getName() != null) {
                writer.write(" name=\"");
                writer.write(rule.getName());
                writer.write("\"");
            }
            writer.write("/>");
            ++n;
        }
        --this.indent;
        this.newline(writer);
        writer.write("</rules>");
        --this.indent;
    }

    protected void newline(Writer writer) throws IOException {
        if (this.format.newLines) {
            writer.write(this.format.lineSeparator);
        }
        this.indent(writer, this.indent);
    }

    protected void indent(Writer writer, int n) throws IOException {
        if (this.format.newLines) {
            if (this.format.indent == null || this.format.indent.equals("")) {
                return;
            }
            int n2 = 0;
            while (n2 < n) {
                writer.write(this.format.indent);
                ++n2;
            }
        }
    }

    public Object clone() {
        try {
            return super.clone();
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            throw new RuntimeException(cloneNotSupportedException.toString());
        }
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        int n = 0;
        while (n < this.format.lineSeparator.length()) {
            char c = this.format.lineSeparator.charAt(n);
            switch (c) {
                case '\r': {
                    stringBuffer.append("\\r");
                    break;
                }
                case '\n': {
                    stringBuffer.append("\\n");
                    break;
                }
                case '\t': {
                    stringBuffer.append("\\t");
                    break;
                }
                default: {
                    stringBuffer.append("[" + c + "]");
                }
            }
            ++n;
        }
        return "XMLOntologyWriter[omitDeclaration = " + this.omitDeclaration + ", " + "encoding = " + this.encoding + ", " + "omitEncoding = " + this.omitEncoding + ", " + "indent = '" + this.format.indent + "'" + ", " + "expandEmptyElements = " + this.format.expandEmptyElements + ", " + "newLines = " + this.format.newLines + ", " + "lineSeparator = '" + stringBuffer.toString() + "]";
    }

    class Format
    implements Cloneable {
        static final String STANDARD_INDENT = "  ";
        static final String STANDARD_LINE_SEPARATOR = "\r\n";
        String indent = null;
        boolean expandEmptyElements = false;
        String lineSeparator = "\r\n";
        boolean newLines = false;

        Format() {
        }

        protected Object clone() {
            Format format = null;
            try {
                format = (Format)super.clone();
            }
            catch (CloneNotSupportedException cloneNotSupportedException) {
                // empty catch block
            }
            return format;
        }
    }
}

