/*
 * Decompiled with CFR 0.152.
 */
package org.exteca.utils;

import com.devdaily.opensource.database.DDConnectionBroker;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.SQLException;

public class ConnectionPool {
    private String driverName;
    private String dbURL;
    private String dbUser;
    private String dbPassword;
    private DDConnectionBroker broker;

    public ConnectionPool(String string, String string2) throws Exception {
        this.driverName = string;
        this.dbURL = string2;
        if (string == null || string2 == null) {
            throw new Exception("ConnectionPool driverName and dbURL cannot be null");
        }
        Class.forName(string).newInstance();
    }

    public ConnectionPool(String string, String string2, String string3, String string4) throws Exception {
        this(string, string2);
        this.dbUser = string3;
        this.dbPassword = string4;
        if (string3 != null && string4 != null) {
            this.createBroker();
        }
    }

    public Connection getConnection() throws Exception {
        if (this.broker != null) {
            return this.broker.getConnection();
        }
        return DriverManager.getConnection(this.dbURL);
    }

    public void releaseConnection(Connection connection) throws Exception {
        if (this.broker != null) {
            this.broker.freeConnection(connection);
        } else {
            connection.close();
        }
    }

    private DDConnectionBroker createBroker() throws Exception {
        int n = 1;
        int n2 = 50;
        long l = 100L;
        long l2 = 60000L;
        String string = "DDConnectionBroker.log";
        try {
            this.broker = new DDConnectionBroker(this.driverName, this.dbURL, this.dbUser, this.dbPassword, n, n2, l, l2, string);
        }
        catch (SQLException sQLException) {
            throw new Exception("Failed creating DDConnectionBroker\n" + sQLException.getMessage());
        }
        return this.broker;
    }

    public static void main(String[] stringArray) {
        ConnectionPool connectionPool = null;
        try {
            System.out.println("ConnectionPool: ");
            if (stringArray.length == 2) {
                System.out.println("DriverName: " + stringArray[0] + "\nDbURL: " + stringArray[1]);
                connectionPool = new ConnectionPool(stringArray[0], stringArray[1]);
            } else if (stringArray.length == 4) {
                System.out.println("DriverName: " + stringArray[0] + ",\nDbURL: " + stringArray[1] + ",\nDbUser: " + stringArray[2] + ",\nDbPassword: " + stringArray[3]);
                connectionPool = new ConnectionPool(stringArray[0], stringArray[1], stringArray[2], stringArray[3]);
            } else {
                System.out.println("ConnectionPool usage: driverName, dbURL [, dbUser, dbPassword]");
                return;
            }
            Connection connection = connectionPool.getConnection();
            System.out.println("Connection established");
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }
}

