/*
 * Decompiled with CFR 0.152.
 */
package org.exteca.utils;

import java.text.MessageFormat;
import java.util.Locale;
import java.util.MissingResourceException;
import java.util.ResourceBundle;

public class Resources {
    public static final ResourceBundle getBundle(String string) throws MissingResourceException {
        return Resources.getBundle(string, Locale.getDefault(), Resources.getLoader());
    }

    public static ResourceBundle getBundle(Class clazz) throws MissingResourceException {
        String string = Resources.findBundleName(clazz);
        return Resources.getBundle(string, Locale.getDefault(), clazz.getClassLoader());
    }

    public static final ResourceBundle getBundle(String string, Locale locale) throws MissingResourceException {
        return Resources.getBundle(string, locale, Resources.getLoader());
    }

    public static final ResourceBundle getBundle(String string, Locale locale, ClassLoader classLoader) throws MissingResourceException {
        return ResourceBundle.getBundle(string, locale, classLoader);
    }

    public static String findBundleName(Class clazz) {
        String string = Resources.findPackageName(clazz);
        if (!"".equals(string)) {
            return string + "Bundle";
        }
        return "Bundle";
    }

    public static String findPackageName(Class clazz) {
        String string = clazz.getName();
        int n = string.lastIndexOf(46);
        if (n >= 0) {
            string = string.substring(0, n + 1);
            return string;
        }
        return "";
    }

    private static ClassLoader getLoader() {
        return ClassLoader.getSystemClassLoader();
    }

    public static String getString(Class clazz, String string) {
        return Resources.getBundle(clazz).getString(string);
    }

    public static String getFormatString(Class clazz, String string, Object object) {
        return Resources.getFormatString(clazz, string, new Object[]{object});
    }

    public static String getFormatString(Class clazz, String string, Object object, Object object2) {
        return Resources.getFormatString(clazz, string, new Object[]{object, object2});
    }

    public static String getFormatString(Class clazz, String string, Object object, Object object2, Object object3) {
        return Resources.getFormatString(clazz, string, new Object[]{object, object2, object3});
    }

    public static String getFormatString(Class clazz, String string, Object[] objectArray) {
        return MessageFormat.format(Resources.getString(clazz, string), objectArray);
    }
}

