/*
 * Decompiled with CFR 0.152.
 */
package org.exteca.utils;

import java.io.StringReader;
import java.util.Iterator;
import java.util.List;
import org.exteca.utils.ElementNode;
import org.exteca.utils.TokenItem;
import org.exteca.utils.XMLParser;

public class TokenHighlighter {
    private static final String CDATA_START = "<![CDATA[";
    private static final String CDATA_END = "]]>";

    public String highlight(String string, String string2, List list, String string3, String string4) {
        if (string == null || string.length() == 0) {
            return null;
        }
        if (list.isEmpty()) {
            return null;
        }
        List list2 = this.extractSectionsFromDocument(string, string2);
        if (list2 == null || list2.isEmpty()) {
            return null;
        }
        this.highlightSections(list2, list, string3, string4);
        String string5 = this.getDocumentFromSectionList(string2, list2);
        return string5;
    }

    private void highlightSections(List list, List list2, String string, String string2) {
        Object object;
        Iterator iterator = list2.iterator();
        StringBuffer stringBuffer = new StringBuffer();
        int n = 0;
        ElementNode elementNode = null;
        ElementNode elementNode2 = null;
        while (iterator.hasNext()) {
            object = (TokenItem)iterator.next();
            if (object == null) continue;
            Iterator iterator2 = list.iterator();
            while (iterator2.hasNext()) {
                elementNode = (ElementNode)iterator2.next();
                if (elementNode == null) continue;
                if (elementNode.getEndPosition() > ((TokenItem)object).getStart() && elementNode.getEndPosition() >= ((TokenItem)object).getEnd()) break;
                if (iterator2.hasNext()) continue;
                elementNode = null;
                break;
            }
            if (elementNode2 != null && !elementNode2.equals(elementNode) && n <= elementNode2.getContent().length()) {
                String string3 = elementNode2.getContent().substring(n, elementNode2.getContent().length());
                stringBuffer.append(string3);
                elementNode2.setTaggedContent(stringBuffer.toString());
                n = 0;
                stringBuffer = new StringBuffer();
            }
            elementNode2 = elementNode;
            if (elementNode == null) continue;
            n = this.highlightToken(elementNode, string, string2, stringBuffer, ((TokenItem)object).getStart(), ((TokenItem)object).getEnd(), n);
        }
        if (elementNode != null && n <= elementNode.getContent().length()) {
            object = elementNode.getContent().substring(n, elementNode.getContent().length());
            stringBuffer.append((String)object);
            elementNode.setTaggedContent(stringBuffer.toString());
        }
    }

    private int highlightToken(ElementNode elementNode, String string, String string2, StringBuffer stringBuffer, int n, int n2, int n3) {
        if (elementNode == null) {
            return n3;
        }
        String string3 = elementNode.getContent();
        int n4 = n - elementNode.getStartPosition();
        int n5 = n2 - elementNode.getStartPosition() + 1;
        if (n3 > n4) {
            return n3;
        }
        if (n4 < 0) {
            n4 = 0;
        }
        String string4 = "";
        if (n3 != n4) {
            string4 = string3.substring(n3, n4);
            stringBuffer.append(string4);
        }
        if (n5 > string3.length()) {
            n5 = string3.length();
        }
        stringBuffer.append(string);
        stringBuffer.append(string3.substring(n4, n5));
        stringBuffer.append(string2);
        return n5;
    }

    private String getDocumentFromSectionList(String string, List list) {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("<" + string + ">");
        Iterator iterator = list.iterator();
        ElementNode elementNode = null;
        while (iterator.hasNext()) {
            elementNode = (ElementNode)iterator.next();
            if (elementNode == null) continue;
            stringBuffer.append("<" + elementNode.getName() + ">");
            stringBuffer.append(CDATA_START);
            stringBuffer.append(elementNode.getTaggedContent());
            stringBuffer.append(CDATA_END);
            stringBuffer.append("</" + elementNode.getName() + ">");
        }
        stringBuffer.append("</" + string + ">");
        return stringBuffer.toString();
    }

    private List extractSectionsFromDocument(String string, String string2) {
        StringReader stringReader = new StringReader(string);
        XMLParser xMLParser = new XMLParser(string2);
        List list = xMLParser.parse(stringReader);
        return list;
    }
}

