/*
 * Decompiled with CFR 0.152.
 */
package org.exteca.utils;

import java.io.Reader;
import java.util.List;
import java.util.Stack;
import org.exteca.utils.ElementNode;
import org.xml.sax.Attributes;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;
import org.xml.sax.XMLReader;
import org.xml.sax.helpers.DefaultHandler;

public class XMLParser {
    private String documentRootElement;

    public XMLParser(String string) {
        this.documentRootElement = string;
    }

    public void initialise() {
    }

    public List parse(Reader reader) {
        try {
            XmlParser xmlParser = new XmlParser(this.documentRootElement);
            XMLReader xMLReader = (XMLReader)Class.forName("org.apache.xerces.parsers.SAXParser").newInstance();
            xMLReader.setContentHandler(xmlParser);
            xMLReader.setErrorHandler(xmlParser);
            xMLReader.parse(new InputSource(reader));
            List list = xmlParser.getSectionList();
            return list;
        }
        catch (SAXParseException sAXParseException) {
            sAXParseException.printStackTrace(System.err);
        }
        catch (SAXException sAXException) {
            if (sAXException.getException() != null) {
                sAXException.getException().printStackTrace(System.err);
            } else {
                sAXException.printStackTrace(System.err);
            }
        }
        catch (Exception exception) {
            exception.printStackTrace(System.err);
        }
        return null;
    }

    class XmlParser
    extends DefaultHandler {
        Stack elementNodeStack;
        StringBuffer elementContent;
        int elementStartPosition;
        String documentRootElement;

        XmlParser(String string) {
            this.documentRootElement = string;
        }

        public List getSectionList() {
            return this.elementNodeStack;
        }

        public void startDocument() {
            this.elementStartPosition = 0;
            this.elementContent = new StringBuffer();
            this.elementNodeStack = new Stack();
        }

        public void endDocument() {
        }

        public void startElement(String string, String string2, String string3, Attributes attributes) {
            this.elementStartPosition += this.elementContent.length();
            this.elementContent = new StringBuffer();
        }

        public void endElement(String string, String string2, String string3) {
            if (string2.equals(this.documentRootElement)) {
                return;
            }
            ElementNode elementNode = new ElementNode(string2, new String(this.elementContent.toString()));
            elementNode.setStartPosition(this.elementStartPosition);
            elementNode.setEndPosition(this.elementStartPosition + this.elementContent.length() - 1);
            this.elementNodeStack.push(elementNode);
        }

        public void characters(char[] cArray, int n, int n2) {
            this.elementContent.append(cArray, n, n2);
        }

        public void ignorableWhitespace(char[] cArray, int n, int n2) {
        }

        public void warning(SAXParseException sAXParseException) {
            System.err.println("[Warning] " + this.getLocationString(sAXParseException) + ": " + sAXParseException.getMessage());
        }

        public void error(SAXParseException sAXParseException) {
            System.err.println("[Error] " + this.getLocationString(sAXParseException) + ": " + sAXParseException.getMessage());
            this.elementNodeStack.removeAllElements();
        }

        public void fatalError(SAXParseException sAXParseException) throws SAXException {
            System.err.println("[Fatal Error] " + this.getLocationString(sAXParseException) + ": " + sAXParseException.getMessage());
            this.elementNodeStack.removeAllElements();
        }

        private String getLocationString(SAXParseException sAXParseException) {
            StringBuffer stringBuffer = new StringBuffer();
            String string = sAXParseException.getSystemId();
            if (string != null) {
                int n = string.lastIndexOf(47);
                if (n != -1) {
                    string = string.substring(n + 1);
                }
                stringBuffer.append(string);
            }
            stringBuffer.append(':');
            stringBuffer.append(sAXParseException.getLineNumber());
            stringBuffer.append(':');
            stringBuffer.append(sAXParseException.getColumnNumber());
            return stringBuffer.toString();
        }
    }
}

