/*
 * Decompiled with CFR 0.152.
 */
package org.exteca.utils;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.io.StringWriter;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.stream.StreamResult;
import javax.xml.transform.stream.StreamSource;

public class XSLTransformer {
    private Transformer transformer = null;
    private StreamSource source;
    private StreamResult result;

    public XSLTransformer() {
    }

    public XSLTransformer(InputStream inputStream, String string) throws Exception {
        this.loadTransformer(string);
        this.source = new StreamSource(inputStream);
    }

    public XSLTransformer(String string, String string2) throws Exception {
        this.loadTransformer(string2);
        this.source = new StreamSource(string);
    }

    public String transform() {
        try {
            StringWriter stringWriter = new StringWriter();
            this.result = new StreamResult(stringWriter);
            this.transformer.transform(this.source, this.result);
            return stringWriter.getBuffer().toString();
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return "XSLTransformer:" + exception;
        }
    }

    public String transform(String string, String string2) {
        try {
            this.loadTransformer(string2);
            this.source = new StreamSource(new ByteArrayInputStream(string.getBytes()));
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return "XSLTransformer:" + exception;
        }
        return this.transform();
    }

    private void loadTransformer(String string) throws Exception {
        if (this.transformer != null) {
            return;
        }
        TransformerFactory transformerFactory = TransformerFactory.newInstance();
        this.transformer = string != null ? transformerFactory.newTransformer(new StreamSource(string)) : transformerFactory.newTransformer();
    }
}

