/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.maven.plugins.jgitflow;

import com.atlassian.maven.plugins.jgitflow.AbstractJGitFlowMojo;
import com.atlassian.maven.plugins.jgitflow.ReleaseContext;
import com.atlassian.maven.plugins.jgitflow.exception.JGitFlowReleaseException;
import com.atlassian.maven.plugins.jgitflow.manager.FlowReleaseManager;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugins.annotations.Component;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;

@Mojo(name="hotfix-start", aggregator=true)
public class HotfixStartMojo
extends AbstractJGitFlowMojo {
    @Parameter(defaultValue="false", property="autoVersionSubmodules")
    private boolean autoVersionSubmodules = false;
    @Parameter(defaultValue="false", property="allowSnapshots")
    private boolean allowSnapshots = false;
    @Parameter(property="releaseVersion", defaultValue="")
    private String releaseVersion = "";
    @Parameter(defaultValue="true", property="updateDependencies")
    private boolean updateDependencies = true;
    @Parameter(defaultValue="false", property="pushHotfixes")
    private boolean pushHotfixes = false;
    @Parameter(property="startCommit", defaultValue="")
    private String startCommit = "";
    @Component(hint="hotfix")
    FlowReleaseManager releaseManager;

    public void execute() throws MojoExecutionException, MojoFailureException {
        ReleaseContext ctx = new ReleaseContext(this.getBasedir());
        ctx.setAutoVersionSubmodules(this.autoVersionSubmodules).setInteractive(this.getSettings().isInteractiveMode()).setDefaultReleaseVersion(this.releaseVersion).setAllowSnapshots(this.allowSnapshots).setUpdateDependencies(this.updateDependencies).setEnableSshAgent(this.enableSshAgent).setAllowUntracked(this.allowUntracked).setPushHotfixes(this.pushHotfixes).setStartCommit(this.startCommit).setAllowRemote(this.isRemoteAllowed()).setAlwaysUpdateOrigin(this.alwaysUpdateOrigin).setDefaultOriginUrl(this.defaultOriginUrl).setScmCommentPrefix(this.scmCommentPrefix).setScmCommentSuffix(this.scmCommentSuffix).setUsername(this.username).setPassword(this.password).setFlowInitContext(this.getFlowInitContext().getJGitFlowContext());
        try {
            this.releaseManager.start(ctx, this.getReactorProjects(), this.session);
        }
        catch (JGitFlowReleaseException e) {
            throw new MojoExecutionException("Error starting hotfix: " + e.getMessage(), (Exception)e);
        }
    }
}

