/*
 * Decompiled with CFR 0.152.
 */
package fi.iki.yak.ts.compression.gorilla;

import fi.iki.yak.ts.compression.gorilla.BitInput;
import fi.iki.yak.ts.compression.gorilla.Pair;
import fi.iki.yak.ts.compression.gorilla.Predictor;
import fi.iki.yak.ts.compression.gorilla.ValueDecompressor;
import fi.iki.yak.ts.compression.gorilla.predictors.LastValuePredictor;

public class GorillaDecompressor {
    private long storedTimestamp = 0L;
    private long storedDelta = 0L;
    private long blockTimestamp = 0L;
    private long storedVal = 0L;
    private boolean endOfStream = false;
    private final BitInput in;
    private final ValueDecompressor decompressor;

    public GorillaDecompressor(BitInput input) {
        this(input, new LastValuePredictor());
    }

    public GorillaDecompressor(BitInput input, Predictor predictor) {
        this.in = input;
        this.readHeader();
        this.decompressor = new ValueDecompressor(input, predictor);
    }

    private void readHeader() {
        this.blockTimestamp = this.in.getLong(64);
    }

    public Pair readPair() {
        this.next();
        if (this.endOfStream) {
            return null;
        }
        Pair pair = new Pair(this.storedTimestamp, this.storedVal);
        return pair;
    }

    private void next() {
        if (this.storedTimestamp == 0L) {
            this.first();
            return;
        }
        this.nextTimestamp();
    }

    private void first() {
        this.storedDelta = this.in.getLong(27);
        if (this.storedDelta == 0x7FFFFFFL) {
            this.endOfStream = true;
            return;
        }
        this.storedVal = this.decompressor.readFirst();
        this.storedTimestamp = this.blockTimestamp + this.storedDelta;
    }

    private void nextTimestamp() {
        long deltaDelta;
        int readInstruction = this.in.nextClearBit(4);
        switch (readInstruction) {
            case 0: {
                this.storedTimestamp = this.storedDelta + this.storedTimestamp;
                this.storedVal = this.decompressor.nextValue();
                return;
            }
            case 2: {
                deltaDelta = this.in.getLong(7);
                break;
            }
            case 6: {
                deltaDelta = this.in.getLong(9);
                break;
            }
            case 14: {
                deltaDelta = this.in.getLong(12);
                break;
            }
            case 15: {
                deltaDelta = this.in.getLong(32);
                if ((int)deltaDelta != -1) break;
                this.endOfStream = true;
                return;
            }
            default: {
                return;
            }
        }
        ++deltaDelta;
        deltaDelta = GorillaDecompressor.decodeZigZag32((int)deltaDelta);
        this.storedDelta += deltaDelta;
        this.storedTimestamp = this.storedDelta + this.storedTimestamp;
        this.storedVal = this.decompressor.nextValue();
    }

    public static int decodeZigZag32(int n) {
        return n >>> 1 ^ -(n & 1);
    }
}

