/*
 * Decompiled with CFR 0.152.
 */
package fi.iki.yak.ts.compression.gorilla;

import fi.iki.yak.ts.compression.gorilla.BitInput;
import fi.iki.yak.ts.compression.gorilla.LongArrayOutput;

public class LongArrayInput
implements BitInput {
    private final long[] longArray;
    private long lB;
    private int position = 0;
    private int bitsLeft = 0;

    public LongArrayInput(long[] array) {
        this.longArray = array;
        this.flipByte();
    }

    @Override
    public boolean readBit() {
        boolean bit = (this.lB & LongArrayOutput.BIT_SET_MASK[this.bitsLeft - 1]) != 0L;
        --this.bitsLeft;
        this.checkAndFlipByte();
        return bit;
    }

    private void flipByte() {
        this.lB = this.longArray[this.position++];
        this.bitsLeft = 64;
    }

    private void checkAndFlipByte() {
        if (this.bitsLeft == 0) {
            this.flipByte();
        }
    }

    @Override
    public long getLong(int bits) {
        long value;
        if (bits <= this.bitsLeft) {
            value = this.lB >>> this.bitsLeft - bits & LongArrayOutput.MASK_ARRAY[bits - 1];
            this.bitsLeft -= bits;
            this.checkAndFlipByte();
        } else {
            value = this.lB & LongArrayOutput.MASK_ARRAY[this.bitsLeft - 1];
            this.flipByte();
            value <<= (bits -= this.bitsLeft);
            value |= this.lB >>> this.bitsLeft - bits;
            this.bitsLeft -= bits;
        }
        return value;
    }

    @Override
    public int nextClearBit(int maxBits) {
        int val = 0;
        for (int i = 0; i < maxBits; ++i) {
            val <<= 1;
            boolean bit = this.readBit();
            if (!bit) break;
            val |= 1;
        }
        return val;
    }
}

