/*
 * Decompiled with CFR 0.152.
 */
package fi.iki.yak.ts.compression.gorilla;

import fi.iki.yak.ts.compression.gorilla.BitOutput;
import fi.iki.yak.ts.compression.gorilla.Predictor;
import fi.iki.yak.ts.compression.gorilla.predictors.LastValuePredictor;

public class ValueCompressor {
    private int storedLeadingZeros = Integer.MAX_VALUE;
    private int storedTrailingZeros = 0;
    private Predictor predictor;
    private BitOutput out;

    public ValueCompressor(BitOutput out) {
        this(out, new LastValuePredictor());
    }

    public ValueCompressor(BitOutput out, Predictor predictor) {
        this.out = out;
        this.predictor = predictor;
    }

    void writeFirst(long value) {
        this.predictor.update(value);
        this.out.writeBits(value, 64);
    }

    protected void compressValue(long value) {
        long diff = this.predictor.predict() ^ value;
        this.predictor.update(value);
        if (diff == 0L) {
            this.out.skipBit();
        } else {
            int leadingZeros = Long.numberOfLeadingZeros(diff);
            int trailingZeros = Long.numberOfTrailingZeros(diff);
            this.out.writeBit();
            if (leadingZeros >= this.storedLeadingZeros && trailingZeros >= this.storedTrailingZeros) {
                this.writeExistingLeading(diff);
            } else {
                this.writeNewLeading(diff, leadingZeros, trailingZeros);
            }
        }
    }

    private void writeExistingLeading(long xor) {
        this.out.skipBit();
        int significantBits = 64 - this.storedLeadingZeros - this.storedTrailingZeros;
        this.out.writeBits(xor >>>= this.storedTrailingZeros, significantBits);
    }

    private void writeNewLeading(long xor, int leadingZeros, int trailingZeros) {
        this.out.writeBit();
        int significantBits = 64 - leadingZeros - trailingZeros;
        this.out.writeBits(leadingZeros, 6);
        this.out.writeBits(significantBits - 1, 6);
        this.out.writeBits(xor >>> trailingZeros, significantBits);
        this.storedLeadingZeros = leadingZeros;
        this.storedTrailingZeros = trailingZeros;
    }
}

