/*
 * Decompiled with CFR 0.152.
 */
package fi.iki.yak.ts.compression.gorilla;

import fi.iki.yak.ts.compression.gorilla.BitInput;
import fi.iki.yak.ts.compression.gorilla.Predictor;
import fi.iki.yak.ts.compression.gorilla.predictors.LastValuePredictor;

public class ValueDecompressor {
    private final BitInput in;
    private final Predictor predictor;
    private int storedLeadingZeros = Integer.MAX_VALUE;
    private int storedTrailingZeros = 0;

    public ValueDecompressor(BitInput input) {
        this(input, new LastValuePredictor());
    }

    public ValueDecompressor(BitInput input, Predictor predictor) {
        this.in = input;
        this.predictor = predictor;
    }

    public long readFirst() {
        long value = this.in.getLong(64);
        this.predictor.update(value);
        return value;
    }

    public long nextValue() {
        int val = this.in.nextClearBit(2);
        switch (val) {
            case 3: {
                this.storedLeadingZeros = (int)this.in.getLong(6);
                byte significantBits = (byte)this.in.getLong(6);
                significantBits = (byte)(significantBits + 1);
                this.storedTrailingZeros = 64 - significantBits - this.storedLeadingZeros;
            }
            case 2: {
                long value = this.in.getLong(64 - this.storedLeadingZeros - this.storedTrailingZeros);
                value <<= this.storedTrailingZeros;
                value = this.predictor.predict() ^ value;
                this.predictor.update(value);
                return value;
            }
        }
        return this.predictor.predict();
    }
}

