/*
 * Decompiled with CFR 0.152.
 */
package fi.iki.yak.ts.compression.gorilla.predictors;

import fi.iki.yak.ts.compression.gorilla.Predictor;

public class DifferentialFCM
implements Predictor {
    private long lastValue = 0L;
    private final long[] table;
    private int lastHash = 0;
    private final int mask;

    public DifferentialFCM(int size) {
        if (size <= 0) {
            throw new IllegalArgumentException("Size must be positive");
        }
        int leadingZeros = Long.numberOfLeadingZeros(--size);
        int newSize = 1 << 64 - leadingZeros;
        this.table = new long[newSize];
        this.mask = newSize - 1;
    }

    @Override
    public void update(long value) {
        this.table[this.lastHash] = value - this.lastValue;
        this.lastHash = (int)(((long)(this.lastHash << 5) ^ value - this.lastValue >> 50) & (long)this.mask);
        this.lastValue = value;
    }

    @Override
    public long predict() {
        return this.table[this.lastHash] + this.lastValue;
    }
}

