/*
 * Decompiled with CFR 0.152.
 */
package fi.ishtech.core.i18n.country;

import fi.ishtech.core.i18n.country.CountryNamesEn;
import fi.ishtech.core.i18n.country.CountryNamesFi;
import fi.ishtech.core.i18n.enums.CountryEnum;
import fi.ishtech.core.i18n.enums.LangEnum;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;

public abstract class CountryNames {
    private static final Map<LangEnum, Map<CountryEnum, String>> MAP_LANG_COUNTRY_FULL_NAMES;

    public static final Map<CountryEnum, String> byLang(LangEnum lang) {
        if (lang == null) {
            return null;
        }
        return MAP_LANG_COUNTRY_FULL_NAMES.get((Object)lang);
    }

    public static final Map<CountryEnum, String> byLangOrElseByEn(LangEnum lang) {
        Map<CountryEnum, String> tmpMapCountryFullName = MAP_LANG_COUNTRY_FULL_NAMES.get((Object)lang);
        return tmpMapCountryFullName != null ? tmpMapCountryFullName : CountryNames.byLang(LangEnum.en);
    }

    public static final Map<CountryEnum, String> byLang(String lang) {
        return CountryNames.byLang(LangEnum.fromNameIgnoreCaseOrElseNull(lang));
    }

    public static final Map<CountryEnum, String> byLangOrElseByEn(String lang) {
        return CountryNames.byLangOrElseByEn(LangEnum.fromNameIgnoreCaseOrElseNull(lang));
    }

    public static final Map<LangEnum, Map<CountryEnum, String>> byLangsSortedByFullName(List<LangEnum> langs) {
        if (langs == null) {
            return null;
        }
        TreeMap result = new TreeMap();
        for (LangEnum lang : langs) {
            if (MAP_LANG_COUNTRY_FULL_NAMES.containsKey((Object)lang)) {
                LinkedHashMap sortedMap = new LinkedHashMap();
                MAP_LANG_COUNTRY_FULL_NAMES.get((Object)lang).entrySet().stream().sorted(Map.Entry.comparingByValue()).forEachOrdered(x -> sortedMap.put((CountryEnum)((Object)((Object)x.getKey())), (String)x.getValue()));
                result.put(lang, sortedMap);
                continue;
            }
            result.put(lang, null);
        }
        return Collections.unmodifiableMap(result);
    }

    static {
        HashMap<LangEnum, Map<CountryEnum, String>> tmpLangMapCountryFullName = new HashMap<LangEnum, Map<CountryEnum, String>>(2);
        tmpLangMapCountryFullName.put(LangEnum.en, CountryNamesEn.fullNames());
        tmpLangMapCountryFullName.put(LangEnum.fi, CountryNamesFi.fullNames());
        MAP_LANG_COUNTRY_FULL_NAMES = Collections.unmodifiableMap(tmpLangMapCountryFullName);
        Object var0 = null;
    }
}

