/*
 * Decompiled with CFR 0.152.
 */
package fi.jubic.easyutils.transactional;

import fi.jubic.easyutils.transactional.TransactionProvider;
import fi.jubic.easyutils.transactional.Transactional10;
import fi.jubic.easyutils.transactional.Transactional2;
import fi.jubic.easyutils.transactional.Transactional3;
import fi.jubic.easyutils.transactional.Transactional4;
import fi.jubic.easyutils.transactional.Transactional5;
import fi.jubic.easyutils.transactional.Transactional6;
import fi.jubic.easyutils.transactional.Transactional7;
import fi.jubic.easyutils.transactional.Transactional8;
import fi.jubic.easyutils.transactional.Transactional9;
import fi.jubic.easyutils.tuple.Tuple;
import java.util.Objects;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Supplier;

public class Transactional<T, C> {
    final Function<C, T> procedure;
    final TransactionProvider<C> provider;

    protected Transactional(Function<C, T> procedure, TransactionProvider<C> provider) {
        this.procedure = procedure;
        this.provider = provider;
    }

    public T get() {
        return this.provider.runWithTransaction(this.procedure);
    }

    public T bypass() {
        return this.provider.runWithoutTransaction(this.procedure);
    }

    public <U> Transactional<U, C> map(Function<T, U> mapper) {
        Objects.requireNonNull(mapper);
        return new Transactional<U, C>(mapper.compose(this.procedure), this.provider);
    }

    public <U> Transactional<U, C> flatMap(Function<T, Transactional<U, C>> mapper) {
        Objects.requireNonNull(mapper);
        return new Transactional<Object, Object>(context -> ((Transactional)mapper.apply(this.procedure.apply(context))).procedure.apply(context), this.provider);
    }

    public Transactional<T, C> peek(Consumer<T> action) {
        Objects.requireNonNull(action);
        return new Transactional<Object, Object>(context -> {
            T value = this.procedure.apply(context);
            action.accept(value);
            return value;
        }, this.provider);
    }

    public Transactional<T, C> peekMap(Function<T, Transactional<Void, C>> procedure) {
        Objects.requireNonNull(procedure);
        return new Transactional<Object, Object>(context -> {
            T value = this.procedure.apply(context);
            ((Transactional)procedure.apply(value)).procedure.apply(context);
            return value;
        }, this.provider);
    }

    public static <T, C> Transactional<T, C> of(Function<C, T> materialize, TransactionProvider<C> provider) {
        return new Transactional<T, C>(materialize, provider);
    }

    public static <T> Transactional<T, Void> of(Supplier<T> materialize, TransactionProvider<Void> provider) {
        return new Transactional<Object, Void>(context -> materialize.get(), provider);
    }

    public static <T1, T2, C> Transactional2<T1, T2, C> all(Transactional<T1, C> t1, Transactional<T2, C> t2) {
        Transactional.validateProviders(t1.provider, t2.provider);
        return new Transactional2(context -> Tuple.of(t1.procedure.apply(context), t2.procedure.apply(context)), (TransactionProvider<Object>)t1.provider);
    }

    public static <T1, T2, T3, C> Transactional3<T1, T2, T3, C> all(Transactional<T1, C> t1, Transactional<T2, C> t2, Transactional<T3, C> t3) {
        Transactional.validateProviders(t1.provider, t2.provider, t3.provider);
        return new Transactional3(context -> Tuple.of(t1.procedure.apply(context), t2.procedure.apply(context), t3.procedure.apply(context)), (TransactionProvider<Object>)t1.provider);
    }

    public static <T1, T2, T3, T4, C> Transactional4<T1, T2, T3, T4, C> all(Transactional<T1, C> t1, Transactional<T2, C> t2, Transactional<T3, C> t3, Transactional<T4, C> t4) {
        Transactional.validateProviders(t1.provider, t2.provider, t3.provider, t4.provider);
        return new Transactional4(context -> Tuple.of(t1.procedure.apply(context), t2.procedure.apply(context), t3.procedure.apply(context), t4.procedure.apply(context)), (TransactionProvider<Object>)t1.provider);
    }

    public static <T1, T2, T3, T4, T5, C> Transactional5<T1, T2, T3, T4, T5, C> all(Transactional<T1, C> t1, Transactional<T2, C> t2, Transactional<T3, C> t3, Transactional<T4, C> t4, Transactional<T5, C> t5) {
        Transactional.validateProviders(t1.provider, t2.provider, t3.provider, t4.provider, t5.provider);
        return new Transactional5(context -> Tuple.of(t1.procedure.apply(context), t2.procedure.apply(context), t3.procedure.apply(context), t4.procedure.apply(context), t5.procedure.apply(context)), (TransactionProvider<Object>)t1.provider);
    }

    public static <T1, T2, T3, T4, T5, T6, C> Transactional6<T1, T2, T3, T4, T5, T6, C> all(Transactional<T1, C> t1, Transactional<T2, C> t2, Transactional<T3, C> t3, Transactional<T4, C> t4, Transactional<T5, C> t5, Transactional<T6, C> t6) {
        Transactional.validateProviders(t1.provider, t2.provider, t3.provider, t4.provider, t5.provider, t6.provider);
        return new Transactional6(context -> Tuple.of(t1.procedure.apply(context), t2.procedure.apply(context), t3.procedure.apply(context), t4.procedure.apply(context), t5.procedure.apply(context), t6.procedure.apply(context)), (TransactionProvider<Object>)t1.provider);
    }

    public static <T1, T2, T3, T4, T5, T6, T7, C> Transactional7<T1, T2, T3, T4, T5, T6, T7, C> all(Transactional<T1, C> t1, Transactional<T2, C> t2, Transactional<T3, C> t3, Transactional<T4, C> t4, Transactional<T5, C> t5, Transactional<T6, C> t6, Transactional<T7, C> t7) {
        Transactional.validateProviders(t1.provider, t2.provider, t3.provider, t4.provider, t5.provider, t6.provider, t7.provider);
        return new Transactional7(context -> Tuple.of(t1.procedure.apply(context), t2.procedure.apply(context), t3.procedure.apply(context), t4.procedure.apply(context), t5.procedure.apply(context), t6.procedure.apply(context), t7.procedure.apply(context)), (TransactionProvider<Object>)t1.provider);
    }

    public static <T1, T2, T3, T4, T5, T6, T7, T8, C> Transactional8<T1, T2, T3, T4, T5, T6, T7, T8, C> all(Transactional<T1, C> t1, Transactional<T2, C> t2, Transactional<T3, C> t3, Transactional<T4, C> t4, Transactional<T5, C> t5, Transactional<T6, C> t6, Transactional<T7, C> t7, Transactional<T8, C> t8) {
        Transactional.validateProviders(t1.provider, t2.provider, t3.provider, t4.provider, t5.provider, t6.provider, t7.provider, t8.provider);
        return new Transactional8(context -> Tuple.of(t1.procedure.apply(context), t2.procedure.apply(context), t3.procedure.apply(context), t4.procedure.apply(context), t5.procedure.apply(context), t6.procedure.apply(context), t7.procedure.apply(context), t8.procedure.apply(context)), (TransactionProvider<Object>)t1.provider);
    }

    public static <T0, T1, T2, T3, T4, T5, T6, T7, T8, C> Transactional9<T0, T1, T2, T3, T4, T5, T6, T7, T8, C> all(Transactional<T0, C> t0, Transactional<T1, C> t1, Transactional<T2, C> t2, Transactional<T3, C> t3, Transactional<T4, C> t4, Transactional<T5, C> t5, Transactional<T6, C> t6, Transactional<T7, C> t7, Transactional<T8, C> t8) {
        Transactional.validateProviders(t0.provider, t1.provider, t2.provider, t3.provider, t4.provider, t5.provider, t6.provider, t7.provider, t8.provider);
        return new Transactional9(context -> Tuple.of(t0.procedure.apply(context), t1.procedure.apply(context), t2.procedure.apply(context), t3.procedure.apply(context), t4.procedure.apply(context), t5.procedure.apply(context), t6.procedure.apply(context), t7.procedure.apply(context), t8.procedure.apply(context)), (TransactionProvider<Object>)t0.provider);
    }

    public static <T0, T1, T2, T3, T4, T5, T6, T7, T8, T9, C> Transactional10<T0, T1, T2, T3, T4, T5, T6, T7, T8, T9, C> all(Transactional<T0, C> t0, Transactional<T1, C> t1, Transactional<T2, C> t2, Transactional<T3, C> t3, Transactional<T4, C> t4, Transactional<T5, C> t5, Transactional<T6, C> t6, Transactional<T7, C> t7, Transactional<T8, C> t8, Transactional<T9, C> t9) {
        Transactional.validateProviders(t0.provider, t1.provider, t2.provider, t3.provider, t4.provider, t5.provider, t6.provider, t7.provider, t8.provider, t9.provider);
        return new Transactional10(context -> Tuple.of(t0.procedure.apply(context), t1.procedure.apply(context), t2.procedure.apply(context), t3.procedure.apply(context), t4.procedure.apply(context), t5.procedure.apply(context), t6.procedure.apply(context), t7.procedure.apply(context), t8.procedure.apply(context), t9.procedure.apply(context)), (TransactionProvider<Object>)t0.provider);
    }

    private static void validateProviders(Object ... providers) {
        if (providers.length == 1) {
            return;
        }
        Object first = providers[0];
        for (Object other : providers) {
            if (Objects.equals(first, other)) continue;
            throw new IllegalArgumentException("Cannot create Transactional chain with multiple TransactionProviders");
        }
    }
}

