/*
 * Decompiled with CFR 0.152.
 */
package fi.jubic.easyvalue.processor;

import com.squareup.javapoet.AnnotationSpec;
import com.squareup.javapoet.ClassName;
import com.squareup.javapoet.MethodSpec;
import com.squareup.javapoet.ParameterSpec;
import com.squareup.javapoet.ParameterizedTypeName;
import com.squareup.javapoet.TypeName;
import com.squareup.javapoet.TypeSpec;
import com.squareup.javapoet.TypeVariableName;
import fi.jubic.easyvalue.EasyValue;
import fi.jubic.easyvalue.processor.PropertyDefinition;
import fi.jubic.easyvalue.processor.PropertyKind;
import fi.jubic.easyvalue.processor.ValueDefinition;
import java.util.Arrays;
import java.util.Collections;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.annotation.Nullable;
import javax.lang.model.element.Modifier;
import javax.lang.model.element.QualifiedNameable;
import javax.lang.model.type.TypeMirror;

class BuilderGenerator {
    BuilderGenerator() {
    }

    void generateBuilder(ValueDefinition value, TypeSpec.Builder classBuilder) {
        TypeSpec.Builder builderBuilder = TypeSpec.classBuilder((String)"Builder").addModifiers(new Modifier[]{Modifier.STATIC}).addTypeVariables(value.getTypeVariables());
        Set<Modifier> subClassModifiers = value.getBuilderElement().getModifiers();
        if (subClassModifiers.contains((Object)Modifier.PUBLIC)) {
            builderBuilder.addModifiers(new Modifier[]{Modifier.PUBLIC});
        } else if (subClassModifiers.contains((Object)Modifier.PRIVATE)) {
            builderBuilder.addModifiers(new Modifier[]{Modifier.PRIVATE});
        }
        value.getBuilderElement().getAnnotationMirrors().stream().filter(annotationMirror -> !EasyValue.class.getName().equals(((QualifiedNameable)annotationMirror.getAnnotationType().asElement()).getQualifiedName().toString())).map(AnnotationSpec::get).forEach(arg_0 -> ((TypeSpec.Builder)builderBuilder).addAnnotation(arg_0));
        value.getProperties().forEach(property -> this.generateField((PropertyDefinition)property, builderBuilder));
        this.generateConstructors(value, builderBuilder);
        this.generateDefaultGenerator(value, builderBuilder);
        this.generateFromSource(value, builderBuilder);
        value.getProperties().forEach(property -> this.generateSetter((PropertyDefinition)property, value, builderBuilder));
        value.getProperties().forEach(property -> this.generateAccessor((PropertyDefinition)property, builderBuilder));
        this.generateBuild(value, builderBuilder);
        classBuilder.addType(builderBuilder.build());
    }

    private void generateField(PropertyDefinition property, TypeSpec.Builder builderBuilder) {
        if (property.isOptional()) {
            builderBuilder.addField(TypeName.get((TypeMirror)property.getTypeArgument().orElseThrow(IllegalStateException::new)), property.getName(), new Modifier[]{Modifier.PRIVATE});
        } else {
            builderBuilder.addField(property.getType().getKind().isPrimitive() ? TypeName.get((TypeMirror)property.getType()).box() : TypeName.get((TypeMirror)property.getType()), property.getName(), new Modifier[]{Modifier.PRIVATE});
        }
    }

    private void generateConstructors(ValueDefinition value, TypeSpec.Builder builderBuilder) {
        MethodSpec.Builder constructorBuilder = MethodSpec.constructorBuilder().addModifiers(new Modifier[]{Modifier.PRIVATE});
        value.getProperties().forEach(property -> {
            if (property.isOptional()) {
                constructorBuilder.addParameter(TypeName.get((TypeMirror)property.getTypeArgument().orElseThrow(IllegalStateException::new)), property.getName(), new Modifier[0]);
            } else {
                constructorBuilder.addParameter(TypeName.get((TypeMirror)property.getType()), property.getName(), new Modifier[0]);
            }
        });
        value.getProperties().forEach(property -> {
            switch (property.getPropertyKind()) {
                case PLAIN: 
                case OPTIONAL: {
                    constructorBuilder.addStatement("this.$L = $L", new Object[]{property.getName(), property.getName()});
                    break;
                }
                case ARRAY: 
                case OPTIONAL_ARRAY: {
                    constructorBuilder.beginControlFlow("if ($L != null)", new Object[]{property.getName()}).addStatement("this.$L = $T.copyOf($L, $L.length)", new Object[]{property.getName(), ClassName.get(Arrays.class), property.getName(), property.getName()}).nextControlFlow("else", new Object[0]).addStatement("this.$L = null", new Object[]{property.getName()}).endControlFlow();
                    break;
                }
                case LIST: {
                    constructorBuilder.addStatement("this.$L = $T.ofNullable($L).map($T::unmodifiableList).orElse(null)", new Object[]{property.getName(), Optional.class, property.getName(), Collections.class});
                    break;
                }
                case SET: {
                    constructorBuilder.addStatement("this.$L = $T.ofNullable($L).map($T::unmodifiableSet).orElse(null)", new Object[]{property.getName(), Optional.class, property.getName(), Collections.class});
                    break;
                }
                case MAP: {
                    constructorBuilder.addStatement("this.$L = $T.ofNullable($L).map($T::unmodifiableMap).orElse(null)", new Object[]{property.getName(), Optional.class, property.getName(), Collections.class});
                    break;
                }
                default: {
                    throw new IllegalStateException();
                }
            }
        });
        builderBuilder.addMethod(MethodSpec.constructorBuilder().addModifiers(new Modifier[]{Modifier.PUBLIC}).build()).addMethod(constructorBuilder.build());
    }

    private void generateDefaultGenerator(ValueDefinition value, TypeSpec.Builder builderBuilder) {
        builderBuilder.addMethod(MethodSpec.methodBuilder((String)"defaults").addModifiers(new Modifier[]{Modifier.PUBLIC}).returns(TypeName.get((TypeMirror)value.getBuilderElement().asType())).addParameter(TypeName.get((TypeMirror)value.getBuilderElement().asType()), "builder", new Modifier[0]).addStatement("return builder", new Object[0]).build());
    }

    private void generateFromSource(ValueDefinition value, TypeSpec.Builder builderBuilder) {
        MethodSpec.Builder fromSourceBuilder = MethodSpec.methodBuilder((String)"fromSource").addModifiers(new Modifier[]{Modifier.PUBLIC, Modifier.STATIC}).addTypeVariables(value.getTypeVariables()).addParameter(TypeName.get((TypeMirror)value.getElement().asType()), "source", new Modifier[0]).returns(TypeName.get((TypeMirror)value.getBuilderElement().asType())).addStatement("$L builder = new $T()", new Object[]{value.getTypeVariables().isEmpty() ? "Builder" : ParameterizedTypeName.get((ClassName)ClassName.bestGuess((String)"Builder"), (TypeName[])value.getTypeVariables().toArray(new TypeName[0])), TypeName.get((TypeMirror)value.getBuilderElement().asType())});
        value.getProperties().forEach(property -> {
            switch (property.getPropertyKind()) {
                case PLAIN: 
                case ARRAY: {
                    fromSourceBuilder.addStatement("builder.$L = source.$L()", new Object[]{property.getName(), property.getElement().getSimpleName().toString()});
                    break;
                }
                case OPTIONAL: 
                case OPTIONAL_ARRAY: {
                    fromSourceBuilder.addStatement("builder.$L = source.$L().orElse(null)", new Object[]{property.getName(), property.getElement().getSimpleName().toString()});
                    break;
                }
                case LIST: {
                    fromSourceBuilder.addStatement("builder.$L = $T.ofNullable(source.$L()).map($T::unmodifiableList).orElse(null)", new Object[]{property.getName(), Optional.class, property.getElement().getSimpleName().toString(), Collections.class});
                    break;
                }
                case SET: {
                    fromSourceBuilder.addStatement("builder.$L = $T.ofNullable(source.$L()).map($T::unmodifiableSet).orElse(null)", new Object[]{property.getName(), Optional.class, property.getElement().getSimpleName().toString(), Collections.class});
                    break;
                }
                case MAP: {
                    fromSourceBuilder.addStatement("builder.$L = $T.ofNullable(source.$L()).map($T::unmodifiableMap).orElse(null)", new Object[]{property.getName(), Optional.class, property.getElement().getSimpleName().toString(), Collections.class});
                    break;
                }
                default: {
                    throw new IllegalStateException();
                }
            }
        });
        builderBuilder.addMethod(fromSourceBuilder.addStatement("return ($T) builder", new Object[]{TypeName.get((TypeMirror)value.getBuilderElement().asType())}).build());
    }

    private void generateSetter(PropertyDefinition property, ValueDefinition value, TypeSpec.Builder builderBuilder) {
        String setterName = "set" + property.getName().substring(0, 1).toUpperCase() + property.getName().substring(1);
        MethodSpec.Builder setterBuilder = MethodSpec.methodBuilder((String)setterName).addModifiers(new Modifier[]{Modifier.PUBLIC}).returns(TypeName.get((TypeMirror)value.getBuilderElement().asType()));
        if (property.isOptional()) {
            setterBuilder.addParameter(ParameterSpec.builder((TypeName)TypeName.get((TypeMirror)property.getTypeArgument().orElseThrow(IllegalStateException::new)), (String)property.getName(), (Modifier[])new Modifier[0]).addAnnotation(Nullable.class).build());
        } else {
            setterBuilder.addParameter(TypeName.get((TypeMirror)property.getType()), property.getName(), new Modifier[0]);
        }
        setterBuilder.addStatement("$L builder = new $T()", new Object[]{value.getTypeVariables().isEmpty() ? "Builder" : ParameterizedTypeName.get((ClassName)ClassName.bestGuess((String)"Builder"), (TypeName[])value.getTypeVariables().toArray(new TypeName[0])), TypeName.get((TypeMirror)value.getBuilderElement().asType())});
        if (property.getElement().getAnnotation(Nullable.class) == null && !property.getType().getKind().isPrimitive()) {
            setterBuilder.beginControlFlow("if ($L == null)", new Object[]{property.getName()}).addStatement("throw new $T(\"Null $L\")", new Object[]{NullPointerException.class, property.getName()}).endControlFlow();
        }
        value.getProperties().forEach(valueProperty -> {
            if (valueProperty == property) {
                if (property.getPropertyKind() == PropertyKind.LIST) {
                    setterBuilder.addStatement("builder.$L = $T.ofNullable($L).map($T::unmodifiableList).orElse(null)", new Object[]{valueProperty.getName(), Optional.class, valueProperty.getName(), Collections.class});
                } else if (property.getPropertyKind() == PropertyKind.SET) {
                    setterBuilder.addStatement("builder.$L = $T.ofNullable($L).map($T::unmodifiableSet).orElse(null)", new Object[]{valueProperty.getName(), Optional.class, valueProperty.getName(), Collections.class});
                } else if (property.getPropertyKind() == PropertyKind.MAP) {
                    setterBuilder.addStatement("builder.$L = $T.ofNullable($L).map($T::unmodifiableMap).orElse(null)", new Object[]{valueProperty.getName(), Optional.class, valueProperty.getName(), Collections.class});
                } else {
                    setterBuilder.addStatement("builder.$L = $L", new Object[]{valueProperty.getName(), valueProperty.getName()});
                }
            } else {
                setterBuilder.addStatement("builder.$L = this.$L", new Object[]{valueProperty.getName(), valueProperty.getName()});
            }
        });
        builderBuilder.addMethod(setterBuilder.addStatement("return ($T) builder", new Object[]{TypeName.get((TypeMirror)value.getBuilderElement().asType())}).build());
        String witherName = "with" + property.getName().substring(0, 1).toUpperCase() + property.getName().substring(1);
        MethodSpec.Builder witherBuilder = MethodSpec.methodBuilder((String)witherName).addJavadoc("Wither for annotation-less Jackson Builder Pattern support. Do not use manually.", new Object[0]).addAnnotation(Deprecated.class).addModifiers(new Modifier[]{Modifier.PUBLIC}).returns(TypeName.get((TypeMirror)value.getBuilderElement().asType()));
        if (property.isOptional()) {
            witherBuilder.addParameter(ParameterSpec.builder((TypeName)TypeName.get((TypeMirror)property.getTypeArgument().orElseThrow(IllegalStateException::new)), (String)property.getName(), (Modifier[])new Modifier[0]).addAnnotation(Nullable.class).build());
        } else {
            witherBuilder.addParameter(TypeName.get((TypeMirror)property.getType()), property.getName(), new Modifier[0]);
        }
        witherBuilder.addStatement("return $L($L)", new Object[]{setterName, property.getName()});
        property.getElement().getAnnotationMirrors().stream().map(AnnotationSpec::get).forEach(arg_0 -> ((MethodSpec.Builder)witherBuilder).addAnnotation(arg_0));
        builderBuilder.addMethod(witherBuilder.build());
    }

    private void generateAccessor(PropertyDefinition property, TypeSpec.Builder builderBuilder) {
        MethodSpec.Builder accessorBuilder = MethodSpec.methodBuilder((String)property.getElement().getSimpleName().toString()).addModifiers(new Modifier[]{Modifier.PROTECTED}).returns(property.getType().getKind().isPrimitive() ? TypeName.get((TypeMirror)property.getType()).box() : TypeName.get((TypeMirror)property.getType()));
        switch (property.getPropertyKind()) {
            case PLAIN: {
                accessorBuilder.addStatement("return $L", new Object[]{property.getName()});
                break;
            }
            case OPTIONAL: {
                accessorBuilder.addStatement("return $T.ofNullable($L)", new Object[]{ClassName.get(Optional.class), property.getName()});
                break;
            }
            case ARRAY: {
                accessorBuilder.beginControlFlow("if ($L == null)", new Object[]{property.getName()}).addStatement("return null", new Object[0]).endControlFlow().addStatement("return $T.copyOf($L, $L.length)", new Object[]{ClassName.get(Arrays.class), property.getName(), property.getName()});
                break;
            }
            case OPTIONAL_ARRAY: {
                accessorBuilder.addStatement("return $T.ofNullable($L).map(val -> $T.copyOf(val, val.length))", new Object[]{ClassName.get(Optional.class), property.getName(), ClassName.get(Arrays.class)});
                break;
            }
            case LIST: {
                accessorBuilder.addStatement("return $T.ofNullable($L).map($T::unmodifiableList).orElse(null)", new Object[]{Optional.class, property.getName(), Collections.class});
                break;
            }
            case SET: {
                accessorBuilder.addStatement("return $T.ofNullable($L).map($T::unmodifiableSet).orElse(null)", new Object[]{Optional.class, property.getName(), Collections.class});
                break;
            }
            case MAP: {
                accessorBuilder.addStatement("return $T.ofNullable($L).map($T::unmodifiableMap).orElse(null)", new Object[]{Optional.class, property.getName(), Collections.class});
                break;
            }
            default: {
                throw new IllegalStateException();
            }
        }
        builderBuilder.addMethod(accessorBuilder.build());
    }

    private void generateBuild(ValueDefinition value, TypeSpec.Builder builderBuilder) {
        MethodSpec.Builder buildBuilder = MethodSpec.methodBuilder((String)"build").addModifiers(new Modifier[]{Modifier.PUBLIC}).returns(TypeName.get((TypeMirror)value.getElement().asType())).addStatement("$T missing = \"\"", new Object[]{String.class}).addStatement("$L defaults = defaults(new $T())", new Object[]{value.getTypeVariables().isEmpty() ? "Builder" : ParameterizedTypeName.get((ClassName)ClassName.bestGuess((String)"Builder"), (TypeName[])value.getTypeVariables().toArray(new TypeName[0])), TypeName.get((TypeMirror)value.getBuilderElement().asType())});
        value.getProperties().stream().filter(property -> !property.isOptional()).filter(property -> property.getElement().getAnnotation(Nullable.class) == null).forEach(property -> buildBuilder.beginControlFlow("if (this.$L == null && defaults.$L == null)", new Object[]{property.getName(), property.getName()}).addStatement("missing += \" $L\"", new Object[]{property.getName()}).endControlFlow());
        Object valueConstructorType = value.getTypeVariables().isEmpty() ? ClassName.bestGuess((String)value.getGeneratedName()) : ParameterizedTypeName.get((ClassName)ClassName.bestGuess((String)value.getGeneratedName()), (TypeName[])((TypeName[])value.getTypeVariables().toArray(new TypeVariableName[0])));
        buildBuilder.beginControlFlow("if (!missing.isEmpty())", new Object[0]).addStatement("throw new $T(\"Missing required properties:\" + missing)", new Object[]{IllegalStateException.class}).endControlFlow().addStatement("return new $T(\n" + value.getProperties().stream().map(prop -> {
            switch (prop.getPropertyKind()) {
                case PLAIN: 
                case ARRAY: {
                    return "this.$L != null ? this.$L : defaults.$L";
                }
                case OPTIONAL: 
                case OPTIONAL_ARRAY: {
                    return "Optional.ofNullable(this.$L).orElseGet(() -> Optional.ofNullable(defaults.$L).orElse(null))";
                }
                case LIST: {
                    return "this.$L != null ? $T.unmodifiableList(this.$L) : defaults.$L != null ? $T.unmodifiableList(defaults.$L) : null";
                }
                case SET: {
                    return "this.$L != null ? $T.unmodifiableSet(this.$L) : defaults.$L != null ? $T.unmodifiableSet(defaults.$L) : null";
                }
                case MAP: {
                    return "this.$L != null ? $T.unmodifiableMap(this.$L) : defaults.$L != null ? $T.unmodifiableMap(defaults.$L) : null";
                }
            }
            throw new IllegalStateException();
        }).collect(Collectors.joining(",\n")) + "\n)", Stream.of(Stream.of(valueConstructorType), value.getProperties().stream().flatMap(prop -> {
            switch (prop.getPropertyKind()) {
                case PLAIN: 
                case ARRAY: {
                    return Stream.generate(prop::getName).limit(3L);
                }
                case OPTIONAL: 
                case OPTIONAL_ARRAY: {
                    return Stream.generate(prop::getName).limit(2L);
                }
                case LIST: 
                case SET: 
                case MAP: {
                    return Stream.of(prop.getName(), Collections.class, prop.getName(), prop.getName(), Collections.class, prop.getName());
                }
            }
            throw new IllegalStateException();
        })).flatMap(s -> s).toArray());
        builderBuilder.addMethod(buildBuilder.build());
    }
}

