/*
 * Decompiled with CFR 0.152.
 */
package fi.jubic.easyvalue.processor;

import com.google.auto.service.AutoService;
import fi.jubic.easyvalue.EasyValue;
import fi.jubic.easyvalue.processor.DefinitionParser;
import fi.jubic.easyvalue.processor.ProcessingMessage;
import fi.jubic.easyvalue.processor.ProcessingResult;
import fi.jubic.easyvalue.processor.ValueGenerator;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.annotation.processing.AbstractProcessor;
import javax.annotation.processing.Messager;
import javax.annotation.processing.ProcessingEnvironment;
import javax.annotation.processing.Processor;
import javax.annotation.processing.RoundEnvironment;
import javax.annotation.processing.SupportedAnnotationTypes;
import javax.lang.model.SourceVersion;
import javax.lang.model.element.Element;
import javax.lang.model.element.TypeElement;
import javax.tools.Diagnostic;

@SupportedAnnotationTypes(value={"fi.jubic.easyvalue.EasyValue", "fi.jubic.easyvalue.EasyProperty"})
@AutoService(value={Processor.class})
public class EasyValueProcessor
extends AbstractProcessor {
    private Messager messager;

    @Override
    public synchronized void init(ProcessingEnvironment processingEnvironment) {
        super.init(processingEnvironment);
        this.messager = processingEnvironment.getMessager();
    }

    @Override
    public boolean process(Set<? extends TypeElement> set, RoundEnvironment roundEnvironment) {
        DefinitionParser definitionParser = new DefinitionParser();
        ValueGenerator valueGenerator = new ValueGenerator(this.processingEnv);
        List definitionResults = roundEnvironment.getElementsAnnotatedWith(EasyValue.class).stream().map(value -> definitionParser.parseValue(this.processingEnv, (Element)value)).collect(Collectors.toList());
        List<ProcessingMessage> messages = definitionResults.stream().flatMap(result -> result.messages().stream()).collect(Collectors.toList());
        if (messages.stream().anyMatch(message -> message.kind.equals((Object)Diagnostic.Kind.ERROR))) {
            messages.forEach(message -> this.messager.printMessage(message.kind, message.message));
            return true;
        }
        List generationMessages = definitionResults.stream().map(ProcessingResult::result).filter(Optional::isPresent).map(Optional::get).map(valueGenerator::generateValue).map(ProcessingResult::messages).flatMap(Collection::stream).collect(Collectors.toList());
        Stream.of(messages.stream(), generationMessages.stream()).flatMap(s -> s).forEach(message -> this.messager.printMessage(message.kind, message.message));
        return true;
    }

    @Override
    public SourceVersion getSupportedSourceVersion() {
        return SourceVersion.latestSupported();
    }
}

