/*
 * Decompiled with CFR 0.152.
 */
package fi.jubic.easyvalue.processor;

import fi.jubic.easyvalue.processor.ProcessingMessage;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import javax.annotation.Nullable;

interface ProcessingResult<T> {
    public Optional<T> result();

    public List<ProcessingMessage> messages();

    public static <T> ProcessingResult<T> of(final @Nullable T result, final List<ProcessingMessage> messages) {
        return new ProcessingResult<T>(){

            @Override
            public Optional<T> result() {
                return Optional.ofNullable(result);
            }

            @Override
            public List<ProcessingMessage> messages() {
                return messages;
            }
        };
    }

    public static <T> ProcessingResult<T> of(T result) {
        return ProcessingResult.of(result, Collections.emptyList());
    }

    public static <T> ProcessingResult<T> of(List<ProcessingMessage> messages) {
        return ProcessingResult.of(null, messages);
    }

    public static <T> ProcessingResult<T> of(ProcessingMessage message) {
        return ProcessingResult.of(null, Collections.singletonList(message));
    }
}

