/*
 * Decompiled with CFR 0.152.
 */
package fi.jubic.easyvalue.processor;

import fi.jubic.easyvalue.processor.PropertyKind;
import java.util.Optional;
import javax.annotation.Nullable;
import javax.lang.model.element.Element;
import javax.lang.model.type.TypeMirror;

class PropertyDefinition {
    private final Element element;
    private final String name;
    private final TypeMirror type;
    @Nullable
    private final TypeMirror typeArgument;
    private final PropertyKind propertyKind;

    PropertyDefinition(Element element, String name, TypeMirror type, @Nullable TypeMirror typeArgument, PropertyKind propertyKind) {
        this.element = element;
        this.name = name;
        this.type = type;
        this.typeArgument = typeArgument;
        this.propertyKind = propertyKind;
    }

    Element getElement() {
        return this.element;
    }

    String getName() {
        return this.name;
    }

    TypeMirror getType() {
        return this.type;
    }

    Optional<TypeMirror> getTypeArgument() {
        return Optional.ofNullable(this.typeArgument);
    }

    PropertyKind getPropertyKind() {
        return this.propertyKind;
    }

    boolean isOptional() {
        return this.propertyKind == PropertyKind.OPTIONAL || this.propertyKind == PropertyKind.OPTIONAL_ARRAY;
    }
}

