/*
 * Decompiled with CFR 0.152.
 */
package fi.jubic.easyvalue.processor;

import com.squareup.javapoet.AnnotationSpec;
import com.squareup.javapoet.ClassName;
import com.squareup.javapoet.CodeBlock;
import com.squareup.javapoet.JavaFile;
import com.squareup.javapoet.MethodSpec;
import com.squareup.javapoet.TypeName;
import com.squareup.javapoet.TypeSpec;
import fi.jubic.easyvalue.EasyValue;
import fi.jubic.easyvalue.processor.BuilderGenerator;
import fi.jubic.easyvalue.processor.EasyValueProcessor;
import fi.jubic.easyvalue.processor.ProcessingMessage;
import fi.jubic.easyvalue.processor.ProcessingResult;
import fi.jubic.easyvalue.processor.PropertyDefinition;
import fi.jubic.easyvalue.processor.ValueDefinition;
import java.io.IOException;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import javax.annotation.Generated;
import javax.annotation.processing.ProcessingEnvironment;
import javax.lang.model.element.ElementKind;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.Modifier;
import javax.lang.model.element.QualifiedNameable;
import javax.lang.model.type.TypeKind;
import javax.lang.model.type.TypeMirror;
import javax.tools.Diagnostic;

class ValueGenerator {
    private final ProcessingEnvironment processingEnv;

    ValueGenerator(ProcessingEnvironment processingEnv) {
        this.processingEnv = processingEnv;
    }

    ProcessingResult<Void> generateValue(ValueDefinition definition) {
        boolean hasBuilder;
        List<ProcessingMessage> messages = ProcessingMessage.list(new ProcessingMessage[0]);
        TypeSpec.Builder classBuilder = TypeSpec.classBuilder((String)definition.getGeneratedName()).addAnnotation(AnnotationSpec.builder(Generated.class).addMember("value", "\"" + EasyValueProcessor.class.getCanonicalName() + "\"", new Object[0]).addMember("date", "\"" + Instant.now().toString() + "\"", new Object[0]).build()).superclass(TypeName.get((TypeMirror)definition.getElement().asType())).addTypeVariables(definition.getTypeVariables());
        definition.getElement().getAnnotationMirrors().stream().filter(annotationMirror -> !EasyValue.class.getName().equals(((QualifiedNameable)annotationMirror.getAnnotationType().asElement()).getQualifiedName().toString())).map(AnnotationSpec::get).forEach(arg_0 -> ((TypeSpec.Builder)classBuilder).addAnnotation(arg_0));
        this.addModifiers(definition, classBuilder, messages);
        definition.getProperties().forEach(property -> this.generateField((PropertyDefinition)property, classBuilder));
        this.generateConstructor(definition, classBuilder);
        definition.getProperties().forEach(property -> this.generateAccessors((PropertyDefinition)property, classBuilder));
        this.generateToBuilder(definition, classBuilder, messages);
        this.generateToString(definition, classBuilder);
        this.generateEquals(definition, classBuilder);
        this.generateHashCode(definition, classBuilder);
        boolean bl = hasBuilder = definition.getBuilderElement() != null;
        if (hasBuilder) {
            new BuilderGenerator().generateBuilder(definition, classBuilder);
        }
        try {
            JavaFile.builder((String)this.processingEnv.getElementUtils().getPackageOf(definition.getElement()).getQualifiedName().toString(), (TypeSpec)classBuilder.build()).build().writeTo(this.processingEnv.getFiler());
        }
        catch (IOException e) {
            e.printStackTrace();
            messages.add(ProcessingMessage.of(Diagnostic.Kind.ERROR, "Could not write class", definition.getElement()));
        }
        return ProcessingResult.of(messages);
    }

    private void addModifiers(ValueDefinition value, TypeSpec.Builder classBuilder, List<ProcessingMessage> messages) {
        Set<Modifier> sourceModifiers = value.getElement().getModifiers();
        if (sourceModifiers.contains((Object)Modifier.PUBLIC)) {
            classBuilder.addModifiers(new Modifier[]{Modifier.PUBLIC});
        } else if (sourceModifiers.contains((Object)Modifier.PROTECTED)) {
            classBuilder.addModifiers(new Modifier[]{Modifier.PROTECTED});
        }
        if (!sourceModifiers.contains((Object)Modifier.ABSTRACT)) {
            messages.add(ProcessingMessage.of(Diagnostic.Kind.ERROR, "@EasyValue annotated class must be abstract", value.getElement()));
        }
        if (sourceModifiers.contains((Object)Modifier.PRIVATE)) {
            messages.add(ProcessingMessage.of(Diagnostic.Kind.ERROR, "@EasyValue annotated class cannot be private", value.getElement()));
        }
    }

    private void generateField(PropertyDefinition property, TypeSpec.Builder classBuilder) {
        if (property.isOptional()) {
            classBuilder.addField(TypeName.get((TypeMirror)property.getTypeArgument().orElseThrow(IllegalStateException::new)), property.getName(), new Modifier[]{Modifier.PRIVATE, Modifier.FINAL});
        } else {
            classBuilder.addField(TypeName.get((TypeMirror)property.getType()), property.getName(), new Modifier[]{Modifier.PRIVATE, Modifier.FINAL});
        }
    }

    private void generateConstructor(ValueDefinition value, TypeSpec.Builder classBuilder) {
        MethodSpec.Builder constructorBuilder = MethodSpec.constructorBuilder().addModifiers(new Modifier[]{Modifier.PUBLIC});
        value.getProperties().forEach(property -> {
            if (property.isOptional()) {
                constructorBuilder.addParameter(TypeName.get((TypeMirror)property.getTypeArgument().orElseThrow(IllegalStateException::new)), property.getName(), new Modifier[0]);
            } else {
                constructorBuilder.addParameter(TypeName.get((TypeMirror)property.getType()), property.getName(), new Modifier[0]);
            }
        });
        value.getProperties().forEach(property -> {
            switch (property.getPropertyKind()) {
                case PLAIN: 
                case OPTIONAL: {
                    constructorBuilder.addStatement("this.$L = $L", new Object[]{property.getName(), property.getName()});
                    break;
                }
                case ARRAY: 
                case OPTIONAL_ARRAY: {
                    constructorBuilder.beginControlFlow("if ($L != null)", new Object[]{property.getName()}).addStatement("this.$L = $T.copyOf($L, $L.length)", new Object[]{property.getName(), ClassName.get(Arrays.class), property.getName(), property.getName()}).nextControlFlow("else", new Object[0]).addStatement("this.$L = null", new Object[]{property.getName()}).endControlFlow();
                    break;
                }
                case LIST: {
                    constructorBuilder.addStatement("this.$L = $T.ofNullable($L).map($T::unmodifiableList).orElse(null)", new Object[]{property.getName(), Optional.class, property.getName(), Collections.class});
                    break;
                }
                case SET: {
                    constructorBuilder.addStatement("this.$L = $T.ofNullable($L).map($T::unmodifiableSet).orElse(null)", new Object[]{property.getName(), Optional.class, property.getName(), Collections.class});
                    break;
                }
                case MAP: {
                    constructorBuilder.addStatement("this.$L = $T.ofNullable($L).map($T::unmodifiableMap).orElse(null)", new Object[]{property.getName(), Optional.class, property.getName(), Collections.class});
                    break;
                }
                default: {
                    throw new IllegalStateException();
                }
            }
        });
        classBuilder.addMethod(constructorBuilder.build());
    }

    private void generateAccessors(PropertyDefinition property, TypeSpec.Builder classBuilder) {
        MethodSpec.Builder accessorBuilder = MethodSpec.overriding((ExecutableElement)((ExecutableElement)property.getElement()));
        switch (property.getPropertyKind()) {
            case PLAIN: {
                accessorBuilder.addStatement("return $L", new Object[]{property.getName()});
                break;
            }
            case OPTIONAL: {
                accessorBuilder.addStatement("return $T.ofNullable($L)", new Object[]{ClassName.get(Optional.class), property.getName()});
                break;
            }
            case ARRAY: {
                accessorBuilder.beginControlFlow("if ($L == null)", new Object[]{property.getName()}).addStatement("return null", new Object[0]).endControlFlow().addStatement("return $T.copyOf($L, $L.length)", new Object[]{ClassName.get(Arrays.class), property.getName(), property.getName()});
                break;
            }
            case OPTIONAL_ARRAY: {
                accessorBuilder.addStatement("return $T.ofNullable($L).map(val -> $T.copyOf(val, val.length))", new Object[]{ClassName.get(Optional.class), property.getName(), ClassName.get(Arrays.class)});
                break;
            }
            case LIST: {
                accessorBuilder.addStatement("return $T.ofNullable($L).map($T::unmodifiableList).orElse(null)", new Object[]{Optional.class, property.getName(), Collections.class});
                break;
            }
            case SET: {
                accessorBuilder.addStatement("return $T.ofNullable($L).map($T::unmodifiableSet).orElse(null)", new Object[]{Optional.class, property.getName(), Collections.class});
                break;
            }
            case MAP: {
                accessorBuilder.addStatement("return $T.ofNullable($L).map($T::unmodifiableMap).orElse(null)", new Object[]{Optional.class, property.getName(), Collections.class});
                break;
            }
            default: {
                throw new IllegalStateException();
            }
        }
        classBuilder.addMethod(accessorBuilder.build());
    }

    private void generateToBuilder(ValueDefinition value, TypeSpec.Builder classBuilder, List<ProcessingMessage> messages) {
        value.getElement().getEnclosedElements().stream().filter(element -> element.getSimpleName().toString().equals("toBuilder")).filter(element -> element.getKind().equals((Object)ElementKind.METHOD)).map(element -> (ExecutableElement)element).findFirst().ifPresent(toBuilder -> {
            if (!toBuilder.getParameters().isEmpty()) {
                messages.add(ProcessingMessage.of(Diagnostic.Kind.ERROR, "toBuilder method cannot take any parameters", value.getElement()));
            }
            if (!toBuilder.getModifiers().contains((Object)Modifier.ABSTRACT)) {
                messages.add(ProcessingMessage.of(Diagnostic.Kind.ERROR, "toBuilder must be abstract", value.getElement()));
            }
            if (toBuilder.getModifiers().contains((Object)Modifier.PRIVATE)) {
                messages.add(ProcessingMessage.of(Diagnostic.Kind.ERROR, "toBuilder cannot be private", value.getElement()));
            }
            classBuilder.addMethod(MethodSpec.overriding((ExecutableElement)toBuilder).addStatement("return ($T) $T.fromSource(this)", new Object[]{TypeName.get((TypeMirror)value.getBuilderElement().asType()), ClassName.bestGuess((String)"Builder")}).build());
        });
    }

    private void generateToString(ValueDefinition value, TypeSpec.Builder classBuilder) {
        boolean overridesToString = value.getElement().getEnclosedElements().stream().filter(element -> element.getKind().equals((Object)ElementKind.METHOD)).filter(element -> element.getSimpleName().toString().equals("toString")).map(element -> (ExecutableElement)element).filter(element -> String.class.getName().equals(element.getReturnType().toString())).anyMatch(element -> element.getParameters().isEmpty());
        if (overridesToString) {
            return;
        }
        classBuilder.addMethod(MethodSpec.methodBuilder((String)"toString").addAnnotation(Override.class).addModifiers(new Modifier[]{Modifier.PUBLIC}).returns((TypeName)ClassName.get(String.class)).addStatement(value.getProperties().stream().filter(property -> property.getType().getKind() != TypeKind.ARRAY).reduce(CodeBlock.builder().add("return \"$L{\"", new Object[]{value.getElement().getQualifiedName().toString()}), (block, property) -> block.add((block.toString().contains(",") ? "+ \", \" + " : " + ") + "\"$L=\" + $L", new Object[]{property.getName(), property.getName()}), (a, b) -> {
            throw new IllegalStateException();
        }).add("+ \"}\"", new Object[0]).build()).build());
    }

    private void generateEquals(ValueDefinition value, TypeSpec.Builder classBuilder) {
        boolean overridesEquals = value.getElement().getEnclosedElements().stream().filter(element -> element.getKind().equals((Object)ElementKind.METHOD)).filter(element -> element.getSimpleName().toString().equals("equals")).map(element -> (ExecutableElement)element).filter(element -> element.getReturnType().getKind().equals((Object)TypeKind.BOOLEAN)).map(element -> element.getParameters().get(0)).anyMatch(param -> Object.class.getCanonicalName().equals(param.asType().toString()));
        if (overridesEquals) {
            return;
        }
        classBuilder.addMethod(MethodSpec.methodBuilder((String)"equals").addAnnotation(Override.class).addModifiers(new Modifier[]{Modifier.PUBLIC}).addParameter((TypeName)ClassName.get(Object.class), "o", new Modifier[0]).returns(TypeName.BOOLEAN).beginControlFlow("if (o == this)", new Object[0]).addStatement("return true", new Object[0]).endControlFlow().beginControlFlow("if (!(o instanceof $T))", new Object[]{ClassName.bestGuess((String)value.getElement().getQualifiedName().toString())}).addStatement("return false", new Object[0]).endControlFlow().addStatement("$L that = ($L) o", new Object[]{value.getGeneratedName(), value.getGeneratedName()}).addStatement(value.getProperties().stream().reduce(CodeBlock.builder(), (block, property) -> block.add((block.isEmpty() ? "return " : "\n&& ") + "$T.equals(this.$L, that.$L())", new Object[]{property.getType().getKind() == TypeKind.ARRAY ? ClassName.get(Arrays.class) : ClassName.get(Objects.class), property.getName(), property.getElement().getSimpleName().toString()}), (a, b) -> {
            throw new IllegalStateException();
        }).build()).build());
    }

    private void generateHashCode(ValueDefinition value, TypeSpec.Builder classBuilder) {
        boolean overridesToHashCode = value.getElement().getEnclosedElements().stream().filter(element -> element.getKind().equals((Object)ElementKind.METHOD)).filter(element -> element.getSimpleName().toString().equals("hashCode")).map(element -> (ExecutableElement)element).filter(element -> element.getReturnType().getKind().equals((Object)TypeKind.INT)).anyMatch(element -> element.getParameters().isEmpty());
        if (overridesToHashCode) {
            return;
        }
        classBuilder.addMethod(MethodSpec.methodBuilder((String)"hashCode").addAnnotation(Override.class).addModifiers(new Modifier[]{Modifier.PUBLIC}).returns(TypeName.INT).addStatement("return $T.hash($L)", new Object[]{ClassName.get(Objects.class), value.getProperties().stream().map(PropertyDefinition::getName).collect(Collectors.joining(", "))}).build());
    }
}

