/*
 * Decompiled with CFR 0.152.
 */
package fi.jubic.snoozy.undertow;

import fi.jubic.snoozy.MultipartConfig;
import fi.jubic.snoozy.Server;
import fi.jubic.snoozy.ServerConfiguration;
import fi.jubic.snoozy.auth.Authentication;
import fi.jubic.snoozy.auth.UserPrincipal;
import fi.jubic.snoozy.filters.StaticFilesFilter;
import fi.jubic.snoozy.server.ApplicationAdapter;
import fi.jubic.snoozy.server.AuthFilterAdapter;
import fi.jubic.snoozy.server.AuthenticatedApplicationAdapter;
import fi.jubic.snoozy.staticfiles.StaticFiles;
import fi.jubic.snoozy.undertow.FilteredResourceHandler;
import io.undertow.Undertow;
import io.undertow.servlet.api.DeploymentInfo;
import jakarta.servlet.MultipartConfigElement;
import jakarta.ws.rs.ApplicationPath;
import jakarta.ws.rs.core.Application;
import java.util.Optional;
import java.util.Set;
import org.jboss.resteasy.core.ResourceMethodInvoker;
import org.jboss.resteasy.core.ResteasyContext;
import org.jboss.resteasy.core.ResteasyDeploymentImpl;
import org.jboss.resteasy.plugins.server.undertow.UndertowJaxrsServer;
import org.jboss.resteasy.spi.ResteasyDeployment;

public class UndertowServer
implements Server {
    private UndertowJaxrsServer server;

    public void start(ApplicationAdapter applicationAdapter, ServerConfiguration serverConfiguration) {
        this.server = this.startServer(applicationAdapter, serverConfiguration);
        this.addStaticFiles(this.server, applicationAdapter.getStaticFiles(), (staticFiles, request) -> Optional.empty());
    }

    public <P extends UserPrincipal> void start(AuthenticatedApplicationAdapter<P> applicationAdapter, ServerConfiguration serverConfiguration) {
        AuthFilterAdapter authFilterAdapter = AuthFilterAdapter.of((Authentication)applicationAdapter.getAuthentication(), crc -> ((ResourceMethodInvoker)crc.getProperty("org.jboss.resteasy.core.ResourceMethodInvoker")).getMethod(), ResteasyContext::pushContext);
        applicationAdapter.setAuthFilterAdapter(authFilterAdapter);
        this.server = this.startServer((ApplicationAdapter)applicationAdapter, serverConfiguration);
        this.addStaticFiles(this.server, applicationAdapter.getStaticFiles(), (StaticFilesFilter)authFilterAdapter);
    }

    public void stop() {
        this.server.stop();
    }

    private UndertowJaxrsServer startServer(ApplicationAdapter applicationAdapter, ServerConfiguration serverConfiguration) {
        UndertowJaxrsServer undertowJaxrsServer = new UndertowJaxrsServer();
        ResteasyDeploymentImpl deployment = new ResteasyDeploymentImpl();
        deployment.setApplication((Application)applicationAdapter);
        DeploymentInfo deploymentInfo = undertowJaxrsServer.undertowDeployment((ResteasyDeployment)deployment);
        deploymentInfo.setClassLoader(applicationAdapter.getClass().getClassLoader());
        String path = "/" + Optional.ofNullable(applicationAdapter.getApplicationClass().getAnnotation(ApplicationPath.class)).map(ApplicationPath::value).orElse("").replaceAll("^/", "");
        deploymentInfo.setContextPath(path);
        deploymentInfo.setDeploymentName("Snoozy" + path);
        MultipartConfig multipartConfig = serverConfiguration.getMultipartConfig();
        deploymentInfo.setDefaultMultipartConfig(new MultipartConfigElement(multipartConfig.getCacheLocation(), multipartConfig.getMaxFileSize(), multipartConfig.getMaxRequestSize(), multipartConfig.getSizeThreshold()));
        return undertowJaxrsServer.deploy(deploymentInfo).start(Undertow.builder().addHttpListener(serverConfiguration.getPort(), serverConfiguration.getHostname()));
    }

    private void addStaticFiles(UndertowJaxrsServer server, Set<StaticFiles> staticFilesSet, StaticFilesFilter filter) {
        staticFilesSet.forEach(staticFiles -> server.addResourcePrefixPath(staticFiles.getPath(), new FilteredResourceHandler(filter, (StaticFiles)staticFiles).addWelcomeFiles(new String[]{"index.html"})));
    }
}

